/** tsi_slider - an example for the tsi_sensor library
 *
 *  Read the capacitive touch slider of the FRDM-KL25Z board
 *  and control the power of the green LED accordingly.
 *
 *  Hardware requirements:
 *   - Freescale FRDM-KL25Z board
 */

#include "mbed.h"
#include "tsi_sensor.h"

int main(void) {
    PwmOut led(LED_GREEN);              //Configure PWM output for the green LED
    TSIAnalogSlider tsi(PTB16,PTB17,40);//Configure for the FRDM-KL25Z slider
    while (true) {
        float s = tsi.readPercentage(); //Read slider status
        led = 1.0 - s;                  //Control LED power
        wait(0.1);                      //wait a little...
    }
}