//Program zmodyfikowany. Instrukcja obsługi:
//Po włączeniu zasilania sterownika SMC (26V) i podłączeniu przewodu USB silnik zostaje zablokowany (ciężko go ruszyć)
// w celu ustawienia punktu początkowego trzymamy przycisk RESET na płytce FRDM (silnik obraca się łatwo)
// po ustawieniu punktu początkowego puszczamy przycisk RESET
// sterownik inicjalizuje program, zapisuje położenia zerowe czujników
// po odliczeniu 5 sekund wykonuje procedurę startową (przekręca silnik o połowę ustawionego zakresu i 
// zmienia stan wyjścia direction
// następnie wykonywane są przerwania pomiaru i sterowania
//
// na oscyloskopie widać, że wysyłanie danych pomiarowych nie wpływa na sterowanie silnikiem (wyjście direction) i sygnał PWM
//
// dołączenie dodatkowego kanału dla górnego czujnika nic nieda, ponieważ sygnał jest odwrócony w fazie o 180 stopni, 
// a nie przesunięty w fazie- nie da się na jego podstawie ustlić kierunku obrotu ani osiągnięcia pełnego obrotu 
// ciała swobodnego

#include "mbed.h"
#include "BufferedSerial.h"
#include "math.h"

//=========TERMISTOR==================
#define beta 3950      // stała materiałowa termistora [K]
#define T0 298         // temperatura odniesienia (zwykle 298K) [K]
#define R0 10000       // rezystancja termistora w temperaturze odniesienia [Ω]
#define R 16700        // rezystancja opornika w dzielniku [Ω]


Ticker triger1;                                             //interrupt. No. 1
Ticker triger2;                                             //interrupt No. 2

int motor_PWM_period_us = 500;                              //period of PWM signal in mikroseconds
                                                            // 3200 kroków to pełny kąt                
int EXC_angle = 1600/2/4;                                     //360 stopni to 3200 krok. przy mkrok. = 1.8/16 dzielic przez 2
//float switch_dir_time=(float)((float)EXC_angle/500.0)*((float)motor_PWM_period_us/1000.0);  
float switch_dir_time=(float)((float)EXC_angle/500.0)*((float)motor_PWM_period_us/1000.0);  
//float switch_dir_time = 1;
float sampling_time = 0.2;//0.005
int samples_in_period = int(switch_dir_time/sampling_time);
int zero_analog_IN_0 = 0;
int zero_analog_IN_1 = 0;
int zero_analog_IN_2 = 0;
int zero_analog_IN_3 = 0;
int zero_analog_IN_4 = 0;
int zero_analog_IN_5 = 0;
float timet = 0;

//volatile float t;
 
DigitalOut direction(PTC7);                                 // zmiana wartości logicznej na wyjściu PTC7 powoduje zmianę kieruneku obrotów
DigitalOut enable_driver(PTE2);                                // zezwolenie na start
DigitalOut myled(LED_GREEN);                                // dioda zielona sygnalizuje zmianę kierunku obrotów
AnalogIn analog_IN_0(PTB0);  //PTB0                               // odczyt napięcia z wejścia analogowego 0 (kąt obrotu kolumny)
AnalogIn analog_IN_1(PTB1);  //PTB1
AnalogIn analog_IN_2(PTB2);  //PTB2                                                            // PTB1 - sygnał odwrócony
AnalogIn analog_IN_3(PTB3);  //PTB3
AnalogIn analog_IN_4(PTC2);  //PTC2
AnalogIn analog_IN_5(PTC1);  //PTC1                               // odczyt napięcia z wejścia analogowego 1 (kąt obrotu ciała swobodnego)
                                                            // PTB3 - sygnał odwrócony
PwmOut motor(PTA5);                                         // sygnał PWM do sterowania sterownikiem silnika krokowego
//Serial pc(USBTX,USBRX);                                     // komunikacja z PC
BufferedSerial pc(USBTX,USBRX);
char buffer[24];

float get_voltage_in(AnalogIn analog_in, float zero_analog_in) {
    return (analog_in.read() - zero_analog_in) * 2.9035;    // przesunięcie do zera i skalowanie napiecia do zakresu
}

float temperatura_K(AnalogIn analog){
    float t=1.65-analog;    //1,65 połowa zakresu VREF
    t= t/analog;
    t= log(t);
    t=t + beta/T0+ 0,23;    //0,23 - log R/R0
    t=beta/t;
    return t;
}
    

void task1() { 
        myled = !myled;
        direction = !direction;
        //pc.printf("%.2f\t%d\n\r", timet, int(direction));
} 

void task2() { 
    //get_voltage_in(analog_IN_0, zero_analog_IN_0);
    //get_voltage_in(analog_IN_1, zero_analog_IN_1);    
    //pc.printf("%.2f\t%.2f\t%.2f\n\r", timet, get_voltage_in(analog_IN_1, zero_analog_IN_1), get_voltage_in(analog_IN_0, zero_analog_IN_0));
    //pc.printf("%.2f %.2f %.2f\n\r", timet, get_voltage_in(analog_IN_1, zero_analog_IN_1), get_voltage_in(analog_IN_0, zero_analog_IN_0));
    
    sprintf((char*)buffer, "%.2f %.2f %.2f %.2f %.2f %.2f\n\r",get_voltage_in(analog_IN_5, zero_analog_IN_5), get_voltage_in(analog_IN_4, zero_analog_IN_4),
    get_voltage_in(analog_IN_3, zero_analog_IN_3), get_voltage_in(analog_IN_2, zero_analog_IN_2),
    get_voltage_in(analog_IN_1, zero_analog_IN_1), get_voltage_in(analog_IN_0, zero_analog_IN_0));    
    pc.printf(buffer);

    //sprintf((char*)buffer, " %.2f %.2f\n\r",temperatura_K(analog_IN_1), get_voltage_in(analog_IN_0, zero_analog_IN_0));    
    //pc.printf(buffer);
    
    //pc.printf("%.2f", t);
    
    timet += sampling_time;
}

int main() {    
    pc.baud(115200);                                        // największa szybkość standardowa, jaką można zadać to 19200 
                                                            // im większa prędkość transmisji tym mniejsze czasy wysyłania- więcej niż 115200 nie osiągalne 
                                                            // dla 115200 mamy mniejsze czasy wysyłania (możemy wysyłać częściej- co 10ms)
    enable_driver = 1;                                         // enable signal to allow the driver for work
    zero_analog_IN_0 = analog_IN_0.read();
    zero_analog_IN_1 = analog_IN_1.read();    
    //pc.printf("Switch direction time: %.6f\n\r", switch_dir_time);
    //pc.printf("Samples in period: %d\n\r", samples_in_period);
    //pc.printf("Sampling time: %.6f\n\r", sampling_time);
    wait(6);                                                //czas na ustawienia początkowe 10 sek.   
    motor.period_us(motor_PWM_period_us);
    motor = 0.5;                                            // duty cycle of the PWM signal
    timet = 0.0;
    //wait(switch_dir_time/2);                                // położenie zerowe silnika do ustalenia zer czujników
    //wait_ms(1800);
    direction = !direction;                                 // i uruchomienie silnika
    switch_dir_time = 0.9;
    triger2.attach(&task2, sampling_time);
    triger1.attach(&task1, switch_dir_time);  

    while (true) {
        wait(10);                                           // zajęcie sterownika, zabezpieczenie przed zawieszeniem pracy sterownika
    }
}