/*
 * PIDControl.h
 *
 *  Created on: 16.04.2017
 *      Author: chris
 */

#ifndef COMMON_PID_CONTROL_H_
#define COMMON_PID_CONTROL_H_

/**
 * This class calculates a PID control
 */
class PID_Control
{
public:
    PID_Control();   // constructor
    virtual ~PID_Control();   //destructor

    float calc(float e, float period); 
    void setPIDValues(float p, float i, float d, float max, float min, float _iMax);

private:
    /**
     * the proportional gain
     */
    float kp;

    /**
     * integral gain
     */
    float ki;

    /**
     * differential gain
     */
    float kd;

    /**
     * Sum of all the errors
     */
    float iSum;

    /**
     * Error value one iteration befor
     */
    float eOld;
    
    float max;
    float min;
    float iMax;
    
};

#endif /* COMMON_PID_CONTROL_H_ */
