/*
 * Brobot.h
 *
 */

#ifndef BROBOT_H_
#define BROBOT_H_

#include <cstdlib>
#include <mbed.h>

/**
 * This is a device driver class to drive the robot autonomously
 */
class Brobot
{

public:
    // constructors have same name as the class
    Brobot(PwmOut* left, PwmOut* right, int number);
    Brobot();  //empty constructor
    

 //   void        init(PwmOut* left, PwmOut* right, int number);
    void        turnleft();
    void        turnright();
    void        forward();
    void        back();
    void        stop();
    void        slow(float ammount);  // ammount is subtracted from current speeds
    void        rotate(float ammount); // values from -0.5 to 0.5
    
private:
    PwmOut*     pwmL;
    PwmOut*     pwmR;
    int         number;
};

#endif /* BROBOT_H_ */
