/*
 * BROBOT.cpp
 *
 */

#include <cmath>
#include "Brobot.h"


Brobot::Brobot(PwmOut* left, PwmOut* right, int number)
{
    pwmL = left;  // set local references to objects
    pwmR = right;

    this->number = number;
}

// empty constructor
Brobot::Brobot()
{}

void Brobot::rotate( float phi)
{
    if(phi>0.5f || phi<-0.5f) {
        phi=0;
    }

    *pwmL = 0.5f + phi;
    *pwmR = 0.5f + phi;
}

void Brobot::forward()
{
    *pwmL=0.65f;  // asterisk is dereferencing the pointer so
    *pwmR=0.36f;  // you can access the variable at the pointers address
    // also another way to dereference the pointer is: pwmR->write(0.xx)
}

void Brobot::slow(float scale)
{
    if(scale>0.5f || scale<-0.5f) {
        scale=0;
    }

    *pwmL = *pwmL - scale;
    *pwmR = *pwmR + scale;
}

void Brobot::turnleft()
{
    *pwmL=0.48f;
    *pwmR=0.31f;
    wait(0.1);
}

void Brobot::turnright()
{
    *pwmL=0.69f;
    *pwmR=0.52f;
    wait(0.1);
}

void Brobot::back()
{
    *pwmR=0.65f;
    *pwmL=0.35f;
}

void Brobot::stop()
{
    *pwmR=0.5f;
    *pwmL=0.5f;
}