/* UniServ Servo Library
 * Copyright (c) 2010 Matt Parsons
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 #include "mbed.h"
 #include "UniServ.h"
 
    UniServ::UniServ(PinName pin) : ServPin(pin){
        Period=20000;
        Position=1500;
        ServMin=400;
        ServMax=2600;
    
      Pulse.attach_us( callback(this,&UniServ::SigStart), Period);
     }
 
    void UniServ::SigStart(){
        ServPin=1;
        PulseEnd.attach_us( callback( this, &UniServ::SigStop), Position);   
     }
 
    void UniServ::SigStop(){
        ServPin=0;
     }
 
    void UniServ::write_us(int PosIn){
        Position=PosIn;
        if(PosIn<ServMin){Position=ServMin;}
        if(PosIn>ServMax){Position=ServMax;}
     }
     
     int UniServ::read_us(){
        return Position;
     }
        
 
 