/*
 * SpeedControl.h
 */

#ifndef SPEED_CONTROL_H_
#define SPEED_CONTROL_H_

#include <cstdlib>
#include <mbed.h>
#include "EncoderCounter.h"
#include "LowpassFilter.h"

class SpeedControl
{

public:

                SpeedControl(PwmOut* pwmLeft, PwmOut* pwmRight, EncoderCounter* counterLeft, EncoderCounter* counterRight);     // constructor  
    virtual     ~SpeedControl();        //destructor    
    
    void        speedCtrl();
    void        setDesiredSpeed( float L, float R);

    LowpassFilter speedLeftFilter;
    LowpassFilter speedRightFilter;

private:

    //static allows you to initialize variables within the header
    static const float PERIOD = 0.002f;                    // period of control task, given in [s]
    static const float COUNTS_PER_TURN = 1200.0f;          // resolution of encoder counter
    static const float LOWPASS_FILTER_FREQUENCY = 300.0f;  // frequency of lowpass filter for actual speed values, given in [rad/s]
    static const float KN = 40.0f;                         // speed constant of motor, given in [rpm/V]
    static const float KP = 0.2f;                          // speed controller gain, given in [V/rpm]
    //static const float KI = 0.1f;                          //speed controller integral term gain [V/rpm]
    static const float MAX_VOLTAGE = 12.0f;                // supply voltage for power stage in [V]
    static const float MIN_DUTY_CYCLE = 0.02f;             // minimum allowed value for duty cycle (2%)
    static const float MAX_DUTY_CYCLE = 0.98f;             // maximum allowed value for duty cycle (98%)

    DigitalOut* enableMotorDriver;
    PwmOut* pwmLeft;
    PwmOut* pwmRight;
    EncoderCounter* counterRight;
    EncoderCounter* counterLeft;
    Ticker t2;

    short previousValueCounterRight ;  // was = 0
    short previousValueCounterLeft;     // same

    float desiredSpeedLeft;
    float desiredSpeedRight;

    float actualSpeedLeft;
    float actualSpeedRight;
};

#endif /* SPEED_CONTROL_H_ */
