#include "Pixy.h"
 
Pixy::Pixy(Serial& _cam) : cam(_cam), detects(0)
{
    cam.baud( 230400 );
    //cam.baud( 460800 );
    cam.attach(this, &Pixy::rxCallback, Serial::RxIrq);
}
 
 
// This function is called when a character goes into the RX buffer.
void Pixy::rxCallback()
{
    static const int buffersize = 256;
    static int startPoint = 0;
    static uint8_t buffer[buffersize] = {};
    static bool startFound = false;
    static int ii = 1;
 
    while( cam.readable() ) {
        buffer[ii] = cam.getc();
        if( buffer[ii-1] == 85  && (buffer[ii] == 170 )  ) {
            startPoint = ii-1;
 
            //check if detection was on the edge of buffer. Skip package if so.
            if( ii<(buffersize-14))
                startFound = true;
            else
                ii = 1;
 
            detects++;
        }
        ++ii;
 
        //reset ii
        if( ii>=(buffersize-1))
            ii = 1;
    }
 
    //start not found, reset ii to 1
    if( !startFound && ii >= 3 || ii >= (buffersize-1)) {
        ii = 1;
        return;
    }
 
    //start is found but not enough bytes received - return
    if( (ii-startPoint) <= 13 )
        return;
 
    //copy memory to pixy struct
    memcpy( &pixy, buffer + startPoint+2, 12);
 
    //reset variables
    startFound = false;
    ii = 1;
}
 
/**
returns the width of the detected object
**/
int Pixy::getWidth(  )
{
    return pixy.width;
}
 
/**
returns the height of the detected object
**/
int Pixy::getHeight(  )
{
    return pixy.height;
}
 
/**
returns the Y coordinates in respect to the pixy recorded image
**/
int Pixy::getY( )
{
    return pixy.y;
}
 
/**
returns the Y coordinates in respect to the pixy recorded image
**/
int Pixy::getX(  )
{
    return pixy.x;
}
 
 
/**
returns the signature of the detected object
**/
int Pixy::getSignature()
{
    return pixy.signature;
}
 
/**
returns 1 if an object has detectd
**/
bool Pixy::objectDetected()
{
    bool ret = false;
    static int oldDetection = 0;
    ret = (detects != oldDetection);
    oldDetection = detects;
    return ret;
}