/*
 * IRSensor.h
 * Copyright (c) 2016, ZHAW
 * All rights reserved.
 */

#ifndef IR_SENSOR_H_
#define IR_SENSOR_H_

#include <cstdlib>
#include <mbed.h>

/**
 * This is a device driver class to read the distance measured with a Sharp IR sensor.
 */
class IRSensor
{

public:
    // constructors have same name as the class
    IRSensor(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
    IRSensor();
    
    void        init(AnalogIn* distance, DigitalOut* bit0, DigitalOut* bit1, DigitalOut* bit2, int number);
    virtual     ~IRSensor();   // deconstructor
    float       read();

    operator float();

private:

    AnalogIn*       distance;
    DigitalOut*     bit0;
    DigitalOut*     bit1;
    DigitalOut*     bit2;

    int             number;
};

#endif /* IR_SENSOR_H_ */
