/*
 * Brobot.h
 *
 */

#ifndef BROBOT_H_
#define BROBOT_H_

#include <cstdlib>
#include <mbed.h>
#include "SpeedControl.h"
#include "PID_Control.h"
#include "IRSensor.h"
#include "Pixy.h"
#include "UniServ.h"

/**
 * This is a device driver class to drive the robot autonomously
 */
class Brobot
{

public:
    // constructors have same name as the class
    Brobot(SpeedControl& speedctrl, AnalogIn& distance, DigitalOut& enable, DigitalOut& bit0, DigitalOut& bit1, DigitalOut& bit2, DigitalOut* leds, Pixy& pixy, UniServ& servo);

    void        avoidObstacleAndMove(int vtrans);
    void        startLeds();
    void        ledShow();
    void        ledDistance();
    void        forward();
    void        back();
    void        stop();
    void        rotate(int ammount); //
    int         rotateAndApproach();
    bool        approachHome();
    void        closeGrip();
    void        openGrip();
    bool        foundGreenBrick();
    bool        foundHome();
    

private:

    SpeedControl& speedctrl;
    AnalogIn& distance;
    DigitalOut& enable;
    DigitalOut& bit0;
    DigitalOut& bit1;
    DigitalOut& bit2;
    IRSensor sensor_front; // uses the default constructor because no arguments given
    IRSensor sensor_left;
    IRSensor sensor_right;
    DigitalOut* leds;  //0 to 5
    IRSensor sensors[6];
    Ticker t1;
    PID_Control pid;
    PID_Control pixypid;
    PID_Control pixypidS;
    Pixy& pixy;
    UniServ& servo;
    float e ;

};

#endif /* BROBOT_H_ */
