#include "mbed.h"
#include "motor.h"

Motor motor1(D5, D4);
DigitalOut motor_mode(D13);
InterruptIn iin(D12);
Ticker timer1;
Ticker timer2;

void PGsensor()
{
    motor1.count();
}

void rpm_of_motor()
{
    motor1.calc_rpm();
}

void control_motor()
{
    motor1.drive();
}

int main()
{
    motor1.Set_target(3000);
    motor1.Set_phase(1);
    
    iin.rise(&PGsensor);
    iin.fall(&PGsensor);

    timer1.attach(&rpm_of_motor, motor1.MEASUREMENT_INTERVAL);
    timer2.attach(&control_motor, motor1.MEASUREMENT_INTERVAL);
}