#include "mbed.h"
#include "Quaternion.h"
#include <math.h>

Quaternion::Quaternion()
{
    w = 1;
    x = 0;
    y = 0;
    z = 0;
}

Quaternion::Quaternion(double x1, double x2, double x3, double x4)
{
    w = x1;
    x = x2;
    y = x3;
    z = x4;
}

Quaternion Quaternion::operator + (Quaternion p)
{
    Quaternion q;
    q.w = w + p.w;
    q.x = x + p.x;
    q.y = y + p.y;
    q.z = z + p.z;

    return q;
}

Quaternion Quaternion::operator+=(Quaternion p)
{
    w += p.w;
    x += p.x;
    y += p.y;
    z += p.z;

    return *this;
}

Quaternion Quaternion::operator * (double s)
{
    Quaternion q;
    q.w = w * s;
    q.x = x * s;
    q.y = y * s;
    q.z = z * s;

    return q;
}

Quaternion Quaternion::operator * (Quaternion p)
{
    Quaternion q;
    q.w = w * p.w - x * p.x - y * p.y - z * p.z;
    q.x = w * p.x + x * p.w + y * p.z - z * p.y;
    q.y = w * p.y - x * p.z + y * p.w + z * p.x;
    q.z = w * p.z + x * p.y - y * p.x + z * p.w;

    return q;
}

Quaternion Quaternion::operator*=(double s)
{
    w *= s;
    x *= s;
    y *= s;
    z *= s;
    return *this;
}

Quaternion Quaternion::operator*=(Quaternion p)
{
    w = w * p.w - x * p.x - y * p.y - z * p.z;
    x = w * p.x + x * p.w + y * p.z - z * p.y;
    y = w * p.y - x * p.z + y * p.w + z * p.x;
    z = w * p.z + x * p.y - y * p.x + z * p.w;
    return *this;
}

Quaternion Quaternion::operator / (double s)
{
    Quaternion q;
    q.w = w / s;
    q.x = x / s;
    q.y = y / s;
    q.z = z / s;

    return q;
}

Quaternion Quaternion::operator/=(double s)
{
    w /= s;
    x /= s;
    y /= s;
    z /= s;
    return *this;
}

Quaternion Quaternion::conjugate(void)
{
    Quaternion q;
    q.w = w;
    q.x = -x;
    q.y = -y;
    q.z = -z;
    return q;
}

double Quaternion::norm(void)
{
    return sqrt(w * w + x * x + y * y + z * z);
}