/*
宣言方法
BMX055 bmx(SDA_pin,SCL_pin);

bmx.Get_acc();
bmx.Get_gyro();
bmx.Get_mag();    で値をゲット

値は
bmx.accel[3];
bmx.gyroscope[3];
bmx.magnet[3];      に入っている
*/

#ifndef BMX055_H_
#define BMX055_H_

#include "mbed.h"
#include "Quaternion.h"

#define ACC 0x19<<1
#define GYRO 0x69<<1
#define MAG 0x13<<1



class BMX055
{
public:
    BMX055(PinName SDA, PinName SCL);
    static const float ACC_BIAS[3];
    static const float ACC_GAIN[3];

    Quaternion posture;

    Quaternion initial_mag;

    Quaternion initial_acc;

    void Update_posture();

    void mag_calibration(DigitalIn button);

    /*void Get_acc(void);
    void Get_gyro(void);
    void Get_mag(void);*/

    void set_initial_mag(void);

    void set_initial_acc(void);

    float get_azimuth_machineframe(void);
private:
    I2C bmx055;
    void bmx_init(void);

    void Get_acc(void);
    void Get_gyro(void);
    void Get_mag(void);

    float accel[3];
    float gyroscope[3];
    float magnet[3];
    Timer timer;
    double before_time;

    double acc_biases[3] = { -0.3033175,-1.0404895,-0.0261225 };
    double acc_gains[3] = { 1.006541011,0.994069761,0.992982982 };
    double gyro_biases[3] = { -3.453e-3, 3.81e-4, -2.35e-3 };
    double gyro_gains[3] = { 1,1,1 };
    float mag_biases[3] = { 0,0,0 };
    float mag_gains[3] = { 1,1,1 };
};



#endif