#include "mbed.h"
//フォトインタラプタ用パルスカウントプログラム
class Counter {
public:
    Counter(PinName pin) : _interrupt(pin) {        // create the InterruptIn on the pin specified to Counter
        _interrupt.rise(this, &Counter::increment); // attach increment function of this counter instance
    }
 
    void increment() {
        _count++;
    }
 
    int read() {
        return _count;
    }
 
private:
    InterruptIn _interrupt;
    volatile int _count;
};

Counter counter(A1);
PwmOut mypwm(D3);
DigitalOut dig(D6);

int main() {
        int pre_c = 0;          //前回の値を格納する変数
        mypwm.period(0.01);     //モータのパルス波周期[s]
        dig = 1;            //デジタル信号
        mypwm.write(0.5);       //PWM信号デューティ比
        
    while(1){
        printf("Count so far: %d\n", counter.read()-pre_c);
        pre_c = counter.read();
        wait(2);
    }
}