#include "mbed.h"
 
#define T_MS 500                                 // Define the time between reads
#define VRx A0                                   // Define the input pin for VRx pin
#define VRy A1                                   // Define the input pin for VRy pin
#define SW D5                                    // Define the input pin for SW pin
 
int main()
{
    AnalogIn x_axis(VRx);                       // Create the analog x movement object
    AnalogIn y_axis(VRy);                       // Create the analog y movement object
    DigitalIn button(SW, PullUp);               // Create the digital button object and setup internall pull-up resistor
 
    while(1)
    {   
        printf("\n");
        printf("\n X axis: %f", x_axis.read()); // Show the value of the X axis (0.0 to 1.0)
        printf("\n Y axis: %f", y_axis.read()); // Show the value of the Y axis (0.0 to 1.0)
        printf("\n Button: %d", button.read()); // Show the button status (0 is pressed, 1 is not pressed)
        
        wait_ms(T_MS);                          // Wait time between reads
    }
}