/* Includes ------------------------------------------------------------------*/

/* mbed specific header files. */
#include "mbed.h"

/* Helper header files. */
#include "DevSPI.h"

/* Component specific header files. */
#include "L6474.h"


/* Definitions ---------------------------------------------------------------*/

/* Number of steps. */
#define STEPS 2400


/* Delay in milliseconds. */
#define DELAY_1 2000
#define DELAY_2 6000
#define DELAY_3 8000

/* Speed in pps (Pulses Per Second).
   In Full Step mode: 1 pps = 1 step/s).
   In 1/N Step Mode:  N pps = 1 step/s). */
#define SPEED_1 2400
#define SPEED_2 1200

/* Joystick */

#define T_MS 500                                 // Define the time between reads
#define VRx A0                                   // Define the input pin for VRx pin
#define VRy A1                                   // Define the input pin for VRy pin
#define SW D5                                    // Define the input pin for SW pin

/* Variables -----------------------------------------------------------------*/

/* Motor Control Component. */
L6474 *motor1;
L6474 *motor2;

int main(){   
    /* Initializing SPI bus. */
    DevSPI dev_spi(D11, D12, D13);

    /* Initializing Motor Control Components. */
    motor1 = new L6474(D2, D8, D7, D9, D10, dev_spi);
    motor2 = new L6474(D2, D8, D4, D3, D10, dev_spi);
    if (motor1->init() != COMPONENT_OK) {
        exit(EXIT_FAILURE);
    }
    if (motor2->init() != COMPONENT_OK) {
        exit(EXIT_FAILURE);
    }

    AnalogIn x_axis(VRx);                       // Create the analog x movement object
    AnalogIn y_axis(VRy);                       // Create the analog y movement object
    DigitalIn button(SW, PullUp);               // Create the digital button object and setup internall pull-up resistor
 
    while(1)
    {   
        printf("\n");
        printf("\n X axis: %f", x_axis.read()); // Show the value of the X axis (0.0 to 1.0)
//        x = x_axis.read();
        printf("\n Y axis: %f", y_axis.read()); // Show the value of the Y axis (0.0 to 1.0)
//        y = y_axis.read();
//the button status (0 is pressed, 1 is not pressed)    
    
        /*----- Movendo pra frente -----*/

        /* Printing to the console. */
        if (x_axis.read()>0.6){
            /* Moving N steps in the forward direction. */
            printf("--> Moving forward Motor 1");
            motor1->run(StepperMotor::FWD);
            }
        if (y_axis.read()>0.6){
            printf("--> Moving forward Motor 2");
            motor2->run(StepperMotor::FWD);
            }
    
        int position1 = motor1->get_position();
        int position2 = motor2->get_position();
        //printf("    Position: Motor 1 %d, Motor 2 %d.\r\n", position1, position2);
    
        /*----- Movendo pra trás -----*/
        if (x_axis.read()<0.4){
            /* Moving N steps in the backward direction. */
            printf("--> Moving X backward Motor 1");
            motor1->run(StepperMotor::BWD);
            }
        if (y_axis.read()<0.4){
            printf("--> Moving Y backward Motor 2");
            motor2->run(StepperMotor::BWD);
            }
        if (0.4<x_axis.read() and x_axis.read()<0.6){
            printf("--> Parado motor 1");
            motor1->soft_stop();
            }
        if (0.4<y_axis.read() and y_axis.read()<0.6){
            printf("--> Parado motor 2");
            motor2->soft_stop();
            }
    }
}