/**
 * MBC003 - BusOut
 * This example use the BusOut function with a 7-Segment Display
 * 6 Jun 2018 - Mbed Colombia - http://mbedcolombia.wordpress.com/
 *
 * Board: ST-Nucleo-F446RE - https://os.mbed.com/platforms/ST-Nucleo-F446RE/
 *
 * Copyright [2018] [Leandro Perez Guatibonza / leandropg AT gmail DOT com]
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *    http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"

// Define GPIO Pins 7-Segment Display
// PA_10 --> A
// PB_3  --> B
// PB_5  --> C
// PB_4  --> D
// PB_10 --> E
// PA_8  --> F
// PA_9  --> G
BusOut display7Seg(PA_9, PA_8, PB_10, PB_4, PB_5, PB_3, PA_10);

// Define Logic Anode Comun Display
//                        ABCDEFG
int anodeComun[16] = {  0b0000001,      // 0
                        0b1001111,      // 1
                        0b0010010,      // 2
                        0b0000110,      // 3
                        0b1001100,      // 4
                        0b0100100,      // 5
                        0b0100000,      // 6
                        0b0001111,      // 7
                        0b0000000,      // 8
                        0b0001100,      // 9
                        0b0001000,      // A
                        0b1100000,      // B
                        0b1110010,      // C
                        0b1000010,      // D
                        0b0110000,      // E
                        0b0111000 };    // F  

// Main Loop runs in its own thread in the OS
int main() {
   
    // Inifite Loop
    while(1) {
        
        // Iterate 0x0 to 0xF --> 
        for(int i = 0; i < 16; i++) {
         
            // Export data to Bus
            display7Seg = anodeComun[i];
         
            // Wait 500 millisecond
            wait_ms(500);
        }        
    }
}