/*******************************************************************************
 * Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
#include "max77756.h"
 
/***** Definitions *****/
#define I2C_ADDR            (0x1E<<1)
 
//******************************************************************************
MAX77756::MAX77756(PinName sda, PinName scl)
{
    i2c_ = new I2C(sda, scl);
    i2c_owner = true;
 
    i2c_->frequency(400000);
}
 
//******************************************************************************
MAX77756::MAX77756(I2C *i2c) :
    i2c_(i2c)
{
    i2c_owner = false;
}
 
//******************************************************************************
MAX77756::~MAX77756()
{
    if(i2c_owner) {
        delete i2c_;
    }
}
 
//******************************************************************************
int32_t MAX77756::init()
{ 
    return 0;
}
 
//******************************************************************************
int32_t MAX77756::writeReg(MAX77756::registers_t reg_addr, char reg_data)
{
    char data[2];
 
    data[0] = reg_addr;
    data[1] = reg_data;
    if (i2c_->write(I2C_ADDR, data, 2) != 0) {
        return -1;
    }
 
    return 0;
}
 
//******************************************************************************
int32_t MAX77756::readReg(MAX77756::registers_t reg_addr)
{
    char data;
 
    data = reg_addr;
    if (i2c_->write(I2C_ADDR, &data, 1, true) != 0) {
        return -1;
    }
 
    if (i2c_->read(I2C_ADDR | 0x01, &data, 1) != 0) {
        return -1;
    }
 
    return (0x0 + data);
}

//******************************************************************************
int32_t MAX77756::outEnable(MAX77756::Enable_t enable)
{
    int32_t data; 
    
    data = readReg(REG_CONFIGA);
    if (data < 0) {
        return -1;
    }
    
    data &= (~0x01);
    data |= (enable & 0x01);
    
    data = writeReg(REG_CONFIGA, data & 0xff);
    if (data < 0) {
        return -1;
    }
    
    return 0;
}

//******************************************************************************
int32_t MAX77756::setVout(uint32_t outVoltage)
{
    int32_t data;
    uint32_t bitVolt; 
    
    if (outVoltage < 1500 || outVoltage > 7500) {
        return -1;
    }
    
    bitVolt = (uint32_t)((outVoltage -1500)/50);
    data = writeReg(REG_CONFIGB, bitVolt & 0xff);
    if (data < 0) {
        return -1;
    }
            
    return 0;
}

//******************************************************************************
int32_t MAX77756::config( MAX77756::SpreadSpectrum_t sspectrum, 
                          MAX77756::SoftStart_t sstart,
                          MAX77756::PeakCurrent_t ipeak, 
                          MAX77756::EnableLogic_t enlogic)
{
    int32_t data; 
    int32_t config = 0;
    
    data = readReg(REG_CONFIGA);
    if (data < 0) {
        return -1;
    }
    
    data &= (~0xF2);
    config = (sspectrum << 7) | (sstart << 6) | (ipeak << 4) | (enlogic <<1);
    data |= ( config & 0xF2);
    
    data = writeReg(REG_CONFIGA, data & 0xff);
    if (data < 0) {
        return -1;
    }
    
    return 0;
}
    
    
