/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

#include "max77650.h"

/* LIBRARY FUNCTION SUCCESS*/
#define F_SUCCESS_0  0

/* LIBRARY FUNCTION ERROR CODES */
#define F_ERROR_1 -1    //-1 if read/write errors exist         


MAX77650::MAX77650(I2C &i2c) :
    m_i2cBus(i2c)
{

}

MAX77650::~MAX77650()
{

}


int MAX77650::writeReg(registers_t reg_addr, uint8_t reg_data)
{

    char addr_plus_data[2] = {reg_addr, reg_data};

    if ( m_i2cBus.write(I2C_W_ADRS, addr_plus_data, 2, false) == F_SUCCESS_0)
        return F_SUCCESS_0;
    else
        return F_ERROR_1;

}


int MAX77650::readReg(registers_t reg_addr, uint8_t &value)
{
    int result;
    char local_data[1];
    local_data[0] = reg_addr;
    char read_data[1];

    result = m_i2cBus.write(I2C_W_ADRS, local_data, 1);
    if(result == F_SUCCESS_0) {
        result = m_i2cBus.read(I2C_R_ADRS, read_data , 1, false);
        if (result == F_SUCCESS_0) {
            value =  read_data[0];
            result = F_SUCCESS_0;
        }
    }

    return result;

}


/**
 * @brief      Initialization of Chager for the MAX77650 PMIC
 * @details    Sets the parameters for the charger.
 * @return     status
 */
int MAX77650::initCharger() //Only for Mobility Demo BU
{
// Set the charge current to 52.5mA:
// i2c write -> write 0x19 to register 0x1C
    int status;

    status = writeReg(CNFG_CHG_E, 0X19);

    if (status == F_SUCCESS_0) {
        // Set the charge voltage to 4.2V:
        // i2c write -> write 0x60 to register 0x1E
        status = writeReg(CNFG_CHG_G, 0X60);
        if (status == F_SUCCESS_0) {
            status = writeReg(INT_M_CHG, 0XFB);
            if (status == F_SUCCESS_0) {
                return F_SUCCESS_0;
            }
        }
    } else
        return F_ERROR_1;

    return status;

}


int MAX77650::enCharger() //Only for Mobility Demo BU
{
//You can set the charge current and charge voltage as soon
//as MAX77650 gets up and running.
//Then, you can just disable/enable the charger whenever you like to have it charge the battery.
// Enable or disable the charger:
// i2c write -> write 0x01 to register 0x19 (enables the charger)
    int status;
    //Incorporated some of the LEDS driven by the PMIC to indicate chargering status
    uint8_t reg, temp, mMASK = 3, pmicLED2_ON = 0x44, pmicLED2_OFF = 0x04, p1sDS50 = 0x17;
    
    status = readReg(STAT_CHG_B, reg);
    if (status == F_ERROR_1)
        return F_ERROR_1;
    temp = reg>>2;
    temp = temp & mMASK;

    if (temp == 3) {
        status = writeReg(CNFG_CHG_B, 0X01);
        readReg(CNFG_CHG_B, reg);
        readReg(STAT_CHG_B, reg);
        if (status == F_SUCCESS_0) {
            writeReg(CNFG_LED2_B,p1sDS50);
            writeReg(CNFG_LED2_A,pmicLED2_ON);
            return F_SUCCESS_0;
        }
    } else if (temp == 0) {

        status = writeReg(CNFG_CHG_B, 0X00);
        if (status == F_SUCCESS_0) {
            writeReg(CNFG_LED2_A,pmicLED2_OFF);
            return F_SUCCESS_0;
        }

    }
    return F_ERROR_1;

}

/**
 * @brief       Disable Charger Function
 * @details     Sets the parameters for the charger.
 *
 * @parameters  reg_addr Register to read
 */
int MAX77650::disblCharger() //Only for Mobility Demo BU
{
//You can set the charge current and charge voltage as soon
//as MAX77650 gets up and running.
//Then, you can just disable/enable the charger whenever you like to have it charge the battery.
// Enable or disable the charger:
// i2c write -> write 0x00 to register 0x19 (disables the charger)

    int status;
    uint8_t reg, temp, mMASK = 3;
    status = readReg(STAT_CHG_B, reg);
    if (status == F_ERROR_1)
        return F_ERROR_1;
    temp = reg>>2;
    temp = temp & mMASK;

    if (temp == 0) {

        status = writeReg(CNFG_CHG_B, 0X00);
        if (status == F_ERROR_1) {
            return F_ERROR_1;
        }
        return F_SUCCESS_0;
    }
    return F_ERROR_1;

}


