#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
#include "MAX11311_Electronic_Load.h"
#include "string"
#include <stdlib.h>
#include "math.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

/*
//Defining SPI
SPI spi(P5_1,P5_2,P5_0);  // mosi, miso, sclk
DigitalOut cs(P5_3);
*/

// Hardware serial port over microUSB
Serial daplink(P2_1, P2_0);  //tx,rx

// Virtual serial port over USB
USBSerial microUSB;
DigitalOut redLed(LED_RED, LED_OFF);
DigitalOut grnLed(LED_GREEN, LED_OFF);
DigitalOut bluLed(LED_BLUE, LED_OFF);

Ticker pixi_ticker;


//Variables
PwmOut CNVST(P3_4); //CNVST signal generating 512 HZ
InterruptIn INT(P3_5); //INT pin
uint16_t Device_ID, Receive_Voltageword;
bool SPI_flag, Serial_flag = false, string_complete;
const double LSB_size = 0.01;
float voltage;
string rx_buffer = "";
volatile char c;
const int P3_DAC_address = 0x65;
const int P5_DAC_address = 0x67;
const int P11_DAC_address = 0x70;
const int P9_DAC_address = 0x6E;
const int P10_DAC_address = 0x6F;
const int port_config_p3 = 0x25;    /// 0x25 r/w port_cfg_p3 PIXI port P3 configuration register
const int port_config_p4 = 0x26;    /// 0x26 r/w port_cfg_p4 PIXI port P4 configuration register
const int port_config_p5 = 0x27;    /// 0x27 r/w port_cfg_p5 PIXI port P5 configuration register
uint8_t Address_0x00, P3_DAC_Input_code_MSB_Byte, P3_DAC_Input_code_LSB_Byte;
uint8_t dummy_byte = 0;
uint16_t Receive_LCurrentword, Receive_HCurrentword,Interrupt_reg, P3_DAC_Input_code, P5_DAC_Input_code, P9_DAC_Input_code, P10_DAC_Input_code, P11_DAC_Input_code;
bool TM_LR_Loop, TM_HR_Loop;
bool Update_CC_Flag; //Interrupt flag coming from the PIXI
float CC_Low_range_DAC_input, CC_HIGH_range_DAC_input, Low_range_current, High_range_current, TM_Low_range_DAC_input, TM_HIGH_range_DAC_input, T_ON, T_OFF, Duty_Cycle, Time_Period, Frequency, Ramp_up, Ramp_down;


bool run = false;
bool high_mode = false;





//Interrupt service routines

//SPI ISR

void SPI_ISR()
{
    SPI_flag = true;
}


void Rx_Interrupt()
{
    Serial_flag = true;
    //  SPI_flag = false;
}



void pixi_interrupt()
{
    static int state = 0;
    static int ticks = 0;
    static bool last_mode;
    
    switch (state) 
    {
        case 0:
            if (run) 
            {
                grnLed = LED_ON;
                if (high_mode) 
                {
                    if (last_mode != high_mode) 
                    {
                        last_mode = high_mode;
                        bluLed = LED_OFF;
                    }
                    // send high mode 1st command
                     P11_DAC_Input_code = 2047 - rint((Ramp_up) / 0.025);
                     MAX11300regWrite(P11_DAC_address, P11_DAC_Input_code);
                    redLed = LED_ON;
                    ticks = T_ON;
                } 
                else 
                {
                    if (last_mode != high_mode) 
                    {
                        last_mode = high_mode;
                        redLed = LED_OFF;
                    }
                    // send low mode 1st command
                    P11_DAC_Input_code = 2047 - rint((Ramp_up) / 0.25);
                    MAX11300regWrite(P11_DAC_address, P11_DAC_Input_code);
                    bluLed = LED_ON;
                    ticks = T_ON;
                }
                state = 1;
            } 
            else 
            {
                // set output inactive
                grnLed = LED_OFF;
                state = 0;
            }
            break;
            
        case 1:
            if (--ticks == 0) 
            {
                if (high_mode) 
                {
                    if (last_mode != high_mode) 
                    {
                        last_mode = high_mode;
                        bluLed = LED_OFF;
                    }
                    // send high mode 2nd command
                    P11_DAC_Input_code = 2047 + rint((-Ramp_down) / 0.025);
                    MAX11300regWrite(P11_DAC_address, P11_DAC_Input_code);
                    redLed = LED_OFF;
                    ticks = T_OFF;
                } 
                else 
                {
                    if (last_mode != high_mode) 
                    {
                        last_mode = high_mode;
                        redLed = LED_OFF;
                    }
                    // send low mode 2nd command
                    P11_DAC_Input_code = 2047 + rint((-Ramp_down) / 0.25);
                    MAX11300regWrite(P11_DAC_address, P11_DAC_Input_code);
                    bluLed = LED_OFF;
                    ticks = T_OFF;
                }
                state = 2;
            }
            break;
            
        case 2:
            if (--ticks == 0) 
            {
                state = 0;
            }        
            break;
    }
}




// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{

    MAX11311init();
   // microUSB.baud(9600);
    Device_ID = MAX11300regRead(0X00);  //(Fisrst 7 bits from MSB are address and LSB is read bit which 1)
   // CNVST.period(0.0019531f);      // 512HZ signal
    CNVST.period(0.0078125); //128HZ signal
    CNVST.write(0.50f);      // 50% duty cycle, relative to period
    INT.fall(&SPI_ISR);  // attach the address of the flip function to the rising edge
    microUSB.attach(&Rx_Interrupt);
    rx_buffer.reserve(2000);
    pixi_ticker.attach(pixi_interrupt, 0.001);


// Setup a serial interrupt function to receive data
//   microUSB.attach(&Rx_interrupt);

    while(1) {

        //SPI ISR routine linking with main
        if(SPI_flag) {
            //Reading the 0x01 and 0x02 and 0x03 clears the interrupt on the PIXI ADC port
            MAX11300regRead(0x01);                            // read interrupt register
            MAX11300regRead(0x02);                            // read ADC status register 1
            MAX11300regRead(0x03);                            // read ADC status register 2  only for MAX11300 (20 port chip)


            //Sending voltage values
            Receive_Voltageword =  MAX11300regRead(0x42);
            Receive_LCurrentword =  MAX11300regRead(0x44);
            Receive_HCurrentword =  MAX11300regRead(0x4B);
            voltage = (float) Receive_Voltageword * LSB_size;
            Low_range_current = (float) Receive_LCurrentword * 0.025e-3;
            High_range_current = (float) Receive_HCurrentword * 2.5e-3;
__disable_irq();    // Disable Interrupts
            microUSB.printf("VR");
            microUSB.printf("Version 1.0 \r\n");
             microUSB.printf("VL");
             microUSB.printf("%0.3f\r\n", voltage);
__enable_irq();     // Enable Interrupts           
             


            if (Update_CC_Flag && SPI_flag) {
__disable_irq();    // Disable Interrupts

               
                microUSB.printf("LC");
                microUSB.printf("%f\r\n",Low_range_current);
                microUSB.printf("HC");
                microUSB.printf("%f\r\n",High_range_current);
              //  SPI_flag = false;
              
__enable_irq();     // Enable Interrupts   
            }

            SPI_flag = false;    //Deasserting the interrupt
        }


        if(Serial_flag) {
            
     //       __disable_irq();    // Disable Interrupts
            Serial_flag = false;
  

          
            while (microUSB.readable()) 
            {
                //     SPI_flag = false;
                c = microUSB.getc();
                rx_buffer += c;
// Uncomment to Echo to USB serial to watch data flow
//        monitor_device.putc(rx_buffer[rx_in]);
                if(c == '\n')

                {
                    string_complete = true;

                }
            }
          
    //        __enable_irq();     // Enable Interrupts
        }

        if(string_complete) 
        {
           string_complete = false;
            if (rx_buffer.substr(0, 2) == "CM") // Checking for constant current constant mode

            {
                run = false;
                if (rx_buffer.substr(2, 2) == "LR") 
                {





                    MAX11300regWrite(port_config_p3, 0x5100); //Making sure in constant current mode, the port P3 and P5 are configured as 0-10V DACs
                    MAX11300initDelayus(100);
                    MAX11300regWrite(port_config_p5, 0x5100);
                    MAX11300initDelayus(100);
                    MAX11300regWrite(P3_DAC_address, 0);
                    MAX11300regWrite(P5_DAC_address, 0);
                    CC_Low_range_DAC_input = atof(rx_buffer.substr(4).c_str());
                    P3_DAC_Input_code = rint((CC_Low_range_DAC_input) / 25e-3);
                    MAX11300regWrite(P5_DAC_address, 0);
                    MAX11300regWrite(P3_DAC_address, P3_DAC_Input_code);

                    //        microUSB.printf("Clearing string \r\n");
                    // clear the string:
                    rx_buffer = "";
                //    string_complete = false;

                }



                //Writing the high current range DAC
                //P5: DAC to set the current on the low-range---0x67
                //This is a 12 bit DAC, the Low current range is 0 to 10A
                //The low value of DAC is 0 (corresponds to 0mA) and the highest input is [(2^12)-1] which is 4095 (corresponds to 100mA)

                //The transfer function for converting the analog current value coming from the GUI to digital 12 bit input code for the DAC is
                // Digital_current_input = rint(Analog_current_IN/(FSR/2^n))
                //n = 12
                //DAC_FSR = 102.4mA
                //LSB_DAC  = 0.0025


                // print the string when a newline arrives:

                else if (rx_buffer.substr(2, 2) == "HR" ) 
                {

                    MAX11300regWrite(port_config_p3, 0x5100); //Making sure in constant current mode, the port P3 and P5 are configured as 0-10V DACs
                    MAX11300initDelayus(100);
                    MAX11300regWrite(port_config_p5, 0x5100);
                    MAX11300initDelayus(100);
                    MAX11300regWrite(P3_DAC_address, 0);
                    MAX11300regWrite(P5_DAC_address, 0);

                    string a = rx_buffer.substr(4);
                    CC_HIGH_range_DAC_input = atof(a.c_str());
                    P5_DAC_Input_code = rint((CC_HIGH_range_DAC_input) / 0.0025);
                    //  MAX11300regWrite(P3_DAC_address, 0);
                    MAX11300regWrite(P5_DAC_address, P5_DAC_Input_code);
                    // clear the string:
                    rx_buffer = "";
               //     string_complete = false;

                }

                else if (rx_buffer.substr(2, 2) == "GV") 
                {
                    Update_CC_Flag = true;
                    // clear the string:
                    rx_buffer = "";
                //    string_complete = false;
                }


                else if (rx_buffer.substr(2, 2) == "SV") 
                {

                    // Update_CC_Flag = false;
                    MAX11300regWrite(port_config_p3, 0x5100); //Making sure in constant current mode, the port P3 and P5 are configured as 0-10V DACs
                    MAX11300initDelayus(100);
                    MAX11300regWrite(port_config_p5, 0x5100);
                    MAX11300initDelayus(100);
                    MAX11300regWrite(P3_DAC_address, 0);
                    MAX11300regWrite(P5_DAC_address, 0);
                    // clear the string:
                    rx_buffer = "";
                 //   string_complete = false;
                }
            } 
            else if (rx_buffer.substr(0, 2) == "TM") 
            {
                //Checking for Transient  mode


                MAX11300regWrite(P3_DAC_address, 0);
                MAX11300regWrite(P5_DAC_address, 0);
                MAX11300initDelayus(100);
                MAX11300regWrite(port_config_p3, 0x0000);  //Making both P3 and P5 high impedance
                MAX11300regWrite(port_config_p5, 0x0000);
                if (rx_buffer.substr(2, 2) == "LR") 
                {

                    MAX11300regWrite(port_config_p3, 0xC000);  //select low range, the external signal must be routed from P4 to P3. This is accomplished by writing 0xC000 to the configuration register of P3, and 0x0000 to the configuration register of P4:
                    MAX11300initDelayus(100);
                    MAX11300regWrite(port_config_p4, 0x0000);
                    MAX11300initDelayus(100);

                    //P11:  DAC to generate the ramp-up and ramp-down of the dynamic signal---0X6F -- Minimum value startting with 0, Maximum ramp-- 500A/ms-- This is a Bipolar DAC switches between +5 and -5
                    //P9: DAC to set the valley current in dynamic mode----0X6E
                    //P10:DAC to set the peak current in dynamic mode----0X70 --- Maximum value: 10A or 100 mA even this has two ranges
                    float Size_vc = atof(rx_buffer.substr(4, 1).c_str());

                  //  microUSB.printf("Valley current size");
                 //   microUSB.printf("%0.1f\r\n",Size_vc);

                    TM_Low_range_DAC_input = atof(rx_buffer.substr(5,Size_vc).c_str());
                 //   microUSB.printf("Valley current value");
                 //   microUSB.printf("%0.3f\r\n",TM_Low_range_DAC_input);

                   // P9_DAC_Input_code = rint((TM_Low_range_DAC_input + 6.5) / 25e-3);
                   P9_DAC_Input_code = rint(((TM_Low_range_DAC_input )*45.5)+200);
                    
                    if(P9_DAC_Input_code > 4095)
                    {
                        P9_DAC_Input_code = 4095;
                    }
                    
                    MAX11300regWrite(P9_DAC_address, P9_DAC_Input_code);
                    float Start_bound_pc = (5 + Size_vc); // Starting character for peak current
                  //  microUSB.printf("Peak current starting point");
                  //  microUSB.printf("%0.1f\r\n",Start_bound_pc);
                    float Size_pc = atof(rx_buffer.substr(Start_bound_pc, 1).c_str());
                 //   microUSB.printf("Peak current size");
                 //   microUSB.printf("%0.1f\r\n",Size_pc);

                    TM_HIGH_range_DAC_input = atof(rx_buffer.substr((1 + Start_bound_pc), (Size_pc)).c_str());
                //    microUSB.printf("Peak current value");
                //    microUSB.printf("%0.3f\r\n",TM_HIGH_range_DAC_input);

                 //   P10_DAC_Input_code = rint((TM_HIGH_range_DAC_input - 6.5) / 25e-3);
                 P10_DAC_Input_code = rint(((TM_HIGH_range_DAC_input)*45.5)-250);
                    
                    if(P10_DAC_Input_code < 0)
                    {
                        P10_DAC_Input_code = 0;
                    }
                    else if(P10_DAC_Input_code > 4095)
                    {
                        P10_DAC_Input_code = 4095;
                    }

                    
                    
                    MAX11300regWrite(P10_DAC_address, P10_DAC_Input_code);


                    float Start_bound_ON_time = (1 + Start_bound_pc + Size_pc);; // Starting character for duty cycle
                  //  microUSB.printf("ON time starting point");
                  //  microUSB.printf("%0.1f\r\n",Start_bound_ON_time);

                    float Size_ON_time = atof(rx_buffer.substr(Start_bound_ON_time, 1).c_str());
                 //   microUSB.printf("Size of ON time");
                 //   microUSB.printf("%0.1f\r\n",Size_ON_time);


                    T_ON = atof(rx_buffer.substr((Start_bound_ON_time + 1), (Size_ON_time)).c_str());
                //    microUSB.printf("ON time");
                //    microUSB.printf("%0.3f\r\n",T_ON);


                    float Start_bound_OFF_time = Start_bound_ON_time + 1 + Size_ON_time;
                    float Size_OFF_time = atof(rx_buffer.substr(Start_bound_OFF_time, (1)).c_str());
                //    microUSB.printf("Size_OFF time");

                //    microUSB.printf("%0.1f\r\n",Size_OFF_time);

                    T_OFF = atof(rx_buffer.substr(1 + Start_bound_OFF_time, Size_OFF_time).c_str());
                 //   microUSB.printf("OFF time");
                 //   microUSB.printf("%0.3f\r\n",T_OFF);

                    float Start_bound_rampup = 1 + Start_bound_OFF_time + Size_OFF_time;
                    float size_rampup = atof(rx_buffer.substr(Start_bound_rampup, (1)).c_str());
                 //   microUSB.printf("Ramp up size");
                 //   microUSB.printf("%0.1f\r\n",size_rampup);

                    Ramp_up = atof(rx_buffer.substr((1 + Start_bound_rampup), (size_rampup)).c_str());
                 //   microUSB.printf("Ramp up value");
                //    microUSB.printf("%0.3f\r\n",Ramp_up);

                    float Start_bound_rampdown = (1 + Start_bound_rampup + size_rampup);

                    float size_rampdown = atof(rx_buffer.substr(Start_bound_rampdown, (1)).c_str());
                //    microUSB.printf("Ramp down size");
                //    microUSB.printf("%0.1f\r\n",size_rampdown);

                    Ramp_down = atof(rx_buffer.substr((1 + Start_bound_rampdown), (size_rampdown)).c_str());
               //     microUSB.printf("Ramp down value");
               //     microUSB.printf("%0.3f\r\n",Ramp_down);


                    float Size_loop = (1 + Start_bound_rampdown + size_rampdown);
               //     microUSB.printf("Loop size");
               //     microUSB.printf("%0.1f\r\n",Size_loop);

                    //    microUSB.printf("In loop");
                    TM_LR_Loop = true;
                    TM_HR_Loop = false;
                    run = true;
                    high_mode = false;
                    

                    rx_buffer = "";
               //     string_complete = false;

                }


                else  if (rx_buffer.substr(2, 2) == "HR") 
                {

                    MAX11300regWrite(port_cfg_p4, 0xC000);  //select high range, the external signal must be routed from P4 to P5. This is accomplished by writing 0xC000 to the configuration register of P4:
                    MAX11300regWrite(port_cfg_p3, 0x0000);



                    //P11:  DAC to generate the ramp-up and ramp-down of the dynamic signal---0X6F -- Minimum value startting with 0, Maximum ramp-- 500A/ms-- This is a Bipolar DAC switches between +5 and -5
                    //P9: DAC to set the valley current in dynamic mode----0X6E
                    //P10:DAC to set the peak current in dynamic mode----0X70 --- Maximum value: 10A or 100 mA even this has two ranges
                     float Size_vc = atof(rx_buffer.substr(4, 1).c_str());

                  //  microUSB.printf("Valley current size");
                  //  microUSB.printf("%0.1f\r\n",Size_vc);

                    TM_Low_range_DAC_input = atof(rx_buffer.substr(5,Size_vc).c_str());
                 //   microUSB.printf("Valley current value");
                 //   microUSB.printf("%0.3f\r\n",TM_Low_range_DAC_input);

                //    P9_DAC_Input_code = rint((TM_Low_range_DAC_input + 0.65) / 25e-4);
                P9_DAC_Input_code = rint(((TM_Low_range_DAC_input)*455)+200);
                    
                    if(P9_DAC_Input_code > 4095)
                    {
                        P9_DAC_Input_code = 4095;
                    }
                    
                    
                    MAX11300regWrite(P9_DAC_address, P9_DAC_Input_code);
                    float Start_bound_pc = (5 + Size_vc); // Starting character for peak current
               //     microUSB.printf("Peak current starting point");
               //     microUSB.printf("%0.1f\r\n",Start_bound_pc);
                    float Size_pc = atof(rx_buffer.substr(Start_bound_pc, 1).c_str());
              //      microUSB.printf("Peak current size");
              //      microUSB.printf("%0.1f\r\n",Size_pc);

                    TM_HIGH_range_DAC_input = atof(rx_buffer.substr((1 + Start_bound_pc), (Size_pc)).c_str());
             //       microUSB.printf("Peak current value");
             //       microUSB.printf("%0.3f\r\n",TM_HIGH_range_DAC_input);

                  //  P10_DAC_Input_code = rint((TM_HIGH_range_DAC_input - 0.65) / 25e-4);
                  
            P10_DAC_Input_code = rint(((TM_HIGH_range_DAC_input)*455)-250);
                    
                    if(P10_DAC_Input_code < 0)
                    {
                        P10_DAC_Input_code = 0;
                    }
                    else if(P10_DAC_Input_code > 4095)
                    {
                        P10_DAC_Input_code = 4095;
                    }


                    
                    MAX11300regWrite(P10_DAC_address, P10_DAC_Input_code);


                    float Start_bound_ON_time = (1 + Start_bound_pc + Size_pc);; // Starting character for duty cycle
           //         microUSB.printf("ON time starting point");
          //          microUSB.printf("%0.1f\r\n",Start_bound_ON_time);

                    float Size_ON_time = atof(rx_buffer.substr(Start_bound_ON_time, 1).c_str());
          //          microUSB.printf("Size of ON time");
          //          microUSB.printf("%0.1f\r\n",Size_ON_time);


                    T_ON = atof(rx_buffer.substr((Start_bound_ON_time + 1), (Size_ON_time)).c_str());
         //           microUSB.printf("ON time");
         //           microUSB.printf("%0.3f\r\n",T_ON);


                    float Start_bound_OFF_time = Start_bound_ON_time + 1 + Size_ON_time;
                    float Size_OFF_time = atof(rx_buffer.substr(Start_bound_OFF_time, (1)).c_str());
        //            microUSB.printf("Size_OFF time");

       //             microUSB.printf("%0.1f\r\n",Size_OFF_time);

                    T_OFF = atof(rx_buffer.substr(1 + Start_bound_OFF_time, Size_OFF_time).c_str());
       //             microUSB.printf("OFF time");
       //             microUSB.printf("%0.3f\r\n",T_OFF);

                    float Start_bound_rampup = 1 + Start_bound_OFF_time + Size_OFF_time;
                    float size_rampup = atof(rx_buffer.substr(Start_bound_rampup, (1)).c_str());
      //              microUSB.printf("Ramp up size");
      //              microUSB.printf("%0.1f\r\n",size_rampup);

                    Ramp_up = atof(rx_buffer.substr((1 + Start_bound_rampup), (size_rampup)).c_str());
      //              microUSB.printf("Ramp up value");
      //              microUSB.printf("%0.3f\r\n",Ramp_up);

                    float Start_bound_rampdown = (1 + Start_bound_rampup + size_rampup);

                    float size_rampdown = atof(rx_buffer.substr(Start_bound_rampdown, (1)).c_str());
      //              microUSB.printf("Ramp down size");
      //              microUSB.printf("%0.1f\r\n",size_rampdown);

                    Ramp_down = atof(rx_buffer.substr((1 + Start_bound_rampdown), (size_rampdown)).c_str());
     //               microUSB.printf("Ramp down value");
      //              microUSB.printf("%0.3f\r\n",Ramp_down);


                    float Size_loop = (1 + Start_bound_rampdown + size_rampdown);
     //               microUSB.printf("Loop size");
     //               microUSB.printf("%0.1f\r\n",Size_loop);

                    //    microUSB.printf("In loop");
                    TM_LR_Loop = false;
                    TM_HR_Loop = true;
                    run = true;
                    high_mode = true;
                    

                    rx_buffer = "";
                   // string_complete = false;
                }
                
            

            }
            else
            {
                run = false;
                
            }
        }


//wait(1);
//microUSB.printf("Back to main");

    }






}




