/*******************************************************************************
* Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.      
*                                                                               
* Permission is hereby granted, free of charge, to any person obtaining a       
* copy of this software and associated documentation files (the "Software"),    
* to deal in the Software without restriction, including without limitation     
* the rights to use, copy, modify, merge, publish, distribute, sublicense,      
* and/or sell copies of the Software, and to permit persons to whom the         
* Software is furnished to do so, subject to the following conditions:          
*                                                                               
* The above copyright notice and this permission notice shall be included       
* in all copies or substantial portions of the Software.                        
*                                                                               
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS       
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF                    
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.        
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES           
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,      
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR         
* OTHER DEALINGS IN THE SOFTWARE.                                               
*                                                                               
* Except as contained in this notice, the name of Maxim Integrated              
* Products, Inc. shall not be used except as stated in the Maxim Integrated     
* Products, Inc. Branding Policy.                                               
*                                                                               
* The mere transfer of this software does not imply any licenses                
* of trade secrets, proprietary technology, copyrights, patents,                
* trademarks, maskwork rights, or any other form of intellectual                
* property whatsoever. Maxim Integrated Products, Inc. retains all              
* ownership rights.                                                             
******************************************************************************* 
*/
/// Generated by: MAX11300/01/11/12 Configuration Software (Ver. 1.1.0.5) 13/03/2019 12:16
/// Description: Electronic load
/// Port P0: Differential in+ for measuring the source voltage
/// Port P1: Differential in- for measuring the source voltage
/// Port P2: ADC for measuring the low current
/// Port P3: DAC for setting the low current
/// Port P4: Input for dynamic current control
/// Port P5: DAC for setting the high current
/// Port P6: ADC for measuring the low current
/// Port P7: Not used
/// Port P8: Not used
/// Port P9: Clamp for lower limit curve
/// Port P10: Clamp for higher limit curve
/// Port P11: DAC for driving ramp generator
/// Notes: Optional: Enter design notes here
           
#ifndef _MAX11311_DESIGNVALUE_H_
#define _MAX11311_DESIGNVALUE_H_

/// Supply voltage on AVSSIO
#define MAX11300_AVSSIO_VOLTAGE -7

/// Supply voltage on AVDDIO
#define MAX11300_AVDDIO_VOLTAGE 12

/// Supply voltage on DVDD
#define MAX11300_DVDD_VOLTAGE 1.8

/// Supply voltage on AVDD
#define MAX11300_AVDD_VOLTAGE 5

/// Supply voltage on DAC_REF
#define MAX11300_DAC_REF_VOLTAGE 2.5

/// Supply voltage on ADC_EXT_REF
#define MAX11300_ADC_EXT_REF_VOLTAGE 2.5

/// SPI first byte when writing MAX11300 (7-bit address in bits 0x7E; LSB=0 for write)
#define MAX11311Addr_SPI_Write(RegAddr) ( (RegAddr << 1)     )

/// SPI first byte when reading MAX11300 (7-bit address in bits 0x7E; LSB=1 for read)
#define MAX11311Addr_SPI_Read(RegAddr)  ( (RegAddr << 1) | 1 )

/// MAX11300EVKIT Register Addresses
typedef enum MAX11311RegAddressEnum {

/// 0x00 r/o dev_id Device Identification
dev_id = 0x00,

/// 0x01 r/o interrupt_flag Interrupt flags
interrupt_flag = 0x01,

/// 0x02 r/o adc_status_P10P6_P5P0 new ADC data available
adc_status_P10P6_P5P0 = 0x02,

/// 0x03 r/o adc_status_P11 new ADC data available
adc_status_P11 = 0x03,

/// 0x04 r/o dac_oi_status_P10P6_P5P0 DAC Overcurrent Interrupt
dac_oi_status_P10P6_P5P0 = 0x04,

/// 0x05 r/o dac_oi_status_P11 DAC Overcurrent Interrupt
dac_oi_status_P11 = 0x05,

/// 0x06 r/o gpi_status_P10P6_P5P0 GPI event ready
 gpi_status_P10P6_P5P0 = 0x06,

/// 0x07 r/o gpi_status_P11 GPI event ready
gpi_status_P11 = 0x07,

/// 0x08 r/o tmp_int_data Internal Temeprature
tmp_int_data = 0x08,

/// 0x09 r/o tmp_ext1_data External Temperature D0P/D0N
tmp_ext1_data = 0x09,

/// 0x0a r/o tmp_ext2_data External Temperature D1P/D1N
tmp_ext2_data = 0x0a,

/// 0x0b r/o gpi_data_P10P6_P5P0 GPI input ports data
gpi_data_P10P6_P5P0 = 0x0b,

/// 0x0c r/o gpi_data_P11 GPI input ports data
gpi_data_P11 = 0x0c,

/// 0x0d r/w gpo_data_P10P6_P5P0 GPO output ports data
gpo_data_P10P6_P5P0 = 0x0d,

/// 0x0e r/w gpo_data_P11 GPO output ports data
gpo_data_P11 = 0x0e,

/// 0x0f r/o reserved_0F reserved
reserved_0F = 0x0f,

/// 0x10 r/w device_control Global device control register
device_control = 0x10,

/// 0x11 r/w interrupt_mask interrupt mask (1 = disable interrupt source)
interrupt_mask = 0x11,

/// 0x12 r/w gpi_irqmode_P5_P0 GPI ports P5 to P0 mode register
gpi_irqmode_P5_P0 = 0x12,

/// 0x13 r/w gpi_irqmode_P10_P6 GPI ports P10 to P6 mode register
gpi_irqmode_P10_P6 = 0x13,

/// 0x14 r/w gpi_irqmode_P11 GPI port P11 mode register
gpi_irqmode_P11 = 0x14,

/// 0x15 r/w reserved_15 (reserved)
reserved_15 = 0x15,

/// 0x16 r/w dac_preset_data_1 DAC preset activated by <see cref="device_control"/>
dac_preset_data_1 = 0x16,

/// 0x17 r/w dac_preset_data_2 DAC preset activated by <see cref="device_control"/>
dac_preset_data_2 = 0x17,

/// 0x18 r/w tmp_mon_cfg Temperautre Monitor Configuration
tmp_mon_cfg = 0x18,

/// 0x19 r/w tmp_mon_int_hi_thresh Internal Temeprature Hot Threshold
tmp_mon_int_hi_thresh = 0x19,

/// 0x1a r/w tmp_mon_int_lo_thresh Internal Temeprature Cold Threshold
tmp_mon_int_lo_thresh = 0x1a,

/// 0x1b r/w tmp_mon_ext1_hi_thresh External Temperature D0P/D0N Hot Threshold
tmp_mon_ext1_hi_thresh = 0x1b,

/// 0x1c r/w tmp_mon_ext1_lo_thresh External Temperature D0P/D0N Cold Threshold
tmp_mon_ext1_lo_thresh = 0x1c,

/// 0x1d r/w tmp_mon_ext2_hi_thresh External Temperature D1P/D1N Hot Threshold
tmp_mon_ext2_hi_thresh = 0x1d,

/// 0x1e r/w tmp_mon_ext2_lo_thresh External Temperature D1P/D1N Cold Threshold
tmp_mon_ext2_lo_thresh = 0x1e,

/// 0x1f r/w reserved_1F reserved
reserved_1F = 0x1f,

/// 0x20 r/w reserved_20 (reserved) configuration register
reserved_20 = 0x20,

/// 0x21 r/w reserved_21 (reserved) configuration register
reserved_21 = 0x21,

/// 0x22 r/w port_cfg_p0 PIXI port P0 configuration register
port_cfg_p0 = 0x22,

/// 0x23 r/w port_cfg_p1 PIXI port P1 configuration register
port_cfg_p1 = 0x23,

/// 0x24 r/w port_cfg_p2 PIXI port P2 configuration register
port_cfg_p2 = 0x24,

/// 0x25 r/w port_cfg_p3 PIXI port P3 configuration register
port_cfg_p3 = 0x25,

/// 0x26 r/w port_cfg_p4 PIXI port P4 configuration register
port_cfg_p4 = 0x26,

/// 0x27 r/w port_cfg_p5 PIXI port P5 configuration register
port_cfg_p5 = 0x27,

/// 0x28 r/w reserved_28 (reserved) configuration register
reserved_28 = 0x28,

/// 0x29 r/w reserved_29 (reserved) configuration register
reserved_29 = 0x29,

/// 0x2a r/w reserved_2A (reserved) configuration register
reserved_2A = 0x2a,

/// 0x2b r/w port_cfg_p6 PIXI port P6 configuration register
port_cfg_p6 = 0x2b,

/// 0x2c r/w port_cfg_p7 PIXI port P7 configuration register
port_cfg_p7 = 0x2c,

/// 0x2d r/w port_cfg_p8 PIXI port P8 configuration register
port_cfg_p8 = 0x2d,

/// 0x2e r/w port_cfg_p9 PIXI port P9 configuration register
port_cfg_p9 = 0x2e,

/// 0x2f r/w port_cfg_p10 PIXI port P10 configuration register
port_cfg_p10 = 0x2f,

/// 0x30 r/w port_cfg_p11 PIXI port P11 configuration register
port_cfg_p11 = 0x30,

/// 0x31 r/w reserved_31 (reserved) configuration register
reserved_31 = 0x31,

/// 0x32 r/w reserved_32 (reserved) configuration register
reserved_32 = 0x32,

/// 0x33 r/w reserved_33 (reserved) configuration register
reserved_33 = 0x33,

/// 0x40 r/o reserved_40 (reserved) Analog to Digital Converter register
reserved_40 = 0x40,

/// 0x41 r/o reserved_41 (reserved) Analog to Digital Converter register
reserved_41 = 0x41,

/// 0x42 r/o adc_data_port_p0 PIXI port P0 Analog to Digital Converter register
adc_data_port_p0 = 0x42,

/// 0x43 r/o adc_data_port_p1 PIXI port P1 Analog to Digital Converter register
adc_data_port_p1 = 0x43,

/// 0x44 r/o adc_data_port_p2 PIXI port P2 Analog to Digital Converter register
adc_data_port_p2 = 0x44,

/// 0x45 r/o adc_data_port_p3 PIXI port P3 Analog to Digital Converter register
adc_data_port_p3 = 0x45,

/// 0x46 r/o adc_data_port_p4 PIXI port P4 Analog to Digital Converter register
adc_data_port_p4 = 0x46,

/// 0x47 r/o adc_data_port_p5 PIXI port P5 Analog to Digital Converter register
adc_data_port_p5 = 0x47,

/// 0x48 r/o reserved_48 (reserved) Analog to Digital Converter register
reserved_48 = 0x48,

/// 0x49 r/o reserved_49 (reserved) Analog to Digital Converter register
reserved_49 = 0x49,

/// 0x4a r/o reserved_4A (reserved) Analog to Digital Converter register
reserved_4A = 0x4a,

/// 0x4b r/o adc_data_port_p6 PIXI port P6 Analog to Digital Converter register
adc_data_port_p6 = 0x4b,

/// 0x4c r/o adc_data_port_p7 PIXI port P7 Analog to Digital Converter register
adc_data_port_p7 = 0x4c,

/// 0x4d r/o adc_data_port_p8 PIXI port P8 Analog to Digital Converter register
adc_data_port_p8 = 0x4d,

/// 0x4e r/o adc_data_port_p9 PIXI port P9 Analog to Digital Converter register
adc_data_port_p9 = 0x4e,

/// 0x4f r/o adc_data_port_p10 PIXI port P10 Analog to Digital Converter register
adc_data_port_p10 = 0x4f,

/// 0x50 r/o adc_data_port_p11 PIXI port P11 Analog to Digital Converter register
adc_data_port_p11 = 0x50,

/// 0x51 r/o reserved_51 (reserved) Analog to Digital Converter register
reserved_51 = 0x51,

/// 0x52 r/o reserved_52 (reserved) Analog to Digital Converter register
reserved_52 = 0x52,

/// 0x53 r/o reserved_53 (reserved) Analog to Digital Converter register
reserved_53 = 0x53,

/// 0x60 r/w reserved_60 (reserved) Digital to Analog Converter register
reserved_60 = 0x60,

/// 0x61 r/w reserved_61 (reserved) Digital to Analog Converter register
reserved_61 = 0x61,

/// 0x62 r/w dac_data_port_p0 PIXI port P0 Digital to Analog Converter register
dac_data_port_p0 = 0x62,

/// 0x63 r/w dac_data_port_p1 PIXI port P1 Digital to Analog Converter register
dac_data_port_p1 = 0x63,

/// 0x64 r/w dac_data_port_p2 PIXI port P2 Digital to Analog Converter register
dac_data_port_p2 = 0x64,

/// 0x65 r/w dac_data_port_p3 PIXI port P3 Digital to Analog Converter register
dac_data_port_p3 = 0x65,

/// 0x66 r/w dac_data_port_p4 PIXI port P4 Digital to Analog Converter register
dac_data_port_p4 = 0x66,

/// 0x67 r/w dac_data_port_p5 PIXI port P5 Digital to Analog Converter register
dac_data_port_p5 = 0x67,

/// 0x68 r/w reserved_68 (reserved) Digital to Analog Converter register
reserved_68 = 0x68,

/// 0x69 r/w reserved_69 (reserved) Digital to Analog Converter register
reserved_69 = 0x69,

/// 0x6a r/w reserved_6A (reserved) Digital to Analog Converter register
reserved_6A = 0x6a,

/// 0x6b r/w dac_data_port_p6 PIXI port P6 Digital to Analog Converter register
dac_data_port_p6 = 0x6b,

/// 0x6c r/w dac_data_port_p7 PIXI port P7 Digital to Analog Converter register
dac_data_port_p7 = 0x6c,

/// 0x6d r/w dac_data_port_p8 PIXI port P8 Digital to Analog Converter register
dac_data_port_p8 = 0x6d,

/// 0x6e r/w dac_data_port_p9 PIXI port P9 Digital to Analog Converter register
dac_data_port_p9 = 0x6e,

/// 0x6f r/w dac_data_port_p10 PIXI port P10 Digital to Analog Converter register
dac_data_port_p10 = 0x6f,

/// 0x70 r/w dac_data_port_p11 PIXI port P11 Digital to Analog Converter register
dac_data_port_p11 = 0x70,

/// 0x71 r/w reserved_71 (reserved) Digital to Analog Converter register
reserved_71 = 0x71,

/// 0x72 r/w reserved_72 (reserved) Digital to Analog Converter register
reserved_72 = 0x72,

/// 0x73 r/w reserved_73 (reserved) Digital to Analog Converter register
reserved_73 = 0x73,

} MAX11311RegAddress_t;

/// 0x00 r/o dev_id Device Identification
/// <code>1111xxxxxxxxxxxx</code> PART Part field
/// <code>xxxx11xxxxxxxxxx</code> REV Revision
/// <code>xxxxxx11xxxxxxxx</code> IFMODE Inteface Mode
/// <code>xxxxxxxx11xxxxxx</code> IFSP Inteface Speed
/// <code>xxxxxxxxxx11xxxx</code> NBRPRTS Number of ports
/// <code>xxxxxxxxxxxx11xx</code> RES Resolution
/// <code>xxxxxxxxxxxxxx11</code> VRNG Voltage Range
#define dev_id_PART     0xf000
#define dev_id_REV  0x0c00
#define dev_id_IFMODE   0x0300
#define dev_id_IFSP     0x00c0
#define dev_id_NBRPRTS  0x0030
#define dev_id_RES  0x000c
#define dev_id_VRNG     0x0003

/// 0x01 r/o interrupt_flag Interrupt flags
/// <code>1xxxxxxxxxxxxxxx</code> VMON High Voltage Supply Monitor
/// <code>x1xxxxxxxxxxxxxx</code> TMPEXT2HOT External Temperature D1P/D1N Hot
/// <code>xx1xxxxxxxxxxxxx</code> TMPEXT2COLD External Temperature D1P/D1N Cold
/// <code>xxx1xxxxxxxxxxxx</code> TMPEXT2NEW External Temperature D1P/D1N New
/// <code>xxxx1xxxxxxxxxxx</code> TMPEXT1HOT External Temperature D0P/D0N Hot
/// <code>xxxxx1xxxxxxxxxx</code> TMPEXT1COLD External Temperature D0P/D0N Cold
/// <code>xxxxxx1xxxxxxxxx</code> TMPEXT1NEW External Temperature D0P/D0N New
/// <code>xxxxxxx1xxxxxxxx</code> TMPINTHOT Internal Temeprature Hot
/// <code>xxxxxxxx1xxxxxxx</code> TMPINTCOLD Internal Temeprature Cold
/// <code>xxxxxxxxx1xxxxxx</code> TMPINTNEW Internal Temeprature New
/// <code>xxxxxxxxxx1xxxxx</code> DACOI DAC over-current
/// <code>xxxxxxxxxxx1xxxx</code> GPIDM GPI event missed
/// <code>xxxxxxxxxxxx1xxx</code> GPIDR GPI event ready
/// <code>xxxxxxxxxxxxx1xx</code> ADCDM ADC data missed
/// <code>xxxxxxxxxxxxxx1x</code> ADCDR ADC data ready
/// <code>xxxxxxxxxxxxxxx1</code> ADCFLAG ADC conversion/sweep complete
#define interrupt_flag_VMON     0x8000
#define interrupt_flag_TMPEXT2HOT   0x4000
#define interrupt_flag_TMPEXT2COLD  0x2000
#define interrupt_flag_TMPEXT2NEW   0x1000
#define interrupt_flag_TMPEXT1HOT   0x0800
#define interrupt_flag_TMPEXT1COLD  0x0400
#define interrupt_flag_TMPEXT1NEW   0x0200
#define interrupt_flag_TMPINTHOT    0x0100
#define interrupt_flag_TMPINTCOLD   0x0080
#define interrupt_flag_TMPINTNEW    0x0040
#define interrupt_flag_DACOI    0x0020
#define interrupt_flag_GPIDM    0x0010
#define interrupt_flag_GPIDR    0x0008
#define interrupt_flag_ADCDM    0x0004
#define interrupt_flag_ADCDR    0x0002
#define interrupt_flag_ADCFLAG  0x0001

/// 0x02 r/o adc_status_P10P6_P5P0 new ADC data available
/// <code>1xxxxxxxxxxxxxxx</code> ADCSTp10 ADCST[P10] new <see cref="adc_data_port_p10"/>
/// <code>x1xxxxxxxxxxxxxx</code> ADCSTp09 ADCST[P9] new <see cref="adc_data_port_p9"/>
/// <code>xx1xxxxxxxxxxxxx</code> ADCSTp08 ADCST[P8] new <see cref="adc_data_port_p8"/>
/// <code>xxx1xxxxxxxxxxxx</code> ADCSTp07 ADCST[P7] new <see cref="adc_data_port_p7"/>
/// <code>xxxx1xxxxxxxxxxx</code> ADCSTp06 ADCST[P6] new <see cref="adc_data_port_p6"/>
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_10  new <see cref="reserved_4A"/>
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_09   new <see cref="reserved_49"/>
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_08   new <see cref="reserved_48"/>
/// <code>xxxxxxxx1xxxxxxx</code> ADCSTp05 ADCST[P5]  new <see cref="adc_data_port_p5"/>
/// <code>xxxxxxxxx1xxxxxx</code> ADCSTp04 ADCST[P4]  new <see cref="adc_data_port_p4"/>
/// <code>xxxxxxxxxx1xxxxx</code> ADCSTp03 ADCST[P3]  new <see cref="adc_data_port_p3"/>
/// <code>xxxxxxxxxxx1xxxx</code> ADCSTp02 ADCST[P2]  new <see cref="adc_data_port_p2"/>
/// <code>xxxxxxxxxxxx1xxx</code> ADCSTp01 ADCST[P1]  new <see cref="adc_data_port_p1"/>
/// <code>xxxxxxxxxxxxx1xx</code> ADCSTp00 ADCST[P0]  new <see cref="adc_data_port_p0"/>
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_01   new <see cref="reserved_41"/>
/// <code>xxxxxxxxxxxxxxx1</code> RESERVED_00   new <see cref="reserved_40"/>
#define adc_status_P10P6_P5P0_ADCSTp10  0x8000
#define adc_status_P10P6_P5P0_ADCSTp09  0x4000
#define adc_status_P10P6_P5P0_ADCSTp08  0x2000
#define adc_status_P10P6_P5P0_ADCSTp07  0x1000
#define adc_status_P10P6_P5P0_ADCSTp06  0x0800
#define adc_status_P10P6_P5P0_RESERVED_10   0x0400
#define adc_status_P10P6_P5P0_RESERVED_09   0x0200
#define adc_status_P10P6_P5P0_RESERVED_08   0x0100
#define adc_status_P10P6_P5P0_ADCSTp05  0x0080
#define adc_status_P10P6_P5P0_ADCSTp04  0x0040
#define adc_status_P10P6_P5P0_ADCSTp03  0x0020
#define adc_status_P10P6_P5P0_ADCSTp02  0x0010
#define adc_status_P10P6_P5P0_ADCSTp01  0x0008
#define adc_status_P10P6_P5P0_ADCSTp00  0x0004
#define adc_status_P10P6_P5P0_RESERVED_01   0x0002
#define adc_status_P10P6_P5P0_RESERVED_00   0x0001

/// 0x03 r/o adc_status_P11 new ADC data available
/// <code>1xxxxxxxxxxxxxxx</code> RESERVED_31  new <see cref="adc_data_port_31"/>
/// <code>x1xxxxxxxxxxxxxx</code> RESERVED_30  new <see cref="adc_data_port_30"/>
/// <code>xx1xxxxxxxxxxxxx</code> RESERVED_29  new <see cref="adc_data_port_29"/>
/// <code>xxx1xxxxxxxxxxxx</code> RESERVED_28  new <see cref="adc_data_port_28"/>
/// <code>xxxx1xxxxxxxxxxx</code> RESERVED_27  new <see cref="adc_data_port_27"/>
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_26  new <see cref="adc_data_port_26"/>
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_25  new <see cref="adc_data_port_25"/>
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_24  new <see cref="adc_data_port_24"/>
/// <code>xxxxxxxx1xxxxxxx</code> RESERVED_23  new <see cref="adc_data_port_23"/>
/// <code>xxxxxxxxx1xxxxxx</code> RESERVED_22  new <see cref="adc_data_port_22"/>
/// <code>xxxxxxxxxx1xxxxx</code> RESERVED_21  new <see cref="adc_data_port_21"/>
/// <code>xxxxxxxxxxx1xxxx</code> RESERVED_20  new <see cref="adc_data_port_20"/>
/// <code>xxxxxxxxxxxx1xxx</code> RESERVED_19  new <see cref="reserved_53"/>
/// <code>xxxxxxxxxxxxx1xx</code> RESERVED_18  new <see cref="reserved_52"/>
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_17  new <see cref="reserved_51"/>
/// <code>xxxxxxxxxxxxxxx1</code> ADCSTp11 ADCST[P11] new <see cref="adc_data_port_p11"/>
#define adc_status_P11_RESERVED_31  0x8000
#define adc_status_P11_RESERVED_30  0x4000
#define adc_status_P11_RESERVED_29  0x2000
#define adc_status_P11_RESERVED_28  0x1000
#define adc_status_P11_RESERVED_27  0x0800
#define adc_status_P11_RESERVED_26  0x0400
#define adc_status_P11_RESERVED_25  0x0200
#define adc_status_P11_RESERVED_24  0x0100
#define adc_status_P11_RESERVED_23  0x0080
#define adc_status_P11_RESERVED_22  0x0040
#define adc_status_P11_RESERVED_21  0x0020
#define adc_status_P11_RESERVED_20  0x0010
#define adc_status_P11_RESERVED_19  0x0008
#define adc_status_P11_RESERVED_18  0x0004
#define adc_status_P11_RESERVED_17  0x0002
#define adc_status_P11_ADCSTp11     0x0001

/// 0x04 r/o dac_oi_status_P10P6_P5P0 DAC Overcurrent Interrupt
/// <code>1xxxxxxxxxxxxxxx</code> DACOISTp10 DACOIST[15] new <see cref="dac_data_port_p10"/>
/// <code>x1xxxxxxxxxxxxxx</code> DACOISTp09 DACOIST[14] new <see cref="dac_data_port_p9"/>
/// <code>xx1xxxxxxxxxxxxx</code> DACOISTp08 DACOIST[13] new <see cref="dac_data_port_p8"/>
/// <code>xxx1xxxxxxxxxxxx</code> DACOISTp07 DACOIST[12] new <see cref="dac_data_port_p7"/>
/// <code>xxxx1xxxxxxxxxxx</code> DACOISTp06 DACOIST[11] new <see cref="dac_data_port_p6"/>
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_10 DACOIST[10] new <see cref="reserved_6A"/>
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_09 DACOIST[9]  new <see cref="reserved_69"/>
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_08 DACOIST[8]  new <see cref="reserved_68"/>
/// <code>xxxxxxxx1xxxxxxx</code> DACOISTp05 DACOIST[7]  new <see cref="dac_data_port_p5"/>
/// <code>xxxxxxxxx1xxxxxx</code> DACOISTp04 DACOIST[6]  new <see cref="dac_data_port_p4"/>
/// <code>xxxxxxxxxx1xxxxx</code> DACOISTp03 DACOIST[5]  new <see cref="dac_data_port_p3"/>
/// <code>xxxxxxxxxxx1xxxx</code> DACOISTp02 DACOIST[4]  new <see cref="dac_data_port_p2"/>
/// <code>xxxxxxxxxxxx1xxx</code> DACOISTp01 DACOIST[3]  new <see cref="dac_data_port_p1"/>
/// <code>xxxxxxxxxxxxx1xx</code> DACOISTp00 DACOIST[2]  new <see cref="dac_data_port_p0"/>
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_01 DACOIST[1]  new <see cref="reserved_61"/>
/// <code>xxxxxxxxxxxxxxx1</code> RESERVED_00 DACOIST[0]  new <see cref="reserved_60"/>
#define dac_oi_status_P10P6_P5P0_DACOISTp10     0x8000
#define dac_oi_status_P10P6_P5P0_DACOISTp09     0x4000
#define dac_oi_status_P10P6_P5P0_DACOISTp08     0x2000
#define dac_oi_status_P10P6_P5P0_DACOISTp07     0x1000
#define dac_oi_status_P10P6_P5P0_DACOISTp06     0x0800
#define dac_oi_status_P10P6_P5P0_RESERVED_10    0x0400
#define dac_oi_status_P10P6_P5P0_RESERVED_09    0x0200
#define dac_oi_status_P10P6_P5P0_RESERVED_08    0x0100
#define dac_oi_status_P10P6_P5P0_DACOISTp05     0x0080
#define dac_oi_status_P10P6_P5P0_DACOISTp04     0x0040
#define dac_oi_status_P10P6_P5P0_DACOISTp03     0x0020
#define dac_oi_status_P10P6_P5P0_DACOISTp02     0x0010
#define dac_oi_status_P10P6_P5P0_DACOISTp01     0x0008
#define dac_oi_status_P10P6_P5P0_DACOISTp00     0x0004
#define dac_oi_status_P10P6_P5P0_RESERVED_01    0x0002
#define dac_oi_status_P10P6_P5P0_RESERVED_00    0x0001

/// 0x05 r/o dac_oi_status_P11 DAC Overcurrent Interrupt
/// <code>1xxxxxxxxxxxxxxx</code> RESERVED_31 DACOIST[31] new <see cref="dac_data_port_31"/>
/// <code>x1xxxxxxxxxxxxxx</code> RESERVED_30 DACOIST[30] new <see cref="dac_data_port_30"/>
/// <code>xx1xxxxxxxxxxxxx</code> RESERVED_29 DACOIST[29] new <see cref="dac_data_port_29"/>
/// <code>xxx1xxxxxxxxxxxx</code> RESERVED_28 DACOIST[28] new <see cref="dac_data_port_28"/>
/// <code>xxxx1xxxxxxxxxxx</code> RESERVED_27 DACOIST[27] new <see cref="dac_data_port_27"/>
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_26 DACOIST[26] new <see cref="dac_data_port_26"/>
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_25 DACOIST[25] new <see cref="dac_data_port_25"/>
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_24 DACOIST[24] new <see cref="dac_data_port_24"/>
/// <code>xxxxxxxx1xxxxxxx</code> RESERVED_23 DACOIST[23] new <see cref="dac_data_port_23"/>
/// <code>xxxxxxxxx1xxxxxx</code> RESERVED_22 DACOIST[22] new <see cref="dac_data_port_22"/>
/// <code>xxxxxxxxxx1xxxxx</code> RESERVED_21 DACOIST[21] new <see cref="dac_data_port_21"/>
/// <code>xxxxxxxxxxx1xxxx</code> RESERVED_20 DACOIST[20] new <see cref="dac_data_port_20"/>
/// <code>xxxxxxxxxxxx1xxx</code> RESERVED_19 DACOIST[19] new <see cref="reserved_73"/>
/// <code>xxxxxxxxxxxxx1xx</code> RESERVED_18 DACOIST[18] new <see cref="reserved_72"/>
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_17 DACOIST[17] new <see cref="reserved_71"/>
/// <code>xxxxxxxxxxxxxxx1</code> DACOISTp11 DACOIST[16] new <see cref="dac_data_port_p11"/>
#define dac_oi_status_P11_RESERVED_31   0x8000
#define dac_oi_status_P11_RESERVED_30   0x4000
#define dac_oi_status_P11_RESERVED_29   0x2000
#define dac_oi_status_P11_RESERVED_28   0x1000
#define dac_oi_status_P11_RESERVED_27   0x0800
#define dac_oi_status_P11_RESERVED_26   0x0400
#define dac_oi_status_P11_RESERVED_25   0x0200
#define dac_oi_status_P11_RESERVED_24   0x0100
#define dac_oi_status_P11_RESERVED_23   0x0080
#define dac_oi_status_P11_RESERVED_22   0x0040
#define dac_oi_status_P11_RESERVED_21   0x0020
#define dac_oi_status_P11_RESERVED_20   0x0010
#define dac_oi_status_P11_RESERVED_19   0x0008
#define dac_oi_status_P11_RESERVED_18   0x0004
#define dac_oi_status_P11_RESERVED_17   0x0002
#define dac_oi_status_P11_DACOISTp11    0x0001

/// 0x06 r/o gpi_status_P10P6_P5P0 GPI event ready
/// <code>1xxxxxxxxxxxxxxx</code> RESERVED_010 GPIST[15]
/// <code>x1xxxxxxxxxxxxxx</code> RESERVED_009 GPIST[14]
/// <code>xx1xxxxxxxxxxxxx</code> RESERVED_008 GPIST[13]
/// <code>xxx1xxxxxxxxxxxx</code> RESERVED_007 GPIST[12]
/// <code>xxxx1xxxxxxxxxxx</code> RESERVED_006 GPIST[11]
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_10 GPIST[10]
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_09 GPIST[9]
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_08 GPIST[8]
/// <code>xxxxxxxx1xxxxxxx</code> GPISTp05 GPIST[7]
/// <code>xxxxxxxxx1xxxxxx</code> GPISTp04 GPIST[6]
/// <code>xxxxxxxxxx1xxxxx</code> GPISTp03 GPIST[5]
/// <code>xxxxxxxxxxx1xxxx</code> GPISTp02 GPIST[4]
/// <code>xxxxxxxxxxxx1xxx</code> GPISTp01 GPIST[3]
/// <code>xxxxxxxxxxxxx1xx</code> GPISTp00 GPIST[2]
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_01 GPIST[1]
/// <code>xxxxxxxxxxxxxxx1</code> RESERVED_00 GPIST[0]
#define gpi_status_P10P6_P5P0_RESERVED_010  0x8000
#define gpi_status_P10P6_P5P0_RESERVED_009  0x4000
#define gpi_status_P10P6_P5P0_RESERVED_008  0x2000
#define gpi_status_P10P6_P5P0_RESERVED_007  0x1000
#define gpi_status_P10P6_P5P0_RESERVED_006  0x0800
#define gpi_status_P10P6_P5P0_RESERVED_10   0x0400
#define gpi_status_P10P6_P5P0_RESERVED_09   0x0200
#define gpi_status_P10P6_P5P0_RESERVED_08   0x0100
#define gpi_status_P10P6_P5P0_GPISTp05  0x0080
#define gpi_status_P10P6_P5P0_GPISTp04  0x0040
#define gpi_status_P10P6_P5P0_GPISTp03  0x0020
#define gpi_status_P10P6_P5P0_GPISTp02  0x0010
#define gpi_status_P10P6_P5P0_GPISTp01  0x0008
#define gpi_status_P10P6_P5P0_GPISTp00  0x0004
#define gpi_status_P10P6_P5P0_RESERVED_01   0x0002
#define gpi_status_P10P6_P5P0_RESERVED_00   0x0001

/// 0x07 r/o gpi_status_P11 GPI event ready
/// <code>1xxxxxxxxxxxxxxx</code> RESERVED_31 GPIST[31]
/// <code>x1xxxxxxxxxxxxxx</code> RESERVED_30 GPIST[30]
/// <code>xx1xxxxxxxxxxxxx</code> RESERVED_29 GPIST[29]
/// <code>xxx1xxxxxxxxxxxx</code> RESERVED_28 GPIST[28]
/// <code>xxxx1xxxxxxxxxxx</code> RESERVED_27 GPIST[27]
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_26 GPIST[26]
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_25 GPIST[25]
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_24 GPIST[24]
/// <code>xxxxxxxx1xxxxxxx</code> RESERVED_23 GPIST[23]
/// <code>xxxxxxxxx1xxxxxx</code> RESERVED_22 GPIST[22]
/// <code>xxxxxxxxxx1xxxxx</code> RESERVED_21 GPIST[21]
/// <code>xxxxxxxxxxx1xxxx</code> RESERVED_20 GPIST[20]
/// <code>xxxxxxxxxxxx1xxx</code> RESERVED_19 GPIST[19]
/// <code>xxxxxxxxxxxxx1xx</code> RESERVED_18 GPIST[18]
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_17 GPIST[17]
/// <code>xxxxxxxxxxxxxxx1</code> GPISTp11 GPIST[16]
#define gpi_status_P11_RESERVED_31  0x8000
#define gpi_status_P11_RESERVED_30  0x4000
#define gpi_status_P11_RESERVED_29  0x2000
#define gpi_status_P11_RESERVED_28  0x1000
#define gpi_status_P11_RESERVED_27  0x0800
#define gpi_status_P11_RESERVED_26  0x0400
#define gpi_status_P11_RESERVED_25  0x0200
#define gpi_status_P11_RESERVED_24  0x0100
#define gpi_status_P11_RESERVED_23  0x0080
#define gpi_status_P11_RESERVED_22  0x0040
#define gpi_status_P11_RESERVED_21  0x0020
#define gpi_status_P11_RESERVED_20  0x0010
#define gpi_status_P11_RESERVED_19  0x0008
#define gpi_status_P11_RESERVED_18  0x0004
#define gpi_status_P11_RESERVED_17  0x0002
#define gpi_status_P11_GPISTp11     0x0001

/// 0x08 r/o tmp_int_data Internal Temeprature
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_int_data_tempcode   0x0fff

/// 0x09 r/o tmp_ext1_data External Temperature D0P/D0N
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_ext1_data_tempcode  0x0fff

/// 0x0a r/o tmp_ext2_data External Temperature D1P/D1N
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_ext2_data_tempcode  0x0fff

/// 0x0b r/o gpi_data_P10P6_P5P0 GPI input ports data
/// <code>1xxxxxxxxxxxxxxx</code> GPIDATp10 GPIDAT[15]
/// <code>x1xxxxxxxxxxxxxx</code> GPIDATp09 GPIDAT[14]
/// <code>xx1xxxxxxxxxxxxx</code> GPIDATp08 GPIDAT[13]
/// <code>xxx1xxxxxxxxxxxx</code> GPIDATp07 GPIDAT[12]
/// <code>xxxx1xxxxxxxxxxx</code> GPIDATp06 GPIDAT[11]
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_10 GPIDAT[10]
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_09 GPIDAT[9]
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_08 GPIDAT[8]
/// <code>xxxxxxxx1xxxxxxx</code> GPIDATp05 GPIDAT[7]
/// <code>xxxxxxxxx1xxxxxx</code> GPIDATp04 GPIDAT[6]
/// <code>xxxxxxxxxx1xxxxx</code> GPIDATp03 GPIDAT[5]
/// <code>xxxxxxxxxxx1xxxx</code> GPIDATp02 GPIDAT[4]
/// <code>xxxxxxxxxxxx1xxx</code> GPIDATp01 GPIDAT[3]
/// <code>xxxxxxxxxxxxx1xx</code> GPIDATp00 GPIDAT[2]
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_01 GPIDAT[1]
/// <code>xxxxxxxxxxxxxxx1</code> RESERVED_00 GPIDAT[0]
#define gpi_data_P10P6_P5P0_GPIDATp10   0x8000
#define gpi_data_P10P6_P5P0_GPIDATp09   0x4000
#define gpi_data_P10P6_P5P0_GPIDATp08   0x2000
#define gpi_data_P10P6_P5P0_GPIDATp07   0x1000
#define gpi_data_P10P6_P5P0_GPIDATp06   0x0800
#define gpi_data_P10P6_P5P0_RESERVED_10     0x0400
#define gpi_data_P10P6_P5P0_RESERVED_09     0x0200
#define gpi_data_P10P6_P5P0_RESERVED_08     0x0100
#define gpi_data_P10P6_P5P0_GPIDATp05   0x0080
#define gpi_data_P10P6_P5P0_GPIDATp04   0x0040
#define gpi_data_P10P6_P5P0_GPIDATp03   0x0020
#define gpi_data_P10P6_P5P0_GPIDATp02   0x0010
#define gpi_data_P10P6_P5P0_GPIDATp01   0x0008
#define gpi_data_P10P6_P5P0_GPIDATp00   0x0004
#define gpi_data_P10P6_P5P0_RESERVED_01     0x0002
#define gpi_data_P10P6_P5P0_RESERVED_00     0x0001

/// 0x0c r/o gpi_data_P11 GPI input ports data
/// <code>1xxxxxxxxxxxxxxx</code> RESERVED_31 GPIDAT[31]
/// <code>x1xxxxxxxxxxxxxx</code> RESERVED_30 GPIDAT[30]
/// <code>xx1xxxxxxxxxxxxx</code> RESERVED_29 GPIDAT[29]
/// <code>xxx1xxxxxxxxxxxx</code> RESERVED_28 GPIDAT[28]
/// <code>xxxx1xxxxxxxxxxx</code> RESERVED_27 GPIDAT[27]
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_26 GPIDAT[26]
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_25 GPIDAT[25]
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_24 GPIDAT[24]
/// <code>xxxxxxxx1xxxxxxx</code> RESERVED_23 GPIDAT[23]
/// <code>xxxxxxxxx1xxxxxx</code> RESERVED_22 GPIDAT[22]
/// <code>xxxxxxxxxx1xxxxx</code> RESERVED_21 GPIDAT[21]
/// <code>xxxxxxxxxxx1xxxx</code> RESERVED_20 GPIDAT[20]
/// <code>xxxxxxxxxxxx1xxx</code> RESERVED_19 GPIDAT[19]
/// <code>xxxxxxxxxxxxx1xx</code> RESERVED_18 GPIDAT[18]
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_17 GPIDAT[17]
/// <code>xxxxxxxxxxxxxxx1</code> GPIDATp11 GPIDAT[16]
#define gpi_data_P11_RESERVED_31    0x8000
#define gpi_data_P11_RESERVED_30    0x4000
#define gpi_data_P11_RESERVED_29    0x2000
#define gpi_data_P11_RESERVED_28    0x1000
#define gpi_data_P11_RESERVED_27    0x0800
#define gpi_data_P11_RESERVED_26    0x0400
#define gpi_data_P11_RESERVED_25    0x0200
#define gpi_data_P11_RESERVED_24    0x0100
#define gpi_data_P11_RESERVED_23    0x0080
#define gpi_data_P11_RESERVED_22    0x0040
#define gpi_data_P11_RESERVED_21    0x0020
#define gpi_data_P11_RESERVED_20    0x0010
#define gpi_data_P11_RESERVED_19    0x0008
#define gpi_data_P11_RESERVED_18    0x0004
#define gpi_data_P11_RESERVED_17    0x0002
#define gpi_data_P11_GPIDATp11  0x0001

/// 0x0d r/w gpo_data_P10P6_P5P0 GPO output ports data
/// <code>1xxxxxxxxxxxxxxx</code> GPODATp10 GPODAT[15]
/// <code>x1xxxxxxxxxxxxxx</code> GPODATp09 GPODAT[14]
/// <code>xx1xxxxxxxxxxxxx</code> GPODATp08 GPODAT[13]
/// <code>xxx1xxxxxxxxxxxx</code> GPODATp07 GPODAT[12]
/// <code>xxxx1xxxxxxxxxxx</code> GPODATp06 GPODAT[11]
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_10 GPODAT[10]
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_09 GPODAT[9]
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_08 GPODAT[8]
/// <code>xxxxxxxx1xxxxxxx</code> GPODATp05 GPODAT[7]
/// <code>xxxxxxxxx1xxxxxx</code> GPODATp04 GPODAT[6]
/// <code>xxxxxxxxxx1xxxxx</code> GPODATp03 GPODAT[5]
/// <code>xxxxxxxxxxx1xxxx</code> GPODATp02 GPODAT[4]
/// <code>xxxxxxxxxxxx1xxx</code> GPODATp01 GPODAT[3]
/// <code>xxxxxxxxxxxxx1xx</code> GPODATp00 GPODAT[2]
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_01 GPODAT[1]
/// <code>xxxxxxxxxxxxxxx1</code> RESERVED_00 GPODAT[0]
#define gpo_data_P10P6_P5P0_GPODATp10   0x8000
#define gpo_data_P10P6_P5P0_GPODATp09   0x4000
#define gpo_data_P10P6_P5P0_GPODATp08   0x2000
#define gpo_data_P10P6_P5P0_GPODATp07   0x1000
#define gpo_data_P10P6_P5P0_GPODATp06   0x0800
#define gpo_data_P10P6_P5P0_RESERVED_10     0x0400
#define gpo_data_P10P6_P5P0_RESERVED_09     0x0200
#define gpo_data_P10P6_P5P0_RESERVED_08     0x0100
#define gpo_data_P10P6_P5P0_GPODATp05   0x0080
#define gpo_data_P10P6_P5P0_GPODATp04   0x0040
#define gpo_data_P10P6_P5P0_GPODATp03   0x0020
#define gpo_data_P10P6_P5P0_GPODATp02   0x0010
#define gpo_data_P10P6_P5P0_GPODATp01   0x0008
#define gpo_data_P10P6_P5P0_GPODATp00   0x0004
#define gpo_data_P10P6_P5P0_RESERVED_01     0x0002
#define gpo_data_P10P6_P5P0_RESERVED_00     0x0001
#define gpo_data_P10P6_P5P0_DESIGNVALUE     0x0000

/// 0x0e r/w gpo_data_P11 GPO output ports data
/// <code>1xxxxxxxxxxxxxxx</code> RESERVED_31 GPODAT[31]
/// <code>x1xxxxxxxxxxxxxx</code> RESERVED_30 GPODAT[30]
/// <code>xx1xxxxxxxxxxxxx</code> RESERVED_29 GPODAT[29]
/// <code>xxx1xxxxxxxxxxxx</code> RESERVED_28 GPODAT[28]
/// <code>xxxx1xxxxxxxxxxx</code> RESERVED_27 GPODAT[27]
/// <code>xxxxx1xxxxxxxxxx</code> RESERVED_26 GPODAT[26]
/// <code>xxxxxx1xxxxxxxxx</code> RESERVED_25 GPODAT[25]
/// <code>xxxxxxx1xxxxxxxx</code> RESERVED_24 GPODAT[24]
/// <code>xxxxxxxx1xxxxxxx</code> RESERVED_23 GPODAT[23]
/// <code>xxxxxxxxx1xxxxxx</code> RESERVED_22 GPODAT[22]
/// <code>xxxxxxxxxx1xxxxx</code> RESERVED_21 GPODAT[21]
/// <code>xxxxxxxxxxx1xxxx</code> RESERVED_20 GPODAT[20]
/// <code>xxxxxxxxxxxx1xxx</code> RESERVED_19 GPODAT[19]
/// <code>xxxxxxxxxxxxx1xx</code> RESERVED_18 GPODAT[18]
/// <code>xxxxxxxxxxxxxx1x</code> RESERVED_17 GPODAT[17]
/// <code>xxxxxxxxxxxxxxx1</code> GPODATp11 GPODAT[16]
#define gpo_data_P11_RESERVED_31    0x8000
#define gpo_data_P11_RESERVED_30    0x4000
#define gpo_data_P11_RESERVED_29    0x2000
#define gpo_data_P11_RESERVED_28    0x1000
#define gpo_data_P11_RESERVED_27    0x0800
#define gpo_data_P11_RESERVED_26    0x0400
#define gpo_data_P11_RESERVED_25    0x0200
#define gpo_data_P11_RESERVED_24    0x0100
#define gpo_data_P11_RESERVED_23    0x0080
#define gpo_data_P11_RESERVED_22    0x0040
#define gpo_data_P11_RESERVED_21    0x0020
#define gpo_data_P11_RESERVED_20    0x0010
#define gpo_data_P11_RESERVED_19    0x0008
#define gpo_data_P11_RESERVED_18    0x0004
#define gpo_data_P11_RESERVED_17    0x0002
#define gpo_data_P11_GPODATp11  0x0001
#define gpo_data_P11_DESIGNVALUE    0x0000

/// 0x0f r/o reserved_0F reserved


/// 0x10 r/w device_control Global device control register
/// <code>1xxxxxxxxxxxxxxx</code> RESET Soft reset command
/// - 0 = No operation
/// - 1 = Perform power-on reset. (This bit is self-clearing.)
/// <code>x1xxxxxxxxxxxxxx</code> BRST Burst Mode
/// - 0 = Automatically increment register address in serial interface burst mode.
/// - 1 = Burst Read cycle through only the ADC data ports; 
///       Burst Write cycle through only the DAC data ports.
/// <code>xx1xxxxxxxxxxxxx</code> LPEN Low Power Enable
/// - 0 = Normal operation
/// - 1 = Sleep mode
/// <code>xxx1xxxxxxxxxxxx</code> RS_CANCEL series resistance cancelation on external temperature monitors D0P/D0N and D1P/D1N
/// - 0 = Disable series resistance cancelation on external temperature monitors D0P/D0N and D1P/D1N
/// - 1 =  Enable series resistance cancelation on external temperature monitors D0P/D0N and D1P/D1N
/// <code>xxxx1xxxxxxxxxxx</code> TMPPER temperature monitor period
/// - 0 = min IH period is 32.5μsec, hold time of SAMPLE is  7μsec.
/// - 1 = min IH period is 65.0μsec, hold time of SAMPLE is 15μsec.
/// <code>xxxxx1xxxxxxxxxx</code> TMPCTLEXT1 monitor external temperature D1P/D1N
/// <code>xxxxxx1xxxxxxxxx</code> TMPCTLEXT0 monitor external temperature D0P/D0N
/// <code>xxxxxxx1xxxxxxxx</code> TMPCTLINT monitor internal temperature
/// <code>xxxxxxxx1xxxxxxx</code> THSHDN Thermal Shutdown
/// - 0 = Disable Thermal Shutdown
/// - 1 = Enable Thermal Shutdown: reset all ports to hi-Z if <see cref="tmp_int_data"/> is greater than 145 degrees C
/// <code>xxxxxxxxx1xxxxxx</code> DACREF DAC voltage reference
/// - 0 = External DAC voltage reference
/// - 1 = Internal DAC voltage reference
/// <code>xxxxxxxxxx11xxxx</code> ADCCONV ADC conversion rate
/// - 0 = 200Ksps
/// - 1 = 250Ksps
/// - 2 = 333Ksps
/// - 3 = 400Ksps
/// <code>xxxxxxxxxxxx11xx</code> DACCTL DAC update mode
/// - 0 = Update DAC values in normal sequence
/// - 1 = Update DAC immediately after dac_data_port_xx write
/// - 2 = All DAC data registers loaded with <see cref="dac_preset_data_1"/>
/// - 3 = All DAC data registers loaded with <see cref="dac_preset_data_2"/>
/// <code>xxxxxxxxxxxxxx11</code> ADCCTL ADC conversion mode
/// - 0 = Idle mode
/// - 1 = Single sweep triggered by CNVTB pin
/// - 2 = Single conversion triggered by CNVTB pin
/// - 3 = Continuous sweep
#define device_control_RESET    0x8000
#define device_control_BRST     0x4000
#define device_control_LPEN     0x2000
#define device_control_RS_CANCEL    0x1000
#define device_control_TMPPER   0x0800
#define device_control_TMPCTLEXT1   0x0400
#define device_control_TMPCTLEXT0   0x0200
#define device_control_TMPCTLINT    0x0100
#define device_control_THSHDN   0x0080
#define device_control_DACREF   0x0040
#define device_control_ADCCONV  0x0030
#define device_control_DACCTL   0x000c
#define device_control_ADCCTL   0x0003
#define device_control_DESIGNVALUE  0x17c1

/// 0x11 r/w interrupt_mask interrupt mask (1 = disable interrupt source)
/// <code>1xxxxxxxxxxxxxxx</code> VMON High Voltage Supply Monitor
/// <code>x1xxxxxxxxxxxxxx</code> TMPEXT2HOT External Temperature D1P/D1N Hot
/// <code>xx1xxxxxxxxxxxxx</code> TMPEXT2COLD External Temperature D1P/D1N Cold
/// <code>xxx1xxxxxxxxxxxx</code> TMPEXT2NEW External Temperature D1P/D1N New
/// <code>xxxx1xxxxxxxxxxx</code> TMPEXT1HOT External Temperature D0P/D0N Hot
/// <code>xxxxx1xxxxxxxxxx</code> TMPEXT1COLD External Temperature D0P/D0N Cold
/// <code>xxxxxx1xxxxxxxxx</code> TMPEXT1NEW External Temperature D0P/D0N New
/// <code>xxxxxxx1xxxxxxxx</code> TMPINTHOT Internal Temeprature Hot
/// <code>xxxxxxxx1xxxxxxx</code> TMPINTCOLD Internal Temeprature Cold
/// <code>xxxxxxxxx1xxxxxx</code> TMPINTNEW Internal Temeprature New
/// <code>xxxxxxxxxx1xxxxx</code> DACOI DAC over-current
/// <code>xxxxxxxxxxx1xxxx</code> GPIDM GPI event missed
/// <code>xxxxxxxxxxxx1xxx</code> GPIDR GPI event ready
/// <code>xxxxxxxxxxxxx1xx</code> ADCDM ADC data missed
/// <code>xxxxxxxxxxxxxx1x</code> ADCDR ADC data ready
/// <code>xxxxxxxxxxxxxxx1</code> ADCFLAG ADC conversion/sweep complete
#define interrupt_mask_VMON     0x8000
#define interrupt_mask_TMPEXT2HOT   0x4000
#define interrupt_mask_TMPEXT2COLD  0x2000
#define interrupt_mask_TMPEXT2NEW   0x1000
#define interrupt_mask_TMPEXT1HOT   0x0800
#define interrupt_mask_TMPEXT1COLD  0x0400
#define interrupt_mask_TMPEXT1NEW   0x0200
#define interrupt_mask_TMPINTHOT    0x0100
#define interrupt_mask_TMPINTCOLD   0x0080
#define interrupt_mask_TMPINTNEW    0x0040
#define interrupt_mask_DACOI    0x0020
#define interrupt_mask_GPIDM    0x0010
#define interrupt_mask_GPIDR    0x0008
#define interrupt_mask_ADCDM    0x0004
#define interrupt_mask_ADCDR    0x0002
#define interrupt_mask_ADCFLAG  0x0001
#define interrupt_mask_DESIGNVALUE  0xfffd

/// 0x12 r/w gpi_irqmode_P5_P0 GPI ports P5 to P0 mode register
/// <code>11xxxxxxxxxxxxxx</code> GPIMDp05 GPIMD[7]
/// <code>xx11xxxxxxxxxxxx</code> GPIMDp04 GPIMD[6]
/// <code>xxxx11xxxxxxxxxx</code> GPIMDp03 GPIMD[5]
/// <code>xxxxxx11xxxxxxxx</code> GPIMDp02 GPIMD[4]
/// <code>xxxxxxxx11xxxxxx</code> GPIMDp01 GPIMD[3]
/// <code>xxxxxxxxxx11xxxx</code> GPIMDp00 GPIMD[2]
/// <code>xxxxxxxxxxxx11xx</code> RESERVED_01 GPIMD[1]
/// <code>xxxxxxxxxxxxxx11</code> RESERVED_00 GPIMD[0]
/// <para>GPIMD[portId] interrupt mask bits:
/// - 0 = masked
/// - 1 = detect positive edge
/// - 2 = detect negative edge
/// - 3 = detect positive or negative edge
/// </para>
#define gpi_irqmode_P5_P0_GPIMDp05  0xc000
#define gpi_irqmode_P5_P0_GPIMDp04  0x3000
#define gpi_irqmode_P5_P0_GPIMDp03  0x0c00
#define gpi_irqmode_P5_P0_GPIMDp02  0x0300
#define gpi_irqmode_P5_P0_GPIMDp01  0x00c0
#define gpi_irqmode_P5_P0_GPIMDp00  0x0030
#define gpi_irqmode_P5_P0_RESERVED_01   0x000c
#define gpi_irqmode_P5_P0_RESERVED_00   0x0003
#define gpi_irqmode_P5_P0_DESIGNVALUE   0x0000

/// 0x13 r/w gpi_irqmode_P10_P6 GPI ports P10 to P6 mode register
/// <code>11xxxxxxxxxxxxxx</code> GPIMDp10 GPIMD[15]
/// <code>xx11xxxxxxxxxxxx</code> GPIMDp09 GPIMD[14]
/// <code>xxxx11xxxxxxxxxx</code> GPIMDp08 GPIMD[13]
/// <code>xxxxxx11xxxxxxxx</code> GPIMDp07 GPIMD[12]
/// <code>xxxxxxxx11xxxxxx</code> GPIMDp06 GPIMD[11]
/// <code>xxxxxxxxxx11xxxx</code> RESERVED_10 GPIMD[10]
/// <code>xxxxxxxxxxxx11xx</code> RESERVED_09 GPIMD[9]
/// <code>xxxxxxxxxxxxxx11</code> RESERVED_08 GPIMD[8]
/// <para>GPIMD[portId] interrupt mask bits:
/// - 0 = masked
/// - 1 = detect positive edge
/// - 2 = detect negative edge
/// - 3 = detect positive or negative edge
/// </para>
#define gpi_irqmode_P10_P6_GPIMDp10     0xc000
#define gpi_irqmode_P10_P6_GPIMDp09     0x3000
#define gpi_irqmode_P10_P6_GPIMDp08     0x0c00
#define gpi_irqmode_P10_P6_GPIMDp07     0x0300
#define gpi_irqmode_P10_P6_GPIMDp06     0x00c0
#define gpi_irqmode_P10_P6_RESERVED_10  0x0030
#define gpi_irqmode_P10_P6_RESERVED_09  0x000c
#define gpi_irqmode_P10_P6_RESERVED_08  0x0003
#define gpi_irqmode_P10_P6_DESIGNVALUE  0x0000

/// 0x14 r/w gpi_irqmode_P11 GPI port P11 mode register
/// <code>11xxxxxxxxxxxxxx</code> RESERVED_23 GPIMD[23]
/// <code>xx11xxxxxxxxxxxx</code> RESERVED_22 GPIMD[22]
/// <code>xxxx11xxxxxxxxxx</code> RESERVED_21 GPIMD[21]
/// <code>xxxxxx11xxxxxxxx</code> RESERVED_20 GPIMD[20]
/// <code>xxxxxxxx11xxxxxx</code> RESERVED_19 GPIMD[19]
/// <code>xxxxxxxxxx11xxxx</code> RESERVED_18 GPIMD[18]
/// <code>xxxxxxxxxxxx11xx</code> RESERVED_17 GPIMD[17]
/// <code>xxxxxxxxxxxxxx11</code> GPIMDp11 GPIMD[16]
/// <para>GPIMD[portId] interrupt mask bits:
/// - 0 = masked
/// - 1 = detect positive edge
/// - 2 = detect negative edge
/// - 3 = detect positive or negative edge
/// </para>
#define gpi_irqmode_P11_RESERVED_23     0xc000
#define gpi_irqmode_P11_RESERVED_22     0x3000
#define gpi_irqmode_P11_RESERVED_21     0x0c00
#define gpi_irqmode_P11_RESERVED_20     0x0300
#define gpi_irqmode_P11_RESERVED_19     0x00c0
#define gpi_irqmode_P11_RESERVED_18     0x0030
#define gpi_irqmode_P11_RESERVED_17     0x000c
#define gpi_irqmode_P11_GPIMDp11    0x0003
#define gpi_irqmode_P11_DESIGNVALUE     0x0000

/// 0x15 r/w reserved_15 (reserved)
/// <code>11xxxxxxxxxxxxxx</code> RESERVED_31 GPIMD[31]
/// <code>xx11xxxxxxxxxxxx</code> RESERVED_30 GPIMD[30]
/// <code>xxxx11xxxxxxxxxx</code> RESERVED_29 GPIMD[29]
/// <code>xxxxxx11xxxxxxxx</code> RESERVED_28 GPIMD[28]
/// <code>xxxxxxxx11xxxxxx</code> RESERVED_27 GPIMD[27]
/// <code>xxxxxxxxxx11xxxx</code> RESERVED_26 GPIMD[26]
/// <code>xxxxxxxxxxxx11xx</code> RESERVED_25 GPIMD[25]
/// <code>xxxxxxxxxxxxxx11</code> RESERVED_24 GPIMD[24]
/// <para>GPIMD[portId] interrupt mask bits:
/// - 0 = masked
/// - 1 = detect positive edge
/// - 2 = detect negative edge
/// - 3 = detect positive or negative edge
/// </para>
#define reserved_15_RESERVED_31     0xc000
#define reserved_15_RESERVED_30     0x3000
#define reserved_15_RESERVED_29     0x0c00
#define reserved_15_RESERVED_28     0x0300
#define reserved_15_RESERVED_27     0x00c0
#define reserved_15_RESERVED_26     0x0030
#define reserved_15_RESERVED_25     0x000c
#define reserved_15_RESERVED_24     0x0003

/// 0x16 r/w dac_preset_data_1 DAC preset activated by <see cref="device_control"/>
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_preset_data_1_daccode   0x0fff
#define dac_preset_data_1_DESIGNVALUE   0x0000

/// 0x17 r/w dac_preset_data_2 DAC preset activated by <see cref="device_control"/>
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_preset_data_2_daccode   0x0fff
#define dac_preset_data_2_DESIGNVALUE   0x0000

/// 0x18 r/w tmp_mon_cfg Temperautre Monitor Configuration
/// <code>xxxxxxxxxx11xxxx</code> TMPEXT2MONCFG average 4, 8, 16, or 32 measurements
/// <code>xxxxxxxxxxxx11xx</code> TMPEXT1MONCFG average 4, 8, 16, or 32 measurements
/// <code>xxxxxxxxxxxxxx11</code> TMPINTMONCFG average 4, 8, 16, or 32 measurements
/// <para>Temperautre Monitor Configuration:
/// - 0 = 4 measurements (default)
/// - 1 = 8 measurements
/// - 2 = 16 measurements
/// - 3 = 32 measurements
/// </para>
#define tmp_mon_cfg_TMPEXT2MONCFG   0x0030
#define tmp_mon_cfg_TMPEXT1MONCFG   0x000c
#define tmp_mon_cfg_TMPINTMONCFG    0x0003
#define tmp_mon_cfg_DESIGNVALUE     0x003f

/// 0x19 r/w tmp_mon_int_hi_thresh Internal Temeprature Hot Threshold
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_mon_int_hi_thresh_tempcode  0x0fff
#define tmp_mon_int_hi_thresh_DESIGNVALUE   0x07ff

/// 0x1a r/w tmp_mon_int_lo_thresh Internal Temeprature Cold Threshold
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_mon_int_lo_thresh_tempcode  0x0fff
#define tmp_mon_int_lo_thresh_DESIGNVALUE   0x0800

/// 0x1b r/w tmp_mon_ext1_hi_thresh External Temperature D0P/D0N Hot Threshold
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_mon_ext1_hi_thresh_tempcode     0x0fff
#define tmp_mon_ext1_hi_thresh_DESIGNVALUE  0x07ff

/// 0x1c r/w tmp_mon_ext1_lo_thresh External Temperature D0P/D0N Cold Threshold
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_mon_ext1_lo_thresh_tempcode     0x0fff
#define tmp_mon_ext1_lo_thresh_DESIGNVALUE  0x0800

/// 0x1d r/w tmp_mon_ext2_hi_thresh External Temperature D1P/D1N Hot Threshold
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_mon_ext2_hi_thresh_tempcode     0x0fff
#define tmp_mon_ext2_hi_thresh_DESIGNVALUE  0x07ff

/// 0x1e r/w tmp_mon_ext2_lo_thresh External Temperature D1P/D1N Cold Threshold
/// <code>xxxx111111111111</code> tempcode Temperature code, LSB=0.125 degrees C, 12-bit 2's complement
#define tmp_mon_ext2_lo_thresh_tempcode     0x0fff
#define tmp_mon_ext2_lo_thresh_DESIGNVALUE  0x0800

/// 0x1f r/w reserved_1F reserved


/// 0x20 r/w reserved_20 (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_20_PortCfgFuncID   0xf000
#define reserved_20_funcprm_avrInv  0x0800
#define reserved_20_funcprm_range   0x0700
#define reserved_20_funcprm_nsamples    0x00e0
#define reserved_20_funcprm_port    0x001f
#define reserved_20_DESIGNVALUE     0x0000

/// 0x21 r/w reserved_21 (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_21_PortCfgFuncID   0xf000
#define reserved_21_funcprm_avrInv  0x0800
#define reserved_21_funcprm_range   0x0700
#define reserved_21_funcprm_nsamples    0x00e0
#define reserved_21_funcprm_port    0x001f
#define reserved_21_DESIGNVALUE     0x0000

/// 0x22 r/w port_cfg_p0 PIXI port P0 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p0_PortCfgFuncID   0xf000
#define port_cfg_p0_funcprm_avrInv  0x0800
#define port_cfg_p0_funcprm_range   0x0700
#define port_cfg_p0_funcprm_nsamples    0x00e0
#define port_cfg_p0_funcprm_port    0x001f
#define port_cfg_p0_DESIGNVALUE     0x74e0

/// 0x23 r/w port_cfg_p1 PIXI port P1 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p1_PortCfgFuncID   0xf000
#define port_cfg_p1_funcprm_avrInv  0x0800
#define port_cfg_p1_funcprm_range   0x0700
#define port_cfg_p1_funcprm_nsamples    0x00e0
#define port_cfg_p1_funcprm_port    0x001f
#define port_cfg_p1_DESIGNVALUE     0x0000

/// 0x24 r/w port_cfg_p2 PIXI port P2 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p2_PortCfgFuncID   0xf000
#define port_cfg_p2_funcprm_avrInv  0x0800
#define port_cfg_p2_funcprm_range   0x0700
#define port_cfg_p2_funcprm_nsamples    0x00e0
#define port_cfg_p2_funcprm_port    0x001f
#define port_cfg_p2_DESIGNVALUE     0x74e0

/// 0x25 r/w port_cfg_p3 PIXI port P3 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p3_PortCfgFuncID   0xf000
#define port_cfg_p3_funcprm_avrInv  0x0800
#define port_cfg_p3_funcprm_range   0x0700
#define port_cfg_p3_funcprm_nsamples    0x00e0
#define port_cfg_p3_funcprm_port    0x001f
#define port_cfg_p3_DESIGNVALUE     0x5100

/// 0x26 r/w port_cfg_p4 PIXI port P4 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p4_PortCfgFuncID   0xf000
#define port_cfg_p4_funcprm_avrInv  0x0800
#define port_cfg_p4_funcprm_range   0x0700
#define port_cfg_p4_funcprm_nsamples    0x00e0
#define port_cfg_p4_funcprm_port    0x001f
#define port_cfg_p4_DESIGNVALUE     0x71e0

/// 0x27 r/w port_cfg_p5 PIXI port P5 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p5_PortCfgFuncID   0xf000
#define port_cfg_p5_funcprm_avrInv  0x0800
#define port_cfg_p5_funcprm_range   0x0700
#define port_cfg_p5_funcprm_nsamples    0x00e0
#define port_cfg_p5_funcprm_port    0x001f
#define port_cfg_p5_DESIGNVALUE     0x5100

/// 0x28 r/w reserved_28 (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_28_PortCfgFuncID   0xf000
#define reserved_28_funcprm_avrInv  0x0800
#define reserved_28_funcprm_range   0x0700
#define reserved_28_funcprm_nsamples    0x00e0
#define reserved_28_funcprm_port    0x001f
#define reserved_28_DESIGNVALUE     0x0000

/// 0x29 r/w reserved_29 (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_29_PortCfgFuncID   0xf000
#define reserved_29_funcprm_avrInv  0x0800
#define reserved_29_funcprm_range   0x0700
#define reserved_29_funcprm_nsamples    0x00e0
#define reserved_29_funcprm_port    0x001f
#define reserved_29_DESIGNVALUE     0x0000

/// 0x2a r/w reserved_2A (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_2A_PortCfgFuncID   0xf000
#define reserved_2A_funcprm_avrInv  0x0800
#define reserved_2A_funcprm_range   0x0700
#define reserved_2A_funcprm_nsamples    0x00e0
#define reserved_2A_funcprm_port    0x001f
#define reserved_2A_DESIGNVALUE     0x0000

/// 0x2b r/w port_cfg_p6 PIXI port P6 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p6_PortCfgFuncID   0xf000
#define port_cfg_p6_funcprm_avrInv  0x0800
#define port_cfg_p6_funcprm_range   0x0700
#define port_cfg_p6_funcprm_nsamples    0x00e0
#define port_cfg_p6_funcprm_port    0x001f
#define port_cfg_p6_DESIGNVALUE     0x74e0

/// 0x2c r/w port_cfg_p7 PIXI port P7 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p7_PortCfgFuncID   0xf000
#define port_cfg_p7_funcprm_avrInv  0x0800
#define port_cfg_p7_funcprm_range   0x0700
#define port_cfg_p7_funcprm_nsamples    0x00e0
#define port_cfg_p7_funcprm_port    0x001f
#define port_cfg_p7_DESIGNVALUE     0x0000

/// 0x2d r/w port_cfg_p8 PIXI port P8 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p8_PortCfgFuncID   0xf000
#define port_cfg_p8_funcprm_avrInv  0x0800
#define port_cfg_p8_funcprm_range   0x0700
#define port_cfg_p8_funcprm_nsamples    0x00e0
#define port_cfg_p8_funcprm_port    0x001f
#define port_cfg_p8_DESIGNVALUE     0x0000

/// 0x2e r/w port_cfg_p9 PIXI port P9 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p9_PortCfgFuncID   0xf000
#define port_cfg_p9_funcprm_avrInv  0x0800
#define port_cfg_p9_funcprm_range   0x0700
#define port_cfg_p9_funcprm_nsamples    0x00e0
#define port_cfg_p9_funcprm_port    0x001f
#define port_cfg_p9_DESIGNVALUE     0x5100

/// 0x2f r/w port_cfg_p10 PIXI port P10 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p10_PortCfgFuncID  0xf000
#define port_cfg_p10_funcprm_avrInv     0x0800
#define port_cfg_p10_funcprm_range  0x0700
#define port_cfg_p10_funcprm_nsamples   0x00e0
#define port_cfg_p10_funcprm_port   0x001f
#define port_cfg_p10_DESIGNVALUE    0x5100

/// 0x30 r/w port_cfg_p11 PIXI port P11 configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define port_cfg_p11_PortCfgFuncID  0xf000
#define port_cfg_p11_funcprm_avrInv     0x0800
#define port_cfg_p11_funcprm_range  0x0700
#define port_cfg_p11_funcprm_nsamples   0x00e0
#define port_cfg_p11_funcprm_port   0x001f
#define port_cfg_p11_DESIGNVALUE    0x5200

/// 0x31 r/w reserved_31 (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_31_PortCfgFuncID   0xf000
#define reserved_31_funcprm_avrInv  0x0800
#define reserved_31_funcprm_range   0x0700
#define reserved_31_funcprm_nsamples    0x00e0
#define reserved_31_funcprm_port    0x001f
#define reserved_31_DESIGNVALUE     0x0000

/// 0x32 r/w reserved_32 (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_32_PortCfgFuncID   0xf000
#define reserved_32_funcprm_avrInv  0x0800
#define reserved_32_funcprm_range   0x0700
#define reserved_32_funcprm_nsamples    0x00e0
#define reserved_32_funcprm_port    0x001f
#define reserved_32_DESIGNVALUE     0x0000

/// 0x33 r/w reserved_33 (reserved) configuration register
/// <code>1111xxxxxxxxxxxx</code> PortCfgFuncID Port function / mode
/// <code>xxxx1xxxxxxxxxxx</code> funcprm_avrInv AVR / INV
/// <code>xxxxx111xxxxxxxx</code> funcprm_range DAC Range / ADC Range
/// <code>xxxxxxxx111xxxxx</code> funcprm_nsamples Number of samples / CAP
/// <code>xxxxxxxxxxx11111</code> funcprm_port Associated port 0..31
#define reserved_33_PortCfgFuncID   0xf000
#define reserved_33_funcprm_avrInv  0x0800
#define reserved_33_funcprm_range   0x0700
#define reserved_33_funcprm_nsamples    0x00e0
#define reserved_33_funcprm_port    0x001f
#define reserved_33_DESIGNVALUE     0x0000

/// 0x40 r/o reserved_40 (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_40_adccode     0x0fff

/// 0x41 r/o reserved_41 (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_41_adccode     0x0fff

/// 0x42 r/o adc_data_port_p0 PIXI port P0 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p0_adccode    0x0fff

/// 0x43 r/o adc_data_port_p1 PIXI port P1 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p1_adccode    0x0fff

/// 0x44 r/o adc_data_port_p2 PIXI port P2 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p2_adccode    0x0fff

/// 0x45 r/o adc_data_port_p3 PIXI port P3 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p3_adccode    0x0fff

/// 0x46 r/o adc_data_port_p4 PIXI port P4 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p4_adccode    0x0fff

/// 0x47 r/o adc_data_port_p5 PIXI port P5 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p5_adccode    0x0fff

/// 0x48 r/o reserved_48 (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_48_adccode     0x0fff

/// 0x49 r/o reserved_49 (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_49_adccode     0x0fff

/// 0x4a r/o reserved_4A (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_4A_adccode     0x0fff

/// 0x4b r/o adc_data_port_p6 PIXI port P6 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p6_adccode    0x0fff

/// 0x4c r/o adc_data_port_p7 PIXI port P7 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p7_adccode    0x0fff

/// 0x4d r/o adc_data_port_p8 PIXI port P8 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p8_adccode    0x0fff

/// 0x4e r/o adc_data_port_p9 PIXI port P9 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p9_adccode    0x0fff

/// 0x4f r/o adc_data_port_p10 PIXI port P10 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p10_adccode   0x0fff

/// 0x50 r/o adc_data_port_p11 PIXI port P11 Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define adc_data_port_p11_adccode   0x0fff

/// 0x51 r/o reserved_51 (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_51_adccode     0x0fff

/// 0x52 r/o reserved_52 (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_52_adccode     0x0fff

/// 0x53 r/o reserved_53 (reserved) Analog to Digital Converter register
/// <code>xxxx111111111111</code> adccode 12-bit ADC code
#define reserved_53_adccode     0x0fff

/// 0x60 r/w reserved_60 (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_60_daccode     0x0fff
#define reserved_60_DESIGNVALUE     0x0000

/// 0x61 r/w reserved_61 (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_61_daccode     0x0fff
#define reserved_61_DESIGNVALUE     0x0000

/// 0x62 r/w dac_data_port_p0 PIXI port P0 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p0_daccode    0x0fff
#define dac_data_port_p0_DESIGNVALUE    0x0000

/// 0x63 r/w dac_data_port_p1 PIXI port P1 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p1_daccode    0x0fff
#define dac_data_port_p1_DESIGNVALUE    0x0000

/// 0x64 r/w dac_data_port_p2 PIXI port P2 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p2_daccode    0x0fff
#define dac_data_port_p2_DESIGNVALUE    0x0000

/// 0x65 r/w dac_data_port_p3 PIXI port P3 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p3_daccode    0x0fff
#define dac_data_port_p3_DESIGNVALUE    0x0000

/// 0x66 r/w dac_data_port_p4 PIXI port P4 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p4_daccode    0x0fff
#define dac_data_port_p4_DESIGNVALUE    0x0000

/// 0x67 r/w dac_data_port_p5 PIXI port P5 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p5_daccode    0x0fff
#define dac_data_port_p5_DESIGNVALUE    0x0000

/// 0x68 r/w reserved_68 (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_68_daccode     0x0fff
#define reserved_68_DESIGNVALUE     0x0000

/// 0x69 r/w reserved_69 (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_69_daccode     0x0fff
#define reserved_69_DESIGNVALUE     0x0000

/// 0x6a r/w reserved_6A (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_6A_daccode     0x0fff
#define reserved_6A_DESIGNVALUE     0x0000

/// 0x6b r/w dac_data_port_p6 PIXI port P6 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p6_daccode    0x0fff
#define dac_data_port_p6_DESIGNVALUE    0x0000

/// 0x6c r/w dac_data_port_p7 PIXI port P7 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p7_daccode    0x0fff
#define dac_data_port_p7_DESIGNVALUE    0x0000

/// 0x6d r/w dac_data_port_p8 PIXI port P8 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p8_daccode    0x0fff
#define dac_data_port_p8_DESIGNVALUE    0x0000

/// 0x6e r/w dac_data_port_p9 PIXI port P9 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p9_daccode    0x0fff
#define dac_data_port_p9_DESIGNVALUE    0x0000

/// 0x6f r/w dac_data_port_p10 PIXI port P10 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p10_daccode   0x0fff
#define dac_data_port_p10_DESIGNVALUE   0x0fff

/// 0x70 r/w dac_data_port_p11 PIXI port P11 Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define dac_data_port_p11_daccode   0x0fff
#define dac_data_port_p11_DESIGNVALUE   0x019a

/// 0x71 r/w reserved_71 (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_71_daccode     0x0fff
#define reserved_71_DESIGNVALUE     0x0000

/// 0x72 r/w reserved_72 (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_72_daccode     0x0fff
#define reserved_72_DESIGNVALUE     0x0000

/// 0x73 r/w reserved_73 (reserved) Digital to Analog Converter register
/// <code>xxxx111111111111</code> daccode 12-bit DAC code
#define reserved_73_daccode     0x0fff
#define reserved_73_DESIGNVALUE     0x0000

/// Initialize registers in sequence recommended by PIXI Port Configuration Flow Chart.
/// Requires user-provided function MAX11300regWrite(regAddress8, regData16)
uint16_t MAX11300regWrite(uint8_t regAddress8, uint16_t regData16);
uint16_t MAX11300regRead(uint8_t regAddress8);
/// Requires user-provided function MAX11300initDelayus(delay_us)
void MAX11300initDelayus(uint8_t delay_us);
///
/// PIXI ports to configure as Mode 0 HighImpedance:
///    portIndex 0 PIXI port --- N.C.
///    portIndex 1 PIXI port --- N.C.
///    portIndex 3 PIXI port P1 Differential in- for measuring the source voltage
///    portIndex 8 PIXI port --- N.C.
///    portIndex 9 PIXI port --- N.C.
///    portIndex 10 PIXI port --- N.C.
///    portIndex 12 PIXI port P7 Not used
///    portIndex 13 PIXI port P8 Not used
///    portIndex 17 PIXI port --- N.C.
///    portIndex 18 PIXI port --- N.C.
///    portIndex 19 PIXI port --- N.C.
/// PIXI ports to configure as Mode 1 GPIOinPgmThreshold:
///    none
/// PIXI ports to configure as Mode 2 GPIOinOutBidirLevelTrans:
///    none
/// PIXI ports to configure as Mode 3 GPIOoutRegDrivenOutputDAClevel:
///    none
/// PIXI ports to configure as Mode 4 GPIOoutUnidirOutputDAClevel:
///    none
/// PIXI ports to configure as Mode 5 DACout:
///    portIndex 5 PIXI port P3 DAC for setting the low current
///    portIndex 7 PIXI port P5 DAC for setting the high current
///    portIndex 14 PIXI port P9 Clamp for lower limit curve
///    portIndex 15 PIXI port P10 Clamp for higher limit curve
///    portIndex 16 PIXI port P11 DAC for driving ramp generator
/// PIXI ports to configure as Mode 6 DACoutWithADCmonitor:
///    none
/// PIXI ports to configure as Mode 7 ADCinPosSingleEnded:
///    portIndex 2 PIXI port P0 Differential in+ for measuring the source voltage
///    portIndex 4 PIXI port P2 ADC for measuring the low current
///    portIndex 6 PIXI port P4 Input for dynamic current control
///    portIndex 11 PIXI port P6 ADC for measuring the low current
/// PIXI ports to configure as Mode 8 ADCinPosDifferential:
///    none
/// PIXI ports to configure as Mode 9 ADCinNegDifferential:
///    none
/// PIXI ports to configure as Mode 10 DACoutADCinNegDifferential:
///    none
/// PIXI ports to configure as Mode 11 GPIOBidirAnalogSwitchExtControlled:
///    none
/// PIXI ports to configure as Mode 12 GPIOBidirAnalogSwitch:
///    none
/// PIXI ports to configure as Mode 13 Reserved13:
///    none
/// PIXI ports to configure as Mode 14 Reserved14:
///    none
/// PIXI ports to configure as Mode 15 Reserved15:
///    none
///
inline void MAX11311init()
{
  // SPI.begin();   
  // extern bool MAX11311regWrite(int regAddress8, int regData16);
  // extern void MAX11311initDelayus(int delay_us);

   // ------------------------------------------------------
   // Soft Reset device registers by device_control 8000_RESET
   // ------------------------------------------------------
   MAX11300regWrite(device_control, 0x8000); // 1xxx xxxx xxxx xxxx RESET Soft reset command

   // ------------------------------------------------------
   // FLOWCHART: "Configure device_control 4000_BRST, 0080_THSHDN, 0030_ADCCONV"
   // ------------------------------------------------------
   MAX11300regWrite(device_control, (device_control_DESIGNVALUE & 0x40B0));

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?"
   // ------------------------------------------------------
   // PIXI ports to configure as Mode 1 GPIOinPgmThreshold:
   //    none
   // PIXI ports to configure as Mode 3 GPIOoutRegDrivenOutputDAClevel:
   //    none
   // PIXI ports to configure as Mode 4 GPIOoutUnidirOutputDAClevel:
   //    none
   // PIXI ports to configure as Mode 5 DACout:
   //    portIndex 5 PIXI port P3 DAC for setting the low current
   //    portIndex 7 PIXI port P5 DAC for setting the high current
   //    portIndex 14 PIXI port P9 Clamp for lower limit curve
   //    portIndex 15 PIXI port P10 Clamp for higher limit curve
   //    portIndex 16 PIXI port P11 DAC for driving ramp generator
   // PIXI ports to configure as Mode 6 DACoutWithADCmonitor:
   //    none
   // PIXI ports to configure as Mode 10 DACoutADCinNegDifferential:
   //    none
   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Configure device_control 0040_DACREF, 000C_DACCTL"
   // ------------------------------------------------------
   MAX11300regWrite(device_control, (device_control_DESIGNVALUE & 0x40FC));

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 200us"
   // ------------------------------------------------------
   MAX11300initDelayus(200);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure DACDAT[i] for ports in mode 5 DACout:
   //    portIndex 5 PIXI port P3 DAC for setting the low current
   // ------------------------------------------------------
   MAX11300regWrite(dac_data_port_p3, dac_data_port_p3_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure DACDAT[i] for ports in mode 5 DACout:
   //    portIndex 7 PIXI port P5 DAC for setting the high current
   // ------------------------------------------------------
   MAX11300regWrite(dac_data_port_p5, dac_data_port_p5_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure DACDAT[i] for ports in mode 5 DACout:
   //    portIndex 14 PIXI port P9 Clamp for lower limit curve
   // ------------------------------------------------------
   MAX11300regWrite(dac_data_port_p9, dac_data_port_p9_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure DACDAT[i] for ports in mode 5 DACout:
   //    portIndex 15 PIXI port P10 Clamp for higher limit curve
   // ------------------------------------------------------
   MAX11300regWrite(dac_data_port_p10, dac_data_port_p10_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure DACDAT[i] for ports in mode 5 DACout:
   //    portIndex 16 PIXI port P11 DAC for driving ramp generator
   // ------------------------------------------------------
   MAX11300regWrite(dac_data_port_p11, dac_data_port_p11_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);


   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Enter DACPRSTDAT1 or DACPRSTDAT2"
   // ------------------------------------------------------
   MAX11300regWrite(dac_preset_data_1, dac_preset_data_1_DESIGNVALUE);
   MAX11300regWrite(dac_preset_data_2, dac_preset_data_2_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 200us x number of ports in mode 1"
   // ------------------------------------------------------

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Configure GPODAT[i] for ports in mode 3"
   // ------------------------------------------------------

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 5 DACout:
   //    portIndex 5 PIXI port P3 DAC for setting the low current
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p3, port_cfg_p3_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 5 DACout:
   //    portIndex 7 PIXI port P5 DAC for setting the high current
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p5, port_cfg_p5_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 5 DACout:
   //    portIndex 14 PIXI port P9 Clamp for lower limit curve
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p9, port_cfg_p9_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 5 DACout:
   //    portIndex 15 PIXI port P10 Clamp for higher limit curve
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p10, port_cfg_p10_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 5 DACout:
   //    portIndex 16 PIXI port P11 DAC for driving ramp generator
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p11, port_cfg_p11_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Wait 1ms"
   // ------------------------------------------------------
   MAX11300initDelayus(1000);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 1, 3, 4, 5, 6, or 10 used?" branch "Y"
   // FLOWCHART: "Configure GPIMD[i] for ports in mode 1"
   // ------------------------------------------------------
   MAX11300regWrite(gpi_irqmode_P5_P0, gpi_irqmode_P5_P0_DESIGNVALUE);
   MAX11300regWrite(gpi_irqmode_P10_P6, gpi_irqmode_P10_P6_DESIGNVALUE);
   MAX11300regWrite(gpi_irqmode_P11, gpi_irqmode_P11_DESIGNVALUE);


   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?"
   // ------------------------------------------------------
   // PIXI ports to configure as Mode 7 ADCinPosSingleEnded:
   //    portIndex 2 PIXI port P0 Differential in+ for measuring the source voltage
   //    portIndex 4 PIXI port P2 ADC for measuring the low current
   //    portIndex 6 PIXI port P4 Input for dynamic current control
   //    portIndex 11 PIXI port P6 ADC for measuring the low current
   // PIXI ports to configure as Mode 8 ADCinPosDifferential:
   //    none
   // PIXI ports to configure as Mode 9 ADCinNegDifferential:
   //    none
   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 7 ADCinPosSingleEnded:
   //    portIndex 2 PIXI port P0 Differential in+ for measuring the source voltage
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p0, port_cfg_p0_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // FLOWCHART: "Wait 100us"
   // ------------------------------------------------------
   MAX11300initDelayus(100);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 7 ADCinPosSingleEnded:
   //    portIndex 4 PIXI port P2 ADC for measuring the low current
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p2, port_cfg_p2_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // FLOWCHART: "Wait 100us"
   // ------------------------------------------------------
   MAX11300initDelayus(100);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 7 ADCinPosSingleEnded:
   //    portIndex 6 PIXI port P4 Input for dynamic current control
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p4, port_cfg_p4_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // FLOWCHART: "Wait 100us"
   // ------------------------------------------------------
   MAX11300initDelayus(100);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // Configure FUNCID[i] FUNCPRM[i] for ports in mode 7 ADCinPosSingleEnded:
   //    portIndex 11 PIXI port P6 ADC for measuring the low current
   // ------------------------------------------------------
   MAX11300regWrite(port_cfg_p6, port_cfg_p6_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // FLOWCHART: "Wait 100us"
   // ------------------------------------------------------
   MAX11300initDelayus(100);

   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 7, 8, or 9 used?" branch "Y"
   // FLOWCHART: "Configure device_control 0003_ADCCTL"
   // ------------------------------------------------------
   MAX11300regWrite(device_control, (device_control_DESIGNVALUE & 0x40FF));


   // ------------------------------------------------------
   // FLOWCHART: decision "Is mode 2, 11, or 12 used?"
   // ------------------------------------------------------

   // ------------------------------------------------------
   // FLOWCHART: decision "Are temperature sensors used?"
   // ------------------------------------------------------
   // ------------------------------------------------------
   // FLOWCHART: decision "Are temperature sensors used?" branch "Y"
   // FLOWCHART: "Configure device_control 0800_TMPPER"
   // ------------------------------------------------------
   MAX11300regWrite(device_control, (device_control_DESIGNVALUE & 0x48FF));

   // ------------------------------------------------------
   // FLOWCHART: decision "Are temperature sensors used?" branch "Y"
   // FLOWCHART: "Configure device_control 1000_RS_CANCEL"
   // ------------------------------------------------------
   MAX11300regWrite(device_control, (device_control_DESIGNVALUE & 0x58FF));

   // ------------------------------------------------------
   // FLOWCHART: decision "Are temperature sensors used?" branch "Y"
   // FLOWCHART: "Configure tmp_mon_cfg"
   // ------------------------------------------------------
   MAX11300regWrite(tmp_mon_cfg, tmp_mon_cfg_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Are temperature sensors used?" branch "Y"
   // FLOWCHART: "Configure TMPHI and TMPLO alarm thresholds"
   // ------------------------------------------------------
   MAX11300regWrite(tmp_mon_int_hi_thresh, tmp_mon_int_hi_thresh_DESIGNVALUE);
   MAX11300regWrite(tmp_mon_int_lo_thresh, tmp_mon_int_lo_thresh_DESIGNVALUE);
   MAX11300regWrite(tmp_mon_ext1_hi_thresh, tmp_mon_ext1_hi_thresh_DESIGNVALUE);
   MAX11300regWrite(tmp_mon_ext1_lo_thresh, tmp_mon_ext1_lo_thresh_DESIGNVALUE);
   MAX11300regWrite(tmp_mon_ext2_hi_thresh, tmp_mon_ext2_hi_thresh_DESIGNVALUE);
   MAX11300regWrite(tmp_mon_ext2_lo_thresh, tmp_mon_ext2_lo_thresh_DESIGNVALUE);

   // ------------------------------------------------------
   // FLOWCHART: decision "Are temperature sensors used?" branch "Y"
   // FLOWCHART: "Configure device_control 0400_TMPCTL_EXT1, 0200_TMPCTL_EXT0, 0100_TMPCTL_INT"
   // ------------------------------------------------------
   MAX11300regWrite(device_control, (device_control_DESIGNVALUE & 0x5FFF));


   // ------------------------------------------------------
   // Configure final device_control design value 2000_LPEN
   // ------------------------------------------------------
   MAX11300regWrite(device_control, (device_control_DESIGNVALUE));

   // ------------------------------------------------------
   // FLOWCHART: Configure Interrupt Masks
   // ------------------------------------------------------
   MAX11300regWrite(interrupt_mask, interrupt_mask_DESIGNVALUE);


}


#endif /* _MAX11311_DESIGNVALUE_H_ */

// End of file
