#include"mbed.h"
//*****************************************************************************************************************************
//Setting the SPI configuration for PIXI,  SCLK = 10MHz (because VDVDD = 1.62 to 2.5V),  SPI mode 0 and MSB first tarnsactions 
//please refer to https://datasheets.maximintegrated.com/en/ds/MAX11311.pdf for further description

SPI spi(P5_1, P5_2, P5_0); // mosi, miso, sclk
DigitalOut cs(P5_3);

uint16_t MAX11300regWrite(uint8_t regAddress8, uint16_t regData16)
{
    uint8_t  Byte1;
    uint8_t  Byte2;
    uint8_t  Byte3;
    uint8_t  rightByte;
    uint8_t  leftByte;
    uint16_t Transferred_word;

    rightByte = regData16 & 0xFF;
    leftByte = (regData16 >> 8 ) & 0xFF;

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,0);
    spi.frequency(1000000);
 
    // Select the device by seting chip select low
    cs = 0;
    Byte1 = spi.write(regAddress8 << 1);
    Byte2 = spi.write(leftByte);
    Byte3 = spi.write(rightByte);
    //Transferred_word = ((leftByte << 8) | rightByte);
    Transferred_word = regData16;
   // Deselect the device
    cs = 1;
    return Transferred_word;
   
}

//**************************************************************************************************************************
//Delay function
void MAX11300initDelayus(uint8_t delay_us)
{
    wait_us(delay_us);
}

//**************************************************************************************************************************
//SPI Read function

uint16_t MAX11300regRead(uint8_t regAddress8)
{
    uint8_t  Byte1;
    uint8_t  Byte2;
    uint8_t  Byte3;
    uint16_t Received_word;

    // Setup the spi for 8 bit data, high steady state clock,
    // second edge capture, with a 1MHz clock rate
    spi.format(8,0);
    spi.frequency(1000000);
 
    // Select the device by seting chip select low
    cs = 0;
    Byte1 = spi.write((regAddress8 << 1) | 1);
    Byte2 = spi.write(0xAA);
    Byte3 = spi.write(0xAA);
    Received_word = ((Byte2 << 8) | Byte3);

//    uint16_t Shift_Size = sizeof(uint16_t)*8;
//    int np = 8;  // number of positions to shift
//    np = np%Shift_Size;
//    Received_word = Received_word>>np | Received_word << (Shift_Size-np);

    // Deselect the device
    cs = 1;
    return Received_word;
   
}