@echo off

setlocal

set TOOLSPATH=%~dp0

:: strip trailing backslash
set TOOLSPATH=%TOOLSPATH:~0,-1%

for %%d in (%TOOLSPATH%) do set PROJECTPATH=%%~dpd

:: strip trailing backslash
set PROJECTPATH=%PROJECTPATH:~0,-1%

for %%a in (%PROJECTPATH%) do set "PROJECTNAME=%%~nxa"

for /f "delims== tokens=1*" %%A in (.mbed) do (
	if %%A==TARGET (
		set TARGET=%%B
	) else if %%A==TOOLCHAIN (
		set TOOLCHAIN=%%B
	)
)

set BINARY=%PROJECTPATH%/BUILD/%TARGET%/%TOOLCHAIN%/%PROJECTNAME%.bin

if not exist %BINARY% (
	@echo Error: File "%BINARY%" does not exist!
	exit /b
) 

python %PROJECTPATH%/tools/mbed_run.py %BINARY%

endlocal
