/*
 * max113xx_pixi_app.cpp
 *
 *  Created on: Jun 20, 2018
 *      Author: Mahir.Ozturk
 */
#include <mbed.h>
#include "max113xx_pixi_app.h"
#include "MAX113XX_Pixi.h"
#include "MAX11301Hex.h"

#define MAX113XX_DATA_READ_PERIOD_MSEC	2000
#define MAX113XX_I2C_ADDRESS	0x38

void max11301_reader_task(struct max11301_reader_task_args *args)
{
	uint16_t adcData;
	float adcVoltage;

	MAX113XX_I2C pixi(args->i2cBus, MAX113XX_I2C::MAX11301, MAX113XX_I2C_ADDRESS, P5_5);

	pixi.dacWrite(MAX113XX_Pixi::PORT0, 0x000);    // Pixi PORT0 is -5V
	pixi.dacWrite(MAX113XX_Pixi::PORT1, 0xFFF);    // Pixi PORT1 is +5V

	printf("Starting MAX11301 PIXI ADC Demo Application...\r\n");

	while (1) {
		pixi.singleEndedADCRead(MAX113XX_Pixi::PORT9, adcData);    // Read value from PORT9
		adcVoltage = -5 + 2.442e-3  * adcData;                     // Convert ADC val. to a voltage

		printf("ADC Read is : %i,\tVoltage is %1.3f V \r\n", adcData, adcVoltage);

		bleGattAttrWrite(args->gatt, (uint8_t *)&adcVoltage, sizeof(adcVoltage));

		Thread::wait(args->notify_period_sec * 1000);
	}
}

