import sys
import mbed_lstools
import serial
from shutil import copy

bin_file=sys.argv[1]

mbeds = mbed_lstools.create()
m=mbeds.list_mbeds()

if len(m) == 0:
	print "No mbed device detected"
	sys.exit(1)

#print "Detected mbed devices: "
#print m

#Select first mbed device
target_mbed=m[0]
target_mount_point=target_mbed['mount_point']
target_platform_name=target_mbed['platform_name']
target_serial_port=target_mbed['serial_port']

print "Detected mbed device:"
if target_platform_name:
	print "  Platform name: " + target_platform_name
print "  Mount point:   " + target_mount_point
print "  Serial port:   " + target_serial_port


print "Copy " + bin_file + " -> " + target_mount_point
copy(bin_file, target_mount_point)

try:
	ser = serial.Serial(target_serial_port, 115200)
	ser.send_break()
	ser.close()
except Exception as e:
	#print e
	pass