/*
 * max30205_app.c
 *
 *  Created on: Jun 20, 2018
 *      Author: Mahir.Ozturk
 */
#include <mbed.h>
#include "max30205_app.h"
#include "MAX30205.h"

bool max30205_config(MAX30205 &temp_sensor){

	int rc = 0;

	MAX30205::Configuration_u temp_cfg;
	temp_cfg.all = 0;
	temp_cfg.bits.shutdown = 1;     // Shutdown mode
	temp_cfg.bits.comp_int = 1;     // Interrupt mode
	temp_cfg.bits.os_polarity = 0;  // Active low OS
	temp_cfg.bits.fault_queue = 1;  // Two faults for OS condition
	temp_cfg.bits.data_format = 0;  // Normal data format
	temp_cfg.bits.timeout = 0;      // I2C timeout reset enabled
	temp_cfg.bits.one_shot = 0;     // Start with one-shot = 0

	rc = temp_sensor.writeConfiguration(temp_cfg);  // Write config to MAX30205

	return rc;
}

void max30205_reader_task(struct max30205_reader_task_args *args)
{
	MAX30205 max30205_temp_sensor(args->i2cBus, 0x48);	/* New MAX30205 on i2cBus */

	int rc = max30205_config(max30205_temp_sensor);   // Configure sensor, return 0 on success

	MAX30205::Configuration_u temp_cfg;
	uint16_t rawTemperatureRead;
	float temperature;

	temp_cfg.all = 0;

	printf("Starting MAX30205 Temperature Demo Application...\r\n");

	while (1) {
		if (rc == 0) {
			/* Send one-shot cmd to begin conversion */
			temp_cfg.bits.one_shot = 1;
			rc = max30205_temp_sensor.writeConfiguration(temp_cfg);

			Thread::wait(50);

			/* Read the temperature data */
			rc = max30205_temp_sensor.readTemperature(rawTemperatureRead);

			/* Convert temp data to Celsius */
			temperature = max30205_temp_sensor.toCelsius(rawTemperatureRead);

			bleGattAttrWrite(args->gatt, (uint8_t *)&temperature, sizeof(temperature));
			printf("Temperature is %2.3f deg. C\r\n", temperature);

			Thread::wait(args->notify_period_sec * 1000);

		} else {
			printf("Something went wrong, check the I2C bus and power connections...\r\n");

			return;
		}
	}
}


