/*******************************************************************************
 * Copyright (C) 2014 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated 
 * Products, Inc. shall not be used except as stated in the Maxim Integrated 
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all 
 * ownership rights.
 *******************************************************************************
 */

#include <stdio.h>
#include "LED.h"

#define PERIOD_MS   1 // 1kHz

//******************************************************************************
LED::LED(PinName pin) :
    pwm_(pin)
{
    pwm_.period_ms(PERIOD_MS);
    off();
    duty_ = 0.5;
}

//******************************************************************************
LED::LED(PinName pin, float duty) :
    pwm_(pin),
    duty_(1 - duty)
{
    pwm_.period_ms(PERIOD_MS);
    off();
    state_ = 0;
}

//******************************************************************************
void LED::on(void)
{
    pwm_.write(duty_);
    state_ = 1;
}

//******************************************************************************
void LED::off(void)
{
    pwm_.pulsewidth_ms(PERIOD_MS);
    state_ = 0;
}

//******************************************************************************
void LED::toggle(void)
{
    if (state_) {
        off();
    } else {
        on();
    }
}

//******************************************************************************
void LED::write(int value)
{
    if (value) {
        on();
    } else {
        off();
    }
}

//******************************************************************************
int LED::read(void)
{
    return state_;
}