/*******************************************************************************
 * Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */

#ifndef __BLE_LOCALTIMEINFOCHAR_H__
#define __BLE_LOCALTIMEINFOCHAR_H__

#include "mbed.h"
#include "Characteristic.h"

/**
 * @class   LocalTimeInfoChar
 * @brief   LocalTimeInfoChar characteristic class.
 * @details Sub class from the characteristic class.
 */

class LocalTimeInfoChar : public Characteristic
{
public:

    typedef enum {
        UTC_N_1200  = -48,
        UTC_N_1100  = -44,
        UTC_N_1000  = -40,
        UTC_N_0930  = -38,
        UTC_N_0900  = -36,
        UTC_N_0800  = -32,
        UTC_N_0700  = -28,
        UTC_N_0600  = -24,
        UTC_N_0500  = -20,
        UTC_N_0430  = -18,
        UTC_N_0400  = -16,
        UTC_N_0330  = -14,
        UTC_N_0300  = -12,
        UTC_N_0200  = -8,
        UTC_N_0100  = -4,
        UTC_P_0000  = 0,
        UTC_P_0100  = 4,
        UTC_P_0200  = 8,
        UTC_P_0300  = 12,
        UTC_P_0330  = 14,
        UTC_P_0400  = 16,
        UTC_P_0430  = 18,
        UTC_P_0500  = 20,
        UTC_P_0530  = 22,
        UTC_P_0545  = 23,
        UTC_P_0600  = 24,
        UTC_P_0630  = 26,
        UTC_P_0700  = 28,
        UTC_P_0800  = 32,
        UTC_P_0845  = 35,
        UTC_P_0900  = 36,
        UTC_P_0930  = 38,
        UTC_P_1000  = 40,
        UTC_P_1030  = 42,
        UTC_P_1100  = 44,
        UTC_P_1130  = 46,
        UTC_P_1200  = 48,
        UTC_P_1245  = 51,
        UTC_P_1300  = 52,
        UTC_P_1400  = 56
    } time_zone_t;

    typedef enum {
        standard        = 0,
        half_daylight   = 2,
        hour_daylignt   = 4,
        double_daylight = 8,
    } dst_offset_t;

    static const unsigned OFFSET_OF_TIMEZONE = 0;
    static const unsigned OFFSET_OF_DST = OFFSET_OF_TIMEZONE + 1;

    static const unsigned CHAR_BYTES = OFFSET_OF_DST + 1;

    LocalTimeInfoChar() : 
        gattChar(GattCharacteristic::UUID_LOCAL_TIME_INFORMATION_CHAR, bytes, 
            CHAR_BYTES, CHAR_BYTES,  
            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ | 
            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE)
    {
        // Default UTC time with no DST offset
        memset(bytes, 0x0, CHAR_BYTES);
    }

    ~LocalTimeInfoChar() {}

    virtual GattCharacteristic *getChar(void)
    {
        return &gattChar;
    }

    virtual uint8_t getNumBytes(void)
    {
        return CHAR_BYTES;
    }

    virtual uint8_t *getBytes(void)
    {
        return bytes;
    }

    // Update the characteristic value for dst
    void update(dst_offset_t dst)
    {
        // Set DST
        bytes[OFFSET_OF_DST] = dst;
    }

    // Update the characteristic value for time zone
    void update(time_zone_t time_zone)
    {
        // Set DST
        bytes[OFFSET_OF_TIMEZONE] = time_zone;
    }

private:
    GattCharacteristic      gattChar;
    uint8_t                 bytes[CHAR_BYTES];
};

#endif /* #ifndef __BLE_LOCALTIMEINFOCHAR_H__*/
