/*******************************************************************************
 * Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */

#include <stdint.h>
#include <string.h>
#include "cmsis.h"
#include "clkman_regs.h"
#include "tpu_regs.h"
#include "flc_regs.h"

#define BTLE_ADDR_ADDRESS       (MXC_FLASH_MEM_BASE + MXC_FLASH_MEM_SIZE - 8)
#define FLC_CTRL_UNLOCK_VALUE   0x20000000UL

static void getRandAddress(uint32_t address[2])
{
    uint32_t clk_config_save = MXC_CLKMAN->clk_config;
    uint32_t clk_ctrl_10_prng_save = MXC_CLKMAN->clk_ctrl_10_prng;
    uint32_t crypt_clk_ctrl_2_prng_save = MXC_CLKMAN->crypt_clk_ctrl_2_prng;
    uint32_t clk_ctrl_save = MXC_CLKMAN->clk_ctrl;
    uint16_t *ptr = (uint16_t*)address;

    // Enable the crypto RO if necessary
    if (!(MXC_CLKMAN->clk_config & MXC_F_CLKMAN_CLK_CONFIG_CRYPTO_ENABLE)) {
        uint32_t temp = MXC_CLKMAN->clk_config;
        temp &= ~MXC_F_CLKMAN_CLK_CONFIG_CRYPTO_STABILITY_COUNT;
        temp |= (MXC_F_CLKMAN_CLK_CONFIG_CRYPTO_RESET_N |
                 MXC_F_CLKMAN_CLK_CONFIG_CRYPTO_ENABLE |
                (MXC_E_CLKMAN_STABILITY_COUNT_2_8_CLKS << MXC_F_CLKMAN_CLK_CONFIG_CRYPTO_STABILITY_COUNT_POS));
        MXC_CLKMAN->clk_config = temp;
    }

    // Un-gate crypto RO if necessary
    if (!(MXC_CLKMAN->clk_ctrl & MXC_F_CLKMAN_CLK_CTRL_CRYPTO_GATE_N)) {
        MXC_CLKMAN->clk_ctrl |= MXC_F_CLKMAN_CLK_CTRL_CRYPTO_GATE_N;
    }

    // Enable clock if necessary
    if (MXC_CLKMAN->clk_ctrl_10_prng == MXC_E_CLKMAN_CLK_SCALE_DISABLED) {
        MXC_CLKMAN->clk_ctrl_10_prng = MXC_E_CLKMAN_CLK_SCALE_ENABLED;
    }

    // Enable clock if necessary
    if (MXC_CLKMAN->crypt_clk_ctrl_2_prng == MXC_E_CLKMAN_CLK_SCALE_DISABLED) {
        MXC_CLKMAN->crypt_clk_ctrl_2_prng = MXC_E_CLKMAN_CLK_SCALE_ENABLED;
    }

    ptr[0] = MXC_TPU->prng_rnd_num;
    ptr[1] = MXC_TPU->prng_rnd_num;
    ptr[2] = MXC_TPU->prng_rnd_num;
    ptr[3] = MXC_TPU->prng_rnd_num;

    // Restore clock settings
    MXC_CLKMAN->crypt_clk_ctrl_2_prng = crypt_clk_ctrl_2_prng_save;
    MXC_CLKMAN->clk_ctrl_10_prng = clk_ctrl_10_prng_save;
    MXC_CLKMAN->clk_ctrl = clk_ctrl_save;
    MXC_CLKMAN->clk_config = clk_config_save;
}

void getBtleAddress(uint8_t *bdAddr)
{
    uint32_t *ptr;
    uint32_t flash_value[2];

    ptr = (uint32_t*)BTLE_ADDR_ADDRESS;

    // Check if there is already an address written to flash
    if ((ptr[0] == 0xFFFFFFFF) && (ptr[1] == 0xFFFFFFFF)) {

        // Get a random numbers for the address
        getRandAddress(flash_value);

        // Set bits to indicate random static address
        flash_value[1] |= 0xFFFFC000;

        // Write the number to flash
        MXC_FLC->ctrl = (MXC_FLC->ctrl & ~MXC_F_FLC_CTRL_FLSH_UNLOCK) | FLC_CTRL_UNLOCK_VALUE;

        MXC_FLC->faddr = BTLE_ADDR_ADDRESS;
        MXC_FLC->fdata = flash_value[0];
        MXC_FLC->ctrl |= MXC_F_FLC_CTRL_WRITE;
        while (MXC_FLC->ctrl & MXC_F_FLC_CTRL_PENDING);

        MXC_FLC->faddr = BTLE_ADDR_ADDRESS + 4;
        MXC_FLC->fdata = flash_value[1];
        MXC_FLC->ctrl |= MXC_F_FLC_CTRL_WRITE;
        while (MXC_FLC->ctrl & MXC_F_FLC_CTRL_PENDING);

        MXC_FLC->ctrl &= ~MXC_F_FLC_CTRL_FLSH_UNLOCK;
    }

    memcpy(bdAddr, (uint32_t*)BTLE_ADDR_ADDRESS, 6);
}
