/*******************************************************************************
 * Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */

#ifndef __BLE_CHARACTERISTIC_H__
#define __BLE_CHARACTERISTIC_H__

#include "mbed.h"
#include "BLE.h"

/**
 * @class   Characteristic
 * @brief   Abstract characteristic class.
 * @details Implement sub class derived from this for custom characteristic.
 */
class Characteristic
{
public:

    static const unsigned TIMESTAMP_BYTES = 7;

    virtual GattCharacteristic *getChar(void) = 0;
    virtual uint8_t getNumBytes(void) = 0;
    virtual uint8_t *getBytes(void) = 0;

protected:

    // Convert time_t to the timestamp format
    static void date_time(time_t time, uint8_t *buf) {
        // Convert time_t to Year, Month, Day, Hour, Minute, Second
        struct tm ts = *localtime(&time);

        buf[1] = ((ts.tm_year+1900) & 0xFF00) >> 8;
        buf[0] = (ts.tm_year+1900) & 0xFF;

        buf[2] = (ts.tm_mon + 1) & 0xFF;
        buf[3] = ts.tm_mday & 0xFF;
        buf[4] = ts.tm_hour & 0xFF;
        buf[5] = ts.tm_min & 0xFF;
        buf[6] = ts.tm_sec & 0xFF;
    }

    // Convert floating point numbers to IEEE-11073 32-bit float
    static uint32_t float_bytes(float _float, uint8_t exp) {
        // Calculate how much to adjust mantissa
        uint8_t exponent = 0xFF - exp + 1;
        while(exp > 0) {
            _float *=10;
            exp--;
        }
        uint32_t mantissa = (uint32_t)(_float);
        return (((uint32_t)exponent) << 24) | mantissa;
    }
};

#endif /* #ifndef __BLE_CHARACTERISTIC_H__*/
