/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/
//==============================================================================
//This code is only suitable for single switch press not simultaneous switch press
//The following code needs maxim-dev library to run. The complete package is available in the GITHUB
//==============================================================================
//Header files
#include "mbed.h"
#include "USBSerial.h"
#include "max32625pico.h"
#include "SerialInterface.h"


const int Slave_address                   = 0x70; // MAX7360 I2C slave address
const int max_key                         = 63;

// Virtual serial port over USB
USBSerial microUSB(0x0B6A, 0x4360);

DigitalIn nINTK(P4_5); // Key switch interrupt configures as GPIO, refer to page 11 of DS for more info

//The following line of code is optional and please uncomment if you are using rotary encoder
//DigitalIn nINTI(P4_4); // Interrupt for rotary switch configuration, refer to page 14 for more info

//The following line of code sets all the GPIO to 1.8 volts
MAX32625PICO pico(MAX32625PICO::IOH_DIP_IN, MAX32625PICO::VIO_IOH, MAX32625PICO::VIO_1V8);

// Serial Interfaces
I2C i2c(P1_6, P1_7);



int main()
{


//--------Register configuration for the MAX7360--------------------------------
//Please refer to page 10 and table 8 of the data sheet

//Writing the configuration register (0x01) of MAX7360.


    char Datawrite_config[2];
    Datawrite_config[0]   = 0x01; //Address of the register
    Datawrite_config[1]   = 0x20; //Configuring the register for Interrupt by making D5 to 1 and all the other bits to 0
    i2c.write( Slave_address, Datawrite_config, 2 );

//Writing the Key switch interrupt register (0x03) MAX7360.
//Please refer to table 10 of the data sheet
//The interrupt register contains information related to the
//settings of the interrupt request function, as well as the
//status of the INTK output, which can also be configured
//as a GPIO
    char Datawrite_Key_Switch_Interrupt[2];
    Datawrite_Key_Switch_Interrupt[0]   = 0x03; //Address of the register
    Datawrite_Key_Switch_Interrupt[1]   = 0x08; //Configuring the TIME-BASED INTK bits to get 8 debounce cycles
    i2c.write( Slave_address, Datawrite_Key_Switch_Interrupt, 2 );


//Writing the auto sleep register (0x06)MAX7360 Autosleep Register no autosleep
    char Autosleep[2];
    Autosleep[0]   = 0x06; //Address of the register
    Autosleep[1]   = 0x00; //AUTOSHUTDOWN TIME to no autosleep, refer to page 25 of DS
    i2c.write( Slave_address, Autosleep, 2 );


//Writing the GPIO Global Configuration (0x40)
//Enable rotary encoder and normal GPIO operation
    char GlobalConfig[2];
    GlobalConfig[0]   = 0x40; //Address of the register
    GlobalConfig[1]   = 0x90; //Enabling the I2C timeout interrupt and rotary switch by setting D7 and D5 to 1 and all others to zero
    i2c.write( Slave_address, GlobalConfig, 2 );

//==============================================================================
//Uncomment below if you would like ot use rotary encoder
//==============================================================================
//Writing GPIO Control Register
//    char GPIOControl[2];
//    GPIOControl[0]   = 0x41; //Address
//    GPIOControl[1]   = 0x3F; //Registrer configuration, All GPIOs configured as output, except ports 6 and 7, because they are connected to the rotary encoder
//   i2c.write( Slave_address, GPIOControl, 2 );
//Writing the Rotatory switch configuration (0x46).  Please refer to table 20 of the data sheet
//    char Datawrite_Rotatory_Switch_configuration[2];
//Rotary Switch Configuration Register   nINTI asserted 25ms after first debounced event, no debounce cycle time
//   Datawrite_Rotatory_Switch_configuration[0]   = 0x46;
//   Datawrite_Rotatory_Switch_configuration[1]   = 0x90;  // Rotary Switch Configuration Register   nINTI asserted 25ms after first debounced event, no debounce cycle time
//Datawrite_Rotatory_Switch_configuration[1]   = 0x11;
//   i2c.write( Slave_address, Datawrite_Rotatory_Switch_configuration, 2 );

    /*
    // Writing PORT6 Configuration Register   mask interrupt  (0x5E)
        char Port6[2];
        Port6[0]   = 0x5E; // Address
        Port6[1]   = 0x80;// masking the interrupt by enabling the D7 to 1  refer to page 30 of DS
        i2c.write( Slave_address, Port6, 2 );

    // Writing PORT7 Configuration Register   mask interrupt  (0x5F)
        char Port7[2];
        Port7[0]   = 0x5F; //Address
        Port7[1]   = 0x80; // masking of the interrupt by making D7 to 1 refer to page 30 of DS
        i2c.write( Slave_address, Port7, 2 );
    */
//-----------------------------------------------------------------------------
//Default register values
//-----------------------------------------------------------------------------
//writeMAX7360(0x02,0xFF);// Debounce Register only column 0 enabled, debounce set to 40ms
//  writeMAX7360(0x04,0xFE);          // Ports Register
//  writeMAX7360(0x05,0x00);            // Autorepeat Register
//  writeMAX7360(0x42,0x00);            // GPIO Debounce Configuration Register
//  writeMAX7360(0x43,0xC0);            // GPIO Constant-Current Setting Register
//  writeMAX7360(0x44,0x00);            // GPIO Output Mode Register
//  writeMAX7360(0x45,0x00);            // Common PWM Register

//------------------End of Register configuration for MAX7360-----------------//


    while(1) {



//Reading the Key FIFO register (0x00) from MAX7360.
//Please refer to page 10 and table 7 of the data sheet
        char KeyFIFOData;
        char l = 0x00;
        i2c.write( Slave_address, &l, 1 );
        i2c.read( Slave_address, &KeyFIFOData, 1 );


        if(KeyFIFOData!= max_key) {
            microUSB.printf("KeyFIFOData = %d \n\r", KeyFIFOData);
        }

        //      wait_ms(50);  This may be necessary for console printing

//==============================================================================
//Uncomment the code below for rotary encoder
//==============================================================================
////Reading the Rotatory switch count register (0x4A).  Please refer to page 12 and table 23 of the data sheet
//
//               char RotaryData;
//               char m = 0x4A;
//               if(!nINTI) {
//                   i2c.write( Slave_address, &m, 1 );
//                   i2c.read( Slave_address, &RotaryData, 1 );
//
//                   if(RotaryData!= 0) {
//
//                       microUSB.printf("RotaryData = %x \r\n", RotaryData);
//                   }
//
//        //         wait_ms(100); This may be necessary for console printing
//
//                 }

    }
}









