#ifndef _BLE_ICARUS_H_
#define _BLE_ICARUS_H_


#include "mbed.h"
#include "ble/BLE.h"
#include "DSInterface.h"







enum BLE_State {
	BLE_DOWN,
	BLE_STARTING,
	BLE_ADVERTISING,
	BLE_CONNECTED,
	BLE_DISCONNECTED,
};

extern volatile BLE_State bleState;

/**
 * Callback triggered when the ble initialization process has finished
 */
void bleInitComplete(BLE::InitializationCompleteCallbackContext *params);

int BLE_Icarus_TransferData(uint8_t data_transfer[20]);

int BLE_Icarus_AddtoQueue(uint8_t *data_transfer, int32_t buf_size, int32_t data_size);

int BLE_Icarus_SetDSInterface(DSInterface *comm_obj);

int BLE_Icarus_TransferDataFromQueue();

bool BLE_Icarus_Interface_Exists();

int BLE_ICARUS_Get_Mac_Address(char MacAdress[6]);

























#endif
