/**********************************************************************
* Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
#include "max77756.h"

int main()
{
    uint32_t rData;
    uint32_t outVoltage = 1500;
    
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    
    I2C i2cBus(P5_7, P6_0);
    i2cBus.frequency(400000);
    MAX77756 max77756(&i2cBus);
    
    wait_ms(100);    
    
    max77756.config(MAX77756::S_SPECTRUM_OFF, MAX77756::S_START_8_ms, 
                    MAX77756::I_PEAK_LIMIT_700_mA, MAX77756::EN_LOGICAL_OR);
    
    while(1) {
       
        rData = max77756.outEnable(MAX77756::DISABLE);
        if (rData < 0) {
            rLED = 1;
            continue;
        }
        wait_ms(1000);
        
        rData = max77756.setVout(outVoltage);
        if (rData < 0) {
            rLED = 1;
            continue;
        }
        rData = max77756.outEnable(MAX77756::ENABLE);
        if (rData < 0) {
            rLED = 1;
            continue;
        }
        
        outVoltage += 50;
        if (outVoltage > 7500) {
            outVoltage = 1500;
        }
           
        gLED = !gLED;
        wait_ms(1000);
    }
}

