/*******************************************************************************
 * Copyright(C) Analog Devices Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files(the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Analog Devices Inc.
 * shall not be used except as stated in the Analog Devices Inc.
 * Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Analog Devices Inc.retains all ownership rights.
 *******************************************************************************
 */

#ifndef MAX77655_REGS_H_
#define MAX77655_REGS_H_

/**
 * @brief CNFG_GLBL_A Register
 *
 * Address : 0x00
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char dben_nen  : 1;    /**< Debounce Timer Enable for the nEN Pin. Bit 0.
                                            0x0: 100μs Debounce
                                            0x1: 30ms Debounce */
        unsigned char nen_mode  : 2;    /**< nEN Input (ON-KEY) Default Configuration Mode. Bit 2:1.
                                            0b00 = Push-button mode 
										    0b01 = Slide-switch mode 
											0b10 = Logic mode 
											0b11 = Reserved */
        unsigned char mrt       : 1;    /**< Manual Reset Time Configuration. Bit 3.
                                            0x0: Manual Reset Time is 16s.
                                            0x1: Manual Reset Time is 8s. */
        unsigned char bias_lpm  : 1;    /**< Main Bias Low-Power Mode Software Request. Bit 4.
                                             0 = Main Bias requested to be in Normal-Power Mode by software. 
                                             1 = Main Bias request to be in Low-Power Mode by software. */
        unsigned char pu_dis    : 1;    /**< nEN Internal Pullup Resistor. Bit 5.
                                             0 = Strong internal nEN pullup (200kΩ) 
                                             1 = Internal pullup disabled */
        unsigned char rsvd      : 2;    /**< Reserved. Unutilized bit. Write to 0. Reads are don't care. Bit 7:6. */
    } bits;
} reg_cnfg_glbl_a_t;

/**
 * @brief CNFG_GLBL_B Register
 *
 * Address : 0x01
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char sft_ctrl      : 3;    /**< Software Control Functions. Bit 2:0. 
                                                0x0: No Action
                                                0x1: Software Cold Reset (SFT_CRST). The device powers down, resets, and then powers up again.
                                                0x2: Software Off (SFT_OFF). The device powers down, resets, and then remains off until a wake-up event.
                                                0x3: Software Standby (SFT_STBY). The device powers down and goes to standby mode.
                                                0x4: Software Exit Standby (SFT_EXIT_STBY). The device exits standby mode and powers up again.
                                                0x5 - 0x7: Reserved */
        unsigned char rsvd          : 5;    /**< Reserved. Bit 7:3. Unutilized bit. Write to 0. Reads are don't care */
   } bits;
} reg_cnfg_glbl_b_t;

/**
 * @brief INT_GLBL Register
 *
 * Address : 0x02
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char nen_f     : 1;    /**< nEN Falling Interrupt.Bit 0.
                                            0 = No nEN falling edges have occurred since the last time this bit was read.
                                            1 = A nEN falling edge as occurred since the last time this bit was read. */
        unsigned char nen_r     : 1;    /**< nEN Rising Interrupt. Bit 1.
                                            0 = No nEN rising edges have occurred since the last time this bit was read.
                                            1 = A nEN rising edge as occurred since the last time this bit was read. */
        unsigned char tjal1_r   : 1;    /**< Thermal Alarm 1 Rising Interrupt. Bit 2.
                                            0 = The junction temperature has not risen above TJAL1 since the last time this bit was read.
                                            1 = The junction temperature has risen above TJAL1 since the last time this bit was read. */
        unsigned char tjal2_r   : 1;    /**< Thermal Alarm 2 Rising Interrupt. Bit 3.
                                            0 = The junction temperature has not risen above TJAL2 since the last time this bit was read.
                                            1 = The junction temperature has risen above TJAL2 since the last time this bit was read. */
        unsigned char sbb0_f    : 1;    /**< SBB0 Channel Fault Interrupt. Bit 4.
                                            0x0: SBB0 was not overloaded since the last time this bit was read.
                                            0x1: SBB0 was overloaded since the last time this bit was read. */
        unsigned char sbb1_f    : 1;    /**< SBB1 Channel Fault Interrupt. Bit 5.
                                            0x0: SBB1 was not overloaded since the last time this bit was read.
                                            0x1: SBB1 was overloaded since the last time this bit was read. */
        unsigned char sbb2_f    : 1;    /**< SBB2 Channel Fault Interrupt. Bit 6.
                                            0x0: SBB2 was not overloaded since the last time this bit was read.
                                            0x1: SBB2 was overloaded since the last time this bit was read. */
        unsigned char sbb3_f    : 1;    /**< SBB3 Channel Fault Interrupt. Bit 7.
                                            0x0: SBB3 was not overloaded since the last time this bit was read.
                                            0x1: SBB3 was overloaded since the last time this bit was read. */
    } bits;
} reg_int_glbl0_t;

/**
 * @brief INTM_GLBL Register
 *
 * Address : 0x03
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char nen_fm    : 1;    /**< nEN Falling Interrupt Mask. Bit 0.
                                             0 = Unmasked. If nEN_F goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to nEN_F. */
        unsigned char nen_rm    : 1;    /**< nEN Rising Interrupt Mask. Bit 1.
                                             0 = Unmasked. If nEN_R goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to nEN_R. */
        unsigned char tjal1_rm  : 1;    /**< Thermal Alarm 1 Rising Interrupt Mask. Bit 2.
                                             0 = Unmasked. If TJAL1_R goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to TJAL1_R. */
        unsigned char tjal2_rm  : 1;    /**< Thermal Alarm 2 Rising Interrupt Mask. Bit 3.
                                             0 = Unmasked. If TJAL2_R goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to TJAL2_R. */
        unsigned char sbb0_fm   : 1;    /**< SBB0 Channel Fault Interrupt Mask. Bit 4.
                                             0 = Unmasked. If SBB0_FM goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to SBB0_FM. */
        unsigned char sbb1_fm   : 1;    /**< SBB1 Channel Fault Interrupt Mask. Bit 5.
                                             0 = Unmasked. If SBB1_FM goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to SBB1_FM. */
        unsigned char sbb2_fm   : 1;    /**< SBB2 Channel Fault Interrupt Mask. Bit 6.
                                             0 = Unmasked. If SBB2_FM goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to SBB2_FM. */
        unsigned char sbb3_fm   : 1;    /**< SBB3 Channel Fault Interrupt Mask. Bit 7.
                                             0 = Unmasked. If SBB3_FM goes from 0 to 1, then nIRQ goes low. 
                                             nIRQ goes high when all interrupt bits are cleared. 
                                             1 = Masked. nIRQ does not go low due to SBB3_FM. */
    } bits;
} reg_intm_glbl_t;

/**
 * @brief STAT_GLBL Register
 *
 * Address : 0x04
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char stat_en   : 1;    /**< Debounced Status for the nEN input. Bit 0.
                                            0 = nEN is not active (logic high) 
                                            1 = nEN is active (logic low) */
        unsigned char tjal1_s   : 1;    /**< Thermal Alarm 1 Status. Bit 1.
                                            0 = The junction temperature is less than TJAL1 
                                            1 = The junction temperature is greater than TJAL1 */
        unsigned char tjal2_s   : 1;    /**< Thermal Alarm 2 Status. Bit 2.
                                            0 = The junction temperature is less than TJAL2 
                                            1 = The junction temperature is greater than TJAL2 */
        unsigned char rsvd      : 1;    /**< Reserved. Unutilized bit. Write to 0. Reads are don't care. Bit 3. */
        unsigned char sbb0_s    : 1;    /**< SBB0 Channel Regulation Status. Bit 4.
                                            0x0: SBB0 is overloaded or disabled
                                            0x1: SBB0 is not overloaded  */
        unsigned char sbb1_s    : 1;    /**< SBB1 Channel Regulation Status. Bit 5.
                                            0x0: SBB1 is overloaded or disabled
                                            0x1: SBB1 is not overloaded  */
        unsigned char sbb2_s    : 1;    /**< SBB2 Channel Regulation Status. Bit 6.
                                            0x0: SBB2 is overloaded or disabled
                                            0x1: SBB2 is not overloaded  */
        unsigned char sbb3_s    : 1;    /**< SBB3 Channel Regulation Status. Bit 7.
                                            0x0: SBB3 is overloaded or disabled
                                            0x1: SBB3 is not overloaded  */
    } bits;
} reg_stat_glbl_t;

/**
 * @brief ERCFLAG Register
 *
 * Address : 0x05
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char tovld         : 1;    /**< Thermal Overload. Bit 0.
                                                0 = Thermal overload has not occurred since the last read of this register.
                                                1 = Thermal overload has occurred since the list read of this register.
                                                This indicates that the junction temperature has exceeded 165ºC. */
        unsigned char ovlo          : 1;    /**< Overvoltage Lockout. Bit 1.
                                                0 = The overvoltage lockout has not occurred since the last read of this register.
                                                1 = The overvoltage lockout has occurred since the last read of this register */
        unsigned char uvlo          : 1;    /**< Undervoltage Lockout. Bit 2.
                                                0 = The undervoltage lockout has not occurred since the last read of this register. 
                                                1 = The undervoltage lockout has occurred since the last read of this register */
        unsigned char mrst          : 1;    /**< Manual Reset Timer. Bit 3.
                                                0 = A Manual Reset has not occurred since this last read of this register.
                                                1 = A Manual Reset has occurred since this last read of this register. */
        unsigned char sft_off_f     : 1;    /**< Software Off Flag. Bit 4.
                                                0 = The SFT_OFF function has not occurred since the last read of this register.
                                                1 = The SFT_OFF function has occurred since the last read of this register. */
        unsigned char sft_crst_f    : 1;    /**< Software Cold Reset Flag. Bit 5.
                                                0 = The software cold reset has not occurred since the last read of this register.
                                                1 = The software cold reset has occurred since the last read of this register. */
        unsigned char rsvd          : 2;    /**< Reserved. Bit 7:6. Unutilized bit. Write to 0. Reads are don't care. */
    } bits;
} reg_ercflag_t;

/**
 * @brief CID Register
 *
 * Address : 0x06
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char cid   : 8;    /**< Chip Identification Code. Bit 7:0.
                                        The Chip Identification Code refers to a set of reset values in the register map, or the "OTP configuration.". */
    } bits;
} reg_cid_t;

/**
 * @brief CONFIG_SBB_TOP
 * 
 * Address : 0x07
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char drv_sbb   : 2;    /**< SIMO Buck-Boost (all channels) Drive Strength Trim. Bit 1:0.
                                            0b00 = Fastest transition time (~0.6ns) 
											0b01 = A little slower than 0b00 (~1.2ns) 
											0b10 = A little slower than 0b01 (~1.8ns)  
											0b11 = A little slower than 0b10 (~8ns) */
		unsigned char rsvd	    : 6;    /**< Bit 7:2.*/
    } bits;
} reg_config_sbb_top_t;

/**
 * @brief CNFG_SBB0_A
 * 
 * Address : 0x08
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char tv_sbb0   : 8;    /**< SIMO Buck-Boost Channel 0 Target Output Voltage. Bit 7:0.
                                            0x00 = 0.500V 0x01 = 0.525V 0x02 = 0.550V 
											0x03 = 0.575V 0x04 = 0.600V 0x05 = 0.625V 
											0x06 = 0.650V 0x07 = 0.675V 0x08 = 0.700V 
											...
                                            0x8B: 3.975V
                                            0x8C: 4.000V
                                            0x8D–0xFF: Reserved */
    } bits;
} reg_cnfg_sbb0_a_t;

/**
 * @brief CNFG_SBB0_B
 * 
 * Address : 0x09
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char en_sbb0       : 3;    /**< Enable Control for SIMO Buck-Boost Channel 0, 
                                                selecting either an FPS slot the channel powers-up and powers-down in 
                                                or whether the channel is forced on or off. Bit 2:0.
                                                0b000 = FPS slot 0      0b001 = FPS slot 1 
                                                0b010 = FPS slot 2      0b011 = FPS slot 3      
                                                0b100 = Off irrespective of FPS 
                                                0b101 = same as 0b100   0b110 = On irrespective of FPS 
                                                0b111 = same as 0b110 */
        unsigned char ade_sbb0      : 1;    /**< SIMO Buck-Boost Channel 0 Active-Discharge Enable. Bit 3.
                                                0 = The active discharge function is disabled. 
                                                When SBB0 is disabled, its discharge rate is a function of the output capacitance and the external load. 
                                                1 = The active discharge function is enabled. 
                                                When SBB0 is disabled, an internal resistor (RAD_SBB0) is activated from SBB0 to PGND to help the output voltage discharge. */
        unsigned char rsvd1         : 2;    /**< Reserved. Bit 5:4. Unutilized bit. They are don't care. */
        unsigned char rsvd2         : 2;    /**< Reserved. Bit 7:6. Unutilized bit. They are don't care. */
    } bits;
} reg_cnfg_sbb0_b_t;

/**
 * @brief CNFG_SBB1_A
 * 
 * Address : 0x0A
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char tv_sbb1   : 8;    /**< SIMO Buck-Boost Channel 1 Target Output Voltage. Bit 7:0.
                                            0x00 = 0.500V 0x01 = 0.525V 0x02 = 0.550V 
											0x03 = 0.575V 0x04 = 0.600V 0x05 = 0.625V 
											0x06 = 0.650V 0x07 = 0.675V 0x08 = 0.700V 
											...
                                            0x8B: 3.975V
                                            0x8C: 4.000V
                                            0x8D–0xFF: Reserved */
    } bits;
} reg_cnfg_sbb1_a_t;

/**
 * @brief CNFG_SBB1_B
 * 
 * Address : 0x0B
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char en_sbb1       : 3;    /**< Enable Control for SIMO Buck-Boost Channel 1, 
                                                selecting either an FPS slot the channel powers-up and powers-down in 
                                                or whether the channel is forced on or off. Bit 2:0.
                                                0b000 = FPS slot 0      0b001 = FPS slot 1 
                                                0b010 = FPS slot 2      0b011 = FPS slot 3      
                                                0b100 = Off irrespective of FPS 
                                                0b101 = same as 0b100   0b110 = On irrespective of FPS 
                                                0b111 = same as 0b110 */
        unsigned char ade_sbb1      : 1;    /**< SIMO Buck-Boost Channel 1 Active-Discharge Enable. Bit 3.
                                                0 = The active discharge function is disabled. 
                                                When SBB1 is disabled, its discharge rate is a function of the output capacitance and the external load. 
                                                1 = The active discharge function is enabled. 
                                                When SBB1 is disabled, an internal resistor (RAD_SBB1) is activated from SBB0 to PGND to help the output voltage discharge. */
        unsigned char rsvd1         : 2;    /**< Reserved. Bit 5:4. Unutilized bit. They are don't care. */
        unsigned char rsvd2         : 2;    /**< Reserved. Bit 7:6. Unutilized bit. They are don't care. */
    } bits;
} reg_cnfg_sbb1_b_t;

/**
 * @brief CNFG_SBB2_A
 * 
 * Address : 0x0C
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char tv_sbb2   : 8;    /**< SIMO Buck-Boost Channel 2 Target Output Voltage. Bit 7:0.
                                            0x00 = 0.500V 0x01 = 0.525V 0x02 = 0.550V 
											0x03 = 0.575V 0x04 = 0.600V 0x05 = 0.625V 
											0x06 = 0.650V 0x07 = 0.675V 0x08 = 0.700V 
											...
                                            0x8B: 3.975V
                                            0x8C: 4.000V
                                            0x8D–0xFF: Reserved */
    } bits;
} reg_cnfg_sbb2_a_t;

/**
 * @brief CNFG_SBB2_B
 * 
 * Address : 0x0D
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char en_sbb2       : 3;    /**< Enable Control for SIMO Buck-Boost Channel 2, 
                                                selecting either an FPS slot the channel powers-up and powers-down in 
                                                or whether the channel is forced on or off. Bit 2:0.
                                                0b000 = FPS slot 0      0b001 = FPS slot 1 
                                                0b010 = FPS slot 2      0b011 = FPS slot 3      
                                                0b100 = Off irrespective of FPS 
                                                0b101 = same as 0b100   0b110 = On irrespective of FPS 
                                                0b111 = same as 0b110 */
        unsigned char ade_sbb2      : 1;    /**< SIMO Buck-Boost Channel 2 Active-Discharge Enable Bit 3.
                                                0 = The active discharge function is disabled. 
                                                When SBB2 is disabled, its discharge rate is a function of the output capacitance and the external load. 
                                                1 = The active discharge function is enabled. 
                                                When SBB2 is disabled, an internal resistor (RAD_SBB2) is activated from SBB0 to PGND to help the output voltage discharge. */
        unsigned char rsvd1         : 2;    /**< Reserved. Bit 5:4. Unutilized bit. They are don't care. */
        unsigned char rsvd2         : 2;    /**< Reserved. Bit 7:6. Unutilized bit. They are don't care. */
    } bits;
} reg_cnfg_sbb2_b_t;

/**
 * @brief CNFG_SBB3_A
 * 
 * Address : 0x0E
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char tv_sbb3   : 8;    /**< SIMO Buck-Boost Channel 3 Target Output Voltage. Bit 7:0.
                                            0x00 = 0.500V 0x01 = 0.525V 0x02 = 0.550V 
											0x03 = 0.575V 0x04 = 0.600V 0x05 = 0.625V 
											0x06 = 0.650V 0x07 = 0.675V 0x08 = 0.700V 
											...
                                            0x8B: 3.975V
                                            0x8C: 4.000V
                                            0x8D–0xFF: Reserved */
    } bits;
} reg_cnfg_sbb3_a_t;

/**
 * @brief CNFG_SBB3_B
 * 
 * Address : 0x0F
 */
typedef union {
    unsigned char raw;
    struct 
    {
        unsigned char en_sbb3       : 3;    /**< Enable Control for SIMO Buck-Boost Channel 3, 
                                                selecting either an FPS slot the channel powers-up and powers-down in 
                                                or whether the channel is forced on or off. Bit 2:0.
                                                0b000 = FPS slot 0      0b001 = FPS slot 1 
                                                0b010 = FPS slot 2      0b011 = FPS slot 3      
                                                0b100 = Off irrespective of FPS 
                                                0b101 = same as 0b100   0b110 = On irrespective of FPS 
                                                0b111 = same as 0b110 */
        unsigned char ade_sbb3      : 1;    /**< SIMO Buck-Boost Channel 3 Active-Discharge Enable Bit 3.
                                                0 = The active discharge function is disabled. 
                                                When SBB3 is disabled, its discharge rate is a function of the output capacitance and the external load. 
                                                1 = The active discharge function is enabled. 
                                                When SBB3 is disabled, an internal resistor (RAD_SBB3) is activated from SBB0 to PGND to help the output voltage discharge. */
        unsigned char rsvd1         : 2;    /**< Reserved. Bit 5:4. Unutilized bit. They are don't care. */
        unsigned char rsvd2         : 2;    /**< Reserved. Bit 7:6. Unutilized bit. They are don't care. */
    } bits;
} reg_cnfg_sbb3_b_t;

#endif /* MAX77655_REGS_H_ */
