/*******************************************************************************
 * Copyright(C) Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files(the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc.shall not be used except as stated in the Maxim Integrated
 * Products, Inc.Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc.retains all
 * ownership rights.
 *******************************************************************************
 */

#ifndef MAX7032_REGS_H_
#define MAX7032_REGS_H_

/**
 * @brief POWER Register
 *
 * Address : 0x00
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char x     : 1;    /**< None                       Not used */
        unsigned char rssio : 1;    /**< RSSI amplifier enable      1 = Enable buffer           0 = Disable buffer */
        unsigned char pa    : 1;    /**< Transmitter PA enable      1 = Enable PA               0 = Disable PA */
        unsigned char pkdet : 1;    /**< Peak-detector enable       1 = Enable peak detector    0 = Disable peak detector */
        unsigned char baseb : 1;    /**< Baseband enable            1 = Enable baseband         0 = Disable baseband */
        unsigned char mixer : 1;    /**< Mixer enable               1 = Enable mixer            0 = Disable mixer */
        unsigned char agc   : 1;    /**< AGC enable                 1 = Enable AGC              0 = Disable AGC */
        unsigned char lna   : 1;    /**< LNA enable                 1 = Enable LNA              0 = Disable LNA */
    } bits;
} max7032_power_t;

/**
 * @brief CONTRL Register
 *
 * Address : 0x01
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char sleep  : 1;    /**< Sleep mode                        1 = Deep-sleep
                                                                            0 = Normal operation */
        unsigned char ckout  : 1;    /**< Crystal clock output enable       1 = Enable crystal clock output
                                                                            0 = Disable crystal clock output */
        unsigned char fcal   : 1;    /**< FSK calibration                   1 = Perform FSK calibration Automatically */
        unsigned char pcal   : 1;    /**< Polling timer calibration         1 = Perform polling timer calibration Automatically*/
        unsigned char x      : 1;    /**< None                              Not used*/
        unsigned char trk_en : 1;    /**< Manual peak-detector tracking     1 = Force manual peak-detector tracking
                                                                            0 = Release peak-detector tracking*/
        unsigned char gain   : 1;    /**< Gain state                        1 = Force manual high-gain state if MGAIN = 1
                                                                            0 = Force manual low-gain state if MGAIN = 1*/
        unsigned char agclk  : 1;    /**< AGC locking feature               1 = Enable AGC lock
                                                                            0 = Disable AGC lock*/
    } bits;
} max7032_contrl_t;

/**
 * @brief CONF0 Register
 *
 * Address : 0x02
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char onps  : 2;    /**< On-timer prescaler             Sets the time base for the on timer */
        unsigned char ofps  : 2;    /**< Off-timer prescaler            Sets the time base for the off timer */
        unsigned char drx   : 1;    /**< Discontinuous receive mode     1 = Enable DRX
                                                                        0 = Disable DRX */
        unsigned char mgain : 1;    /**< Manual gain mode               1 = Enable manual-gain mode
                                                                        0 = Disable manual-gain mode */
        unsigned char t_r   : 1;    /**< Transmit or receive            1 = Enable transmit mode of the transceiver
                                                                        0 = Enable receive mode of the transceiver */
        unsigned char mode  : 1;    /**< FSK or ASK modulation          1 = Enable FSK for both receive and transmit
                                                                        0 = Enable ASK for both receive and transmit */
    } bits;
} max7032_conf0_t;

/**
 * @brief CONF1 Register
 *
 * Address : 0x03
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char dt    : 3;    /**< AGC dwell timer                AGC dwell timer */
        unsigned char cdiv  : 2;    /**< Crystal divider                CLKOUT crystal-divider */
        unsigned char clkof : 1;    /**< Continuous clock output        1 = Enable continuous clock output when CKOUT = 1
                                                                        0 = Continuous clock output */
        unsigned char acal  : 1;    /**< Automatic FSK calibration      1 = Enable automatic FSK calibration
                                                                        0 = Disable automatic FSK calibration*/
        unsigned char x     : 1;    /**< None                           Not used*/
    } bits;
} max7032_conf1_t;

/**
 * @brief OSC Register
 *
 * Address : 0x05
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char osc;
    } bits;
} max7032_osc_t;

/**
 * @brief tOFF Register (Upper Byte)
 *
 * Address : 0x06
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char toff_upper;
    } bits;
} max7032_toff_upper_t;

/**
 * @brief tOFF Register (Lower Byte)
 *
 * Address : 0x07
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char toff_lower;
    } bits;
} max7032_toff_lower_t;

/**
 * @brief tCPU Register
 *
 * Address : 0x08
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char tcpu;
    } bits;
} max7032_tcpu_t;

/**
 * @brief tRF Register (Upper Byte)
 *
 * Address : 0x09
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char trf_upper;
    } bits;
} max7032_trf_upper_t;

/**
 * @brief tRF Register (Lower Byte)
 *
 * Address : 0x0A
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char trf_lower;
    } bits;
} max7032_trf_lower_t;

/**
 * @brief tON Register (Upper Byte)
 *
 * Address : 0x0B
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char ton_upper;
    } bits;
} max7032_ton_upper_t;

/**
 * @brief tON Register (Lower Byte)
 *
 * Address : 0x0C
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char ton_lower;
    } bits;
} max7032_ton_lower_t;

/**
 * @brief TxLOW Register (Upper Byte)
 *
 * Address : 0x0D
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char txlow_upper;
    } bits;
} max7032_txlow_upper_t;

/**
 * @brief TxLOW Register (Lower Byte)
 *
 * Address : 0x0E
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char txlow_lower;
    } bits;
} max7032_txlow_lower_t;

/**
 * @brief TxHIGH Register (Upper Byte)
 *
 * Address : 0x0F
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char txhigh_upper;
    } bits;
} max7032_txhigh_upper_t;

/**
 * @brief TxHIGH Register (Lower Byte)
 *
 * Address : 0x10
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char txhigh_lower;
    } bits;
} max7032_txhigh_lower_t;

/**
 * @brief STATUS Register
 *
 * Address : 0x1A
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char fcald : 1;    /**<  FSK calibration done              1 = FSK calibration is completed
                                                                            0 = FSK calibration is in progress or not completed*/
        unsigned char pcald : 1;    /**<  Polling timer calibration done    1 = Polling timer calibration is completed
                                                                            0 = Polling timer calibration is in progress or not completed*/
        unsigned char x0    : 1;    /**<  None                              Zero*/
        unsigned char x1    : 1;    /**<  None                              Zero*/
        unsigned char x2    : 1;    /**<  None                              Zero*/
        unsigned char clkon : 1;    /**<  Clock/crystal alive               1 = Valid clock at crystal inputs
                                                                            0 = No valid clock signal seen at the crystal inputs*/
        unsigned char gains : 1;    /**<  AGC gain state                    1 = LNA in high-gain state
                                                                            0 = LNA in low-gain state*/
        unsigned char lckd  : 1;    /**<  Lock detect                       1 = Internal PLL is locked
                                                                            0 = Internal PLL is not locked */
    } bits;
} max7032_status_t;

/**
 * @brief DEMOD Register
 *
 * Address : 0x00
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char dummy_byte;

    } bits;
} max7032_dummy_t;

/**
 * @brief Register Set
 *
 *
 */
typedef struct {
    max7032_power_t         power;
    max7032_contrl_t        contrl;
    max7032_conf0_t         conf0;
    max7032_conf1_t         conf1;
    max7032_osc_t           osc;
    max7032_toff_upper_t    toff_upper;
    max7032_toff_lower_t    toff_lower;
    max7032_tcpu_t          tcpu;
    max7032_trf_upper_t     trf_upper;
    max7032_trf_lower_t     trf_lower;
    max7032_ton_upper_t     ton_upper;
    max7032_ton_lower_t     ton_lower;
    max7032_txlow_upper_t   txlow_upper;
    max7032_txlow_lower_t   txlow_lower;
    max7032_txhigh_upper_t  txhigh_upper;
    max7032_txhigh_lower_t  txhigh_lower;
    max7032_status_t        status;
} max7032_reg_map_t;

#endif /* MAX7032_REGS_H_ */
