#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

// Virtual serial port over USB
USBSerial microUSB; 

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

/* Analog inputs 0 and 1 have internal dividers to allow measuring 5V signals  
 * The dividers are selected by using inputs AIN_4 and AIN_5 respectively.
 * The full scale range for AIN0-3 is 1.2V
 * The full scale range for AIN4-5 is 6.0V
 */
AnalogIn ain1(AIN_5);
const float AIN5_FSV = 6.0f;   /* Full scale value for AIN5 */

float max6613_celsius_to_fahrenheit(float temp_c)
{
    float temp_f;
    temp_f = ((temp_c * 9)/5) + 32;
    return temp_f;
}

void max6613_timer(void) {
        gLED = !gLED;  /* blink the green LED */
}


// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
/**
* @brief Sample main program for MAX6613
* @version 1.0000.0000
*
* @details Sample main program for MAX6613
* The MAX6613 is a low-cost, low-power analog output (1 wire, plus power)
* temperature sensor in a tiny 5-pin SC70 package (0.65 mm pitch)
* Supply Current: 7.5µA typical
* Supply voltage: 1.8V to 5.5V
* Operating Range: -55°C to +130°C when VDD is 2.5V to 5.5V
*                   25°C to +130°C when VDD is 1.8V
* Accuracy: +-4°C
* Pin Compatible with LM20
*
* The prints are sent to the terminal window (9600, 8n1).
* The program sets the GPIOs to 3.3V and the program
* configures the chip and reads temperatures.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus (MAX32630FTHR) after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/
int main()
{
    float temperature;
    uint32_t i;
    const float A = -0.00000225f;
    const float B = -0.01105f;
    const float C1 = 1.8455f;
    float c2;
    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_OFF;
    gLED = LED_OFF;
    bLED = LED_OFF;
    Ticker ticker;   // calls a callback repeatedly with a timeout
    ticker.attach(callback(&max6613_timer), 1.0f);  /* set timer for one second */

    daplink.printf("MAX6613 Temperature Sensor\r\n\r\n");

    temperature = (float)((1.8455f - (AIN5_FSV * ain1)) / 0.01123f);
#if 0
    daplink.printf("AIN1: %1.5f\n", (AIN5_FSV * ain1) );  // analog inputs 1
#endif

    daplink.printf("Temperature using Linear Approximation\r\n");
    for (i = 0; i < 8; i++) {
        temperature = (float)((1.8455f - (AIN5_FSV * ain1)) / 0.01123f);
        daplink.printf("temperature: %3.1f degrees C, %3.1f degrees F\r\n", temperature, max6613_celsius_to_fahrenheit(temperature));
        wait(2);
    }
    daplink.printf("\r\n");

    daplink.printf("Temperature using Quadratic Equation\r\n");
    for (i = 0; i < 8; i++) {
        c2 = AIN5_FSV * ain1;
        temperature = (-B - sqrt(B*B - 4*A*(C1-c2)))/(2*A);
        daplink.printf("temperature: %3.1f degrees C, %3.1f degrees F\r\n", temperature, max6613_celsius_to_fahrenheit(temperature));
        wait(2);
    }
    daplink.printf("\r\n\r\n");

    while(1) {
    }
}

