﻿// /*******************************************************************************
// * Copyright (C) 2021 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - Please note the last supported version is Mbed OS 6.3.
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://developer.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - #include "max32625pico.h"
//      - add https://os.mbed.com/users/switches/code/max32625pico/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//      - see https://os.mbed.com/users/switches/code/max32625pico/
//      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
//      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
//      - see https://os.mbed.com/users/switches/code/SerialInterface/
//      - Note: To load the MAX32625PICO firmware, hold the button while
//        connecting the USB cable, then copy firmware bin file 
//        to the MAINTENANCE drive.
//      - see https://os.mbed.com/platforms/MAX32625PICO/
//      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
//
// end Platform_Include_Boilerplate
#include "MAX5719.h"
#include "CmdLine.h"
#include "MaximTinyTester.h"

#include "MAX5719.h"
extern MAX5719 g_MAX5719_device; // defined in main.cpp



void MAX5719_menu_help(CmdLine & cmdLine)
{
    cmdLine.serial().printf("\r\n ! -- Init");
    cmdLine.serial().printf("\r\n A code=?|code=1.234V -- CODE");
    cmdLine.serial().printf("\r\n B -- LOAD");
    cmdLine.serial().printf("\r\n C code=?|code=1.234V -- CODE_LOAD");
    //
    cmdLine.serial().printf("\r\n @ -- print MAX5719 configuration");

    //
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands
    cmdLine.serial().printf("\r\n L -- LDACb output LH high LL low"); // TODO: ExternFunctionGPIOPinCommand testMenuGPIOItemsDict

    //
}

bool MAX5719_menu_onEOLcommandParser(CmdLine & cmdLine)
{


                    // parse argument int32_t DACCode
        int32_t DACCode = g_MAX5719_device.DACCode; // default to global property value
        if (cmdLine.parse_int32_dec("DACCode", DACCode))
        {
            g_MAX5719_device.DACCode = DACCode; // update global property value
        }
                    // "code" is an alias for argument "DACCode"; support DACCodeOfVoltage
        { // enclose temporary voltageV
        double voltageV; // support DACCodeOfVoltage
        switch (cmdLine.parse_double_or_int32("code", voltageV, DACCode))
        {
        case 2: // 2: parsed as double
            // parse_double_or_uint32 returns 1: parsed as integer; 2: parsed as double
            DACCode = g_MAX5719_device.DACCodeOfVoltage((double)voltageV);
            g_MAX5719_device.DACCode = DACCode; // update global property value
            cmdLine.serial().printf("\r\nDACCodeOfVoltage(%1.6fV)=0x%6.6X\r\n", voltageV, g_MAX5719_device.DACCode);
            break;
        case 1: // 1: parsed as integer
            g_MAX5719_device.DACCode = DACCode; // update global property value
            break;
        }
        } // enclose temporary voltageV

                    // parse argument double VRef
        double VRef = g_MAX5719_device.VRef; // default to global property value
        if (cmdLine.parse_double("VRef", VRef))
        {
            g_MAX5719_device.VRef = VRef; // update global property value
        }

    switch (cmdLine[0])
    {
        case '@':
        {
                    cmdLine.serial().printf("VRef = ");
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX5719_device.VRef);
                    cmdLine.serial().printf("DACCode = ");
                    cmdLine.serial().printf("%ld = 0x%8.8lx\r\n", g_MAX5719_device.DACCode, g_MAX5719_device.DACCode);
                    return true; // command handled by MAX5719
            break;
        }
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands
        case 'L':
        {
            switch (cmdLine[1])
            {
                case 'H':
                {
                    g_MAX5719_device.LDACboutputValue(1);
                    break;
                }
                case 'L':
                {
                    g_MAX5719_device.LDACboutputValue(0);
                    break;
                }
            }
                    return true; // command handled by MAX5719
            break;
        }
        // case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
        case '!':
        {
                    // test menu command '!' handler:
                    // helpString='! -- Init'
                    // CMD_='None'
                    // CommandName='Init'
                    // CommandParamIn='void'
                    // CommandReturnType='void'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return=''
                    // @Test='@test group CODE_LOAD // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default)'
                    // @Test='@test group CODE_LOAD tinyTester.print("VRef = 4.096   MAX5719 20-bit LSB = 0.000004V = 3.90625uV")'
                    // @Test='@test group CODE_LOAD tinyTester.print("Wire MAX5719 OUT to platform AIN0 for analog loopback tests...")'
                    // @Test='@test group CODE_LOAD VRef = 4.096'
                    // @Test='@test group CODE_LOAD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
                    // @Test='@test group CODE_LOAD tinyTester.settle_time_msec = 500'
                    // @Test='@test Init()'
                    // @Test='@test VRef expect 4.096 // Nominal Full-Scale Voltage Reference'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = 0.050'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x000000 = 0.000V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x000000) // 0.000V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.000000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x01f400 = 0.500V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x01f400) // 0.500V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.500000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x03e800 = 1.000V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x03e800) // 1.000V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.000000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.050*/ /*mbed:0.075*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x05dc00 = 1.500V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x05dc00) // 1.500V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.500000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.050*/ /*mbed:0.100*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x07d000 = 2.000V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x07d000) // 2.000V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.000000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.050*/ /*mbed:0.150*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x09c400 = 2.500V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x09c400) // 2.500V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.500000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.200*/ /*mbed:0.200*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x0bb800 = 3.000V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x0bb800) // 3.000V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(3.000000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.250*/ /*mbed:0.250*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x0dac00 = 3.500V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x0dac00) // 3.500V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(3.500000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.500*/ /*mbed:0.500*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x0fa000 = 4.000V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x0fa000) // 4.000V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(4.000000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.750*/ /*mbed:0.750*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x0fffff = 4.095V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x0fffff) // 4.095V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(4.095000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = /*Arduino:0.200*/ /*mbed:0.200*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD tinyTester.print("0x080000  // 2.048V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x080000) // 2.048V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.048000)'
                    // @Test='/*mbed:@test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD_2V5 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)'
                    // @Test='@test group CODE_LOAD_2V5 tinyTester.err_threshold = /*Arduino:0.150*/ /*mbed:0.150*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD_2V5 tinyTester.print("0x09c400 = 2.500V")'
                    // @Test='@test group CODE_LOAD_2V5 CODE_LOAD(0x09c400) // 2.500V'
                    // @Test='@test group CODE_LOAD_2V5 tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD_2V5 tinyTester.AnalogIn0_Read_Expect_voltageV(2.500000)'
                    // @Test='/*mbed:@test group CODE_LOAD_2V5 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD_3V0 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)'
                    // @Test='@test group CODE_LOAD_3V0 tinyTester.err_threshold = /*Arduino:0.200*/ /*mbed:0.200*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD_3V0 tinyTester.print("0x0bb800 = 3.000V")'
                    // @Test='@test group CODE_LOAD_3V0 CODE_LOAD(0x0bb800) // 3.000V'
                    // @Test='@test group CODE_LOAD_3V0 tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD_3V0 tinyTester.AnalogIn0_Read_Expect_voltageV(3.000000)'
                    // @Test='/*mbed:@test group CODE_LOAD_3V0 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    // @Test='@test group CODE_LOAD_4V1 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)'
                    // @Test='@test group CODE_LOAD_4V1 tinyTester.err_threshold = /*Arduino:0.750*/ /*mbed:0.750*/ /*eabi:0.050*/'
                    // @Test='@test group CODE_LOAD_4V1 tinyTester.print("0x0fffff = 4.095V")'
                    // @Test='@test group CODE_LOAD_4V1 CODE_LOAD(0x0fffff) // 4.095V'
                    // @Test='@test group CODE_LOAD_4V1 tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD_4V1 tinyTester.AnalogIn0_Read_Expect_voltageV(4.095000)'
                    // @Test='/*mbed:@test group CODE_LOAD_4V1 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0 */'
                    cmdLine.serial().printf("Init");
                    // call function Init
                    g_MAX5719_device.Init();
                    return true; // command handled by MAX5719
        } // end case '!'
        break;
        case 'A':
        {
                    // test menu command 'A' handler:
                    // helpString='A code=?|code=1.234V -- CODE'
                    // CMD_='None'
                    // CommandName='CODE'
                    // CommandParamIn='uint32_t dacCodeLsbs'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // parse argument uint32_t dacCodeLsbs
                    uint32_t dacCodeLsbs = 0; // --- g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__; // default to global property value
                    if (cmdLine.parse_uint32_dec("dacCodeLsbs", dacCodeLsbs))
                    {
                        // g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__ = dacCodeLsbs; // update global property value
                    }
                    // "code" is an alias for argument "dacCodeLsbs"; support DACCodeOfVoltage 
                    { // enclose temporary voltageV
                    double voltageV; // support DACCodeOfVoltage
                    switch (cmdLine.parse_double_or_uint32("code", voltageV, dacCodeLsbs))
                    {
                    case 2: // 2: parsed as double
                        // parse_double_or_uint32 returns 1: parsed as integer; 2: parsed as double
                        dacCodeLsbs = g_MAX5719_device.DACCodeOfVoltage((double)voltageV);
                        // g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__ = dacCodeLsbs; // update global property value
                        cmdLine.serial().printf("\r\nDACCodeOfVoltage(%1.6fV)=0x%6.6X\r\n", voltageV, dacCodeLsbs);
                        break;
                    case 1: // 1: parsed as integer
                        // g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__ = dacCodeLsbs; // update global property value
                        break;
                    }
                    } // enclose temporary voltageV
                    // print arguments
                    cmdLine.serial().printf("CODE");
                    cmdLine.serial().printf(" dacCodeLsbs=%ld", dacCodeLsbs);
                    cmdLine.serial().printf("\r\n");
                    // call function CODE(dacCodeLsbs)
                    uint8_t result = g_MAX5719_device.CODE(dacCodeLsbs);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5719
        } // end case 'A'
        break;
        case 'B':
        {
                    // test menu command 'B' handler:
                    // helpString='B -- LOAD'
                    // CMD_='None'
                    // CommandName='LOAD'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("LOAD");
                    // call function LOAD
                    uint8_t result = g_MAX5719_device.LOAD();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5719
        } // end case 'B'
        break;
        case 'C':
        {
                    // test menu command 'C' handler:
                    // helpString='C code=?|code=1.234V -- CODE_LOAD'
                    // CMD_='None'
                    // CommandName='CODE_LOAD'
                    // CommandParamIn='uint32_t dacCodeLsbs'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // parse argument uint32_t dacCodeLsbs
                    uint32_t dacCodeLsbs = 0; // --- g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__; // default to global property value
                    if (cmdLine.parse_uint32_dec("dacCodeLsbs", dacCodeLsbs))
                    {
                        // g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__ = dacCodeLsbs; // update global property value
                    }
                    // "code" is an alias for argument "dacCodeLsbs"; support DACCodeOfVoltage 
                    { // enclose temporary voltageV
                    double voltageV; // support DACCodeOfVoltage
                    switch (cmdLine.parse_double_or_uint32("code", voltageV, dacCodeLsbs))
                    {
                    case 2: // 2: parsed as double
                        // parse_double_or_uint32 returns 1: parsed as integer; 2: parsed as double
                        dacCodeLsbs = g_MAX5719_device.DACCodeOfVoltage((double)voltageV);
                        // g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__ = dacCodeLsbs; // update global property value
                        cmdLine.serial().printf("\r\nDACCodeOfVoltage(%1.6fV)=0x%6.6X\r\n", voltageV, dacCodeLsbs);
                        break;
                    case 1: // 1: parsed as integer
                        // g_MAX5719_device.__WARNING_no_match_for_argname_dacCodeLsbs_in_MAX5719_device_t__ = dacCodeLsbs; // update global property value
                        break;
                    }
                    } // enclose temporary voltageV
                    // print arguments
                    cmdLine.serial().printf("CODE_LOAD");
                    cmdLine.serial().printf(" dacCodeLsbs=%ld", dacCodeLsbs);
                    cmdLine.serial().printf("\r\n");
                    // call function CODE_LOAD(dacCodeLsbs)
                    uint8_t result = g_MAX5719_device.CODE_LOAD(dacCodeLsbs);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5719
        } // end case 'C'
        break;
    } // end switch (cmdLine[0])
    return false; // command not handled by MAX5719
} // end bool MAX5719_menu_onEOLcommandParser(CmdLine & cmdLine)

