﻿// /*******************************************************************************
// * Copyright (C) 2021 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - Please note the last supported version is Mbed OS 6.3.
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://developer.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - #include "max32625pico.h"
//      - add https://os.mbed.com/users/switches/code/max32625pico/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//      - see https://os.mbed.com/users/switches/code/max32625pico/
//      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
//      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
//      - see https://os.mbed.com/users/switches/code/SerialInterface/
//      - Note: To load the MAX32625PICO firmware, hold the button while
//        connecting the USB cable, then copy firmware bin file 
//        to the MAINTENANCE drive.
//      - see https://os.mbed.com/platforms/MAX32625PICO/
//      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
//
// end Platform_Include_Boilerplate
#include "MAX5719.h"

// example code board support
//MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
//DigitalOut rLED(LED1);
//DigitalOut gLED(LED2);
//DigitalOut bLED(LED3);
//
// Arduino "shield" connector port definitions (MAX32625MBED shown)
#if defined(TARGET_MAX32625MBED)
#define A0 AIN_0
#define A1 AIN_1
#define A2 AIN_2
#define A3 AIN_3
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P0_4
#define D5 P0_5
#define D6 P0_6
#define D7 P0_7
#define D8 P1_4
#define D9 P1_5
#define D10 P1_3
#define D11 P1_1
#define D12 P1_2
#define D13 P1_0
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
#define A0 AIN_1
#define A1 AIN_2
// #define A2 AIN_3
// #define A3 AIN_0
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P1_7
#define D5 P1_6
#define D6 P4_4
#define D7 P4_5
#define D8 P4_6
#define D9 P4_7
#define D10 P0_7
#define D11 P0_6
#define D12 P0_5
#define D13 P0_4
#endif

// example code declare SPI interface (GPIO controlled CS)
#if defined(TARGET_MAX32625MBED)
SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
SPI spi(SPI0_MOSI, SPI0_MISO, SPI0_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625PICO: pin P0_5 P0_6 P0_4
DigitalOut spi_cs(SPI0_SS); // TARGET_MAX32625PICO: pin P0_7
#elif defined(TARGET_MAX32600MBED)
SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// TODO1: avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
// void spi_init(spi_t *obj, PinName mosi, PinName miso, PinName sclk, PinName ssel)
//
// TODO1: NUCLEO_F446RE SPI not working; CS and MOSI data looks OK but no SCLK clock pulses.
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk spi1 TARGET_NUCLEO_F446RE: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI_CS); // TARGET_NUCLEO_F446RE: PB_6 Arduino 10-pin header D10
//
#else
SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
#endif

// example code declare GPIO interface pins
// AnalogOut RFB_pin(Px_x_PortName_To_Be_Determined); // Analog Input to MAX5719 device
// AnalogOut INV_pin(Px_x_PortName_To_Be_Determined); // Analog Input to MAX5719 device
DigitalOut LDACb_pin(D9); // Digital Trigger Input to MAX5719 device
// AnalogIn OUT_pin(A0); // Analog Output from MAX5719 device
// example code declare device instance
MAX5719 g_MAX5719_device(spi, spi_cs, LDACb_pin, MAX5719::MAX5719_IC);

// FUTURE: Function Generator for DAC output -- declarations
//--------------------------------------------------
// Function Generator for DAC output
//
#ifndef USE_FunctionGenerator
#define USE_FunctionGenerator 1
#endif // USE_FunctionGenerator

#if USE_FunctionGenerator
//--------------------------------------------------
// Function Generator for DAC output
//
#include "FunctionGenerator.h"
#endif // USE_FunctionGenerator

#if USE_FunctionGenerator
//--------------------------------------------------
// declare a Function Generator object
//
DACFunctionGenerator DACStepFunctionGenerator;
#endif // USE_FunctionGenerator

// example code main function
int main()
{
    // setup: put your setup code here, to run once

    g_MAX5719_device.Init();

    // FUTURE: Function Generator for DAC output -- setup
    // CODE GENERATOR: ResolutionBits = 20
    // CODE GENERATOR: FScode = 0xfffff
#if USE_FunctionGenerator
    DACStepFunctionGenerator.Configure_Constant(
        /* uint32_t code */ 0x7ffff  // 50.0% of full scale
    );
#if USE_FunctionGenerator_TriangleRampUpDown
    DACStepFunctionGenerator.Configure_TriangleRampUpDown(
        /* uint32_t code_limit_L */ 0x0000,  // 0.0% of full scale
        /* uint32_t code_limit_H */ 0xfffff,  // 100.0% of full scale
        /* int32_t increment */ 0x00001
    );
#endif // USE_FunctionGenerator_TriangleRampUpDown
#if USE_FunctionGenerator_RampUp
    DACStepFunctionGenerator.Configure_RampUp(
        /* uint32_t code_limit_L */ 0x0000,  // 0.0% of full scale
        /* uint32_t code_limit_H */ 0xfffff,  // 100.0% of full scale
        /* int32_t increment */ 0x00001
    );
#endif // USE_FunctionGenerator_RampUp
#if USE_FunctionGenerator_RampDown
    DACStepFunctionGenerator.Configure_RampDown(
        /* uint32_t code_limit_L */ 0x0000,  // 0.0% of full scale
        /* uint32_t code_limit_H */ 0xfffff,  // 100.0% of full scale
        /* int32_t increment */ 0x00001
    );
#endif // USE_FunctionGeneratorRampDown
#if USE_FunctionGenerator_Sine
    DACStepFunctionGenerator.Configure_Sine(
        /* uint32_t code_limit_L */ 0x0000,  // 0.0% of full scale
        /* uint32_t code_limit_H */ 0xfffff,  // 100.0% of full scale
        /* float num_samples_per_tone_cycle */ 128.0
    );
#endif // USE_FunctionGenerator_Sine
#if USE_FunctionGenerator_Table
    static uint32_t waveformTable[] = {
        0xfffff, // 100.0% of full scale REF(4.096V) = 4.096V
        0xe6665, // 90.0% of full scale REF(4.096V) = 3.686V
        0xccccc, // 80.0% of full scale REF(4.096V) = 3.277V
        0xb3332, // 70.0% of full scale REF(4.096V) = 2.867V
        0x99999, // 60.0% of full scale REF(4.096V) = 2.458V
        0x7ffff, // 50.0% of full scale REF(4.096V) = 2.048V
        0x66666, // 40.0% of full scale REF(4.096V) = 1.638V
        0x4cccc, // 30.0% of full scale REF(4.096V) = 1.229V
        0x33333, // 20.0% of full scale REF(4.096V) = 0.819V
        0x19999, // 10.0% of full scale REF(4.096V) = 0.410V
        0x00000, // 0.0% of full scale REF(4.096V) = 0.000V
    };
    DACStepFunctionGenerator.Configure_Table(
        /* uint32_t* table_data */ waveformTable, 
        /* table_length */ 11 /* sizeof(waveformTable)/sizeof(uint32_t) */, 
        /* increment */ 0x00001
    );
#endif // USE_FunctionGenerator_Table
#if USE_FunctionGenerator_Sine_Table
    #define sizeof_sineWaveformTable 256
    static uint32_t sineWaveformTable[sizeof_sineWaveformTable];
    DACStepFunctionGenerator.Configure_Sine_Table(
        /* uint32_t* table_data_buffer */ sineWaveformTable,
        /* uint32_t table_length */ sizeof_sineWaveformTable, /* sizeof(sineWaveformTable)/sizeof(uint32_t) */
        /* uint32_t code_limit_L */ 0x0000,  // 0.0% of full scale
        /* uint32_t code_limit_H */ 0xfffff,  // 100.0% of full scale
        /* float num_tone_cycles_in_table */ 11.0
    );
#endif // USE_FunctionGenerator_Sine_Table
#endif // USE_FunctionGenerator

    while (1)
    {
        // loop: put your main code here, to run repeatedly

        // FUTURE: Function Generator for DAC output -- loop
#if USE_FunctionGenerator
        //~ uint32_t code = 0xfffff; // 100.0% of full scale REF(4.096V) = 4.096V
        //~ g_MAX5719_device.CODE_LOAD(code);
        //~ delay(1); // delay(unsigned long interval_msec)
        //~ g_MAX5719_device.CODE_LOAD(0);
        //~ delay(1); // delay(unsigned long interval_msec)
        // DACStepFunctionGenerator
        //~ g_MAX5719_device.CODE_LOAD(DACStepFunctionGenerator.code_limit_H);
        //~ delay(1); // delay(unsigned long interval_msec)
        //~ g_MAX5719_device.CODE_LOAD(DACStepFunctionGenerator.code_limit_L);
        //~ delay(1); // delay(unsigned long interval_msec)
        g_MAX5719_device.CODE_LOAD(DACStepFunctionGenerator.Next());
        //~ delay(1); // delay(unsigned long interval_msec)
#else // USE_FunctionGenerator
        uint32_t code;
        //
        // example #1
        code = 0xfffff; // 100.0% of full scale REF(4.096V) = 4.096V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #2
        code = 0xe6665; // 90.0% of full scale REF(4.096V) = 3.686V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #3
        code = 0xccccc; // 80.0% of full scale REF(4.096V) = 3.277V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #4
        code = 0xb3332; // 70.0% of full scale REF(4.096V) = 2.867V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #5
        code = 0x99999; // 60.0% of full scale REF(4.096V) = 2.458V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #6
        code = 0x7ffff; // 50.0% of full scale REF(4.096V) = 2.048V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #7
        code = 0x66666; // 40.0% of full scale REF(4.096V) = 1.638V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #8
        code = 0x4cccc; // 30.0% of full scale REF(4.096V) = 1.229V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #9
        code = 0x33333; // 20.0% of full scale REF(4.096V) = 0.819V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #10
        code = 0x19999; // 10.0% of full scale REF(4.096V) = 0.410V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #11
        code = 0x0000; // 0.0% of full scale REF(4.096V) = 0.000V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #12
        code = 0x0000; // 0.0% of full scale REF(4.096V) = 0.000V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #13
        code = 0x19999; // 10.0% of full scale REF(4.096V) = 0.410V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #14
        code = 0x33333; // 20.0% of full scale REF(4.096V) = 0.819V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #15
        code = 0x4cccc; // 30.0% of full scale REF(4.096V) = 1.229V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #16
        code = 0x66666; // 40.0% of full scale REF(4.096V) = 1.638V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #17
        code = 0x7ffff; // 50.0% of full scale REF(4.096V) = 2.048V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #18
        code = 0x99999; // 60.0% of full scale REF(4.096V) = 2.458V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #19
        code = 0xb3332; // 70.0% of full scale REF(4.096V) = 2.867V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #20
        code = 0xccccc; // 80.0% of full scale REF(4.096V) = 3.277V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #21
        code = 0xe6665; // 90.0% of full scale REF(4.096V) = 3.686V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #22
        code = 0xfffff; // 100.0% of full scale REF(4.096V) = 4.096V
        g_MAX5719_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)

        // wait(3.0);
        // FUTURE: Function Generator for DAC output -- loop end
#endif // USE_FunctionGenerator
    }
}

