﻿// /*******************************************************************************
// * Copyright (C) 2021 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX5719.h
// *********************************************************************
// Header file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example
// Device Name = MAX5719
// Device Description = 20-Bit, low glitch energy 0.05nV-sec, Voltage-Output DAC with SPI Interface
// Device DeviceBriefDescription = 20-bit 0.05nV-sec DAC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX5719AGSD+
// Device RegValue_Width = DataWidth16bit_HL
//
// DAC NumChannels = 1
// DAC ResolutionBits = 20
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 50
// SPI SCLKMinMHz = 0
//


// Prevent multiple declaration
#ifndef __MAX5719_H__
#define __MAX5719_H__

// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - Please note the last supported version is Mbed OS 6.3.
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://developer.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - #include "max32625pico.h"
//      - add https://os.mbed.com/users/switches/code/max32625pico/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//      - see https://os.mbed.com/users/switches/code/max32625pico/
//      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
//      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
//      - see https://os.mbed.com/users/switches/code/SerialInterface/
//      - Note: To load the MAX32625PICO firmware, hold the button while
//        connecting the USB cable, then copy firmware bin file 
//        to the MAINTENANCE drive.
//      - see https://os.mbed.com/platforms/MAX32625PICO/
//      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
//
// end Platform_Include_Boilerplate

/**
 * @brief MAX5719 20-Bit, low glitch energy 0.05nV-sec, Voltage-Output DAC with SPI Interface
 *
 *
 *
 * Datasheet: https://www.maximintegrated.com/MAX5719
 *
 *
 *
 * @code
 * // example code includes
 * // standard include for target platform -- Platform_Include_Boilerplate
 * #include "mbed.h"
 * // Platforms:
 * //   - MAX32625MBED
 * //      - supports mbed-os-5.11, requires USBDevice library
 * //      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32600MBED
 * //      - Please note the last supported version is Mbed OS 6.3.
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
 * //   - NUCLEO_F446RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - NUCLEO_F401RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32630FTHR
 * //      - #include "max32630fthr.h"
 * //      - add http://developer.mbed.org/teams/MaximIntegrated/code/max32630fthr/
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32620FTHR
 * //      - #include "MAX32620FTHR.h"
 * //      - remove max32630fthr library (if present)
 * //      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
 * //      - not tested yet
 * //   - MAX32625PICO
 * //      - #include "max32625pico.h"
 * //      - add https://os.mbed.com/users/switches/code/max32625pico/
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - not tested yet
 * //      - see https://os.mbed.com/users/switches/code/max32625pico/
 * //      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
 * //      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
 * //      - see https://os.mbed.com/users/switches/code/SerialInterface/
 * //      - Note: To load the MAX32625PICO firmware, hold the button while
 * //        connecting the USB cable, then copy firmware bin file
 * //        to the MAINTENANCE drive.
 * //      - see https://os.mbed.com/platforms/MAX32625PICO/
 * //      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
 * //
 * // end Platform_Include_Boilerplate
 * #include "MAX5719.h"
 *
 * // example code board support
 * //MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 * //DigitalOut rLED(LED1);
 * //DigitalOut gLED(LED2);
 * //DigitalOut bLED(LED3);
 * //
 * // Arduino "shield" connector port definitions (MAX32625MBED shown)
 * #if defined(TARGET_MAX32625MBED)
 * #define A0 AIN_0
 * #define A1 AIN_1
 * #define A2 AIN_2
 * #define A3 AIN_3
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P0_4
 * #define D5 P0_5
 * #define D6 P0_6
 * #define D7 P0_7
 * #define D8 P1_4
 * #define D9 P1_5
 * #define D10 P1_3
 * #define D11 P1_1
 * #define D12 P1_2
 * #define D13 P1_0
 * #elif defined(TARGET_MAX32625PICO)
 * #warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
 * #define A0 AIN_1
 * #define A1 AIN_2
 * // #define A2 AIN_3
 * // #define A3 AIN_0
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P1_7
 * #define D5 P1_6
 * #define D6 P4_4
 * #define D7 P4_5
 * #define D8 P4_6
 * #define D9 P4_7
 * #define D10 P0_7
 * #define D11 P0_6
 * #define D12 P0_5
 * #define D13 P0_4
 * #endif
 *
 * // example code declare SPI interface (GPIO controlled CS)
 * #if defined(TARGET_MAX32625MBED)
 * SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
 * #elif defined(TARGET_MAX32625PICO)
 * #warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
 * SPI spi(SPI0_MOSI, SPI0_MISO, SPI0_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625PICO: pin P0_5 P0_6 P0_4
 * DigitalOut spi_cs(SPI0_SS); // TARGET_MAX32625PICO: pin P0_7
 * #elif defined(TARGET_MAX32600MBED)
 * SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
 * #elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
 * // TODO1: avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
 * // void spi_init(spi_t *obj, PinName mosi, PinName miso, PinName sclk, PinName ssel)
 * //
 * // TODO1: NUCLEO_F446RE SPI not working; CS and MOSI data looks OK but no SCLK clock pulses.
 * SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk spi1 TARGET_NUCLEO_F446RE: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI_CS); // TARGET_NUCLEO_F446RE: PB_6 Arduino 10-pin header D10
 * //
 * #else
 * SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
 * #endif
 *
 * // example code declare GPIO interface pins
 * // AnalogOut RFB_pin(Px_x_PortName_To_Be_Determined); // Analog Input to MAX5719 device
 * // AnalogOut INV_pin(Px_x_PortName_To_Be_Determined); // Analog Input to MAX5719 device
 * DigitalOut LDACb_pin(D9); // Digital Trigger Input to MAX5719 device
 * // AnalogIn OUT_pin(A0); // Analog Output from MAX5719 device
 * // example code declare device instance
 * MAX5719 g_MAX5719_device(spi, spi_cs, LDACb_pin, MAX5719::MAX5719_IC);
 *
 * // example code main function
 * int main()
 * {
 *     // setup: put your setup code here, to run once
 *
 *     g_MAX5719_device.Init();
 *
 *     while (1)
 *     {
 *         // loop: put your main code here, to run repeatedly
 *
 *         uint32_t code;
 *         //
 *         // example #1
 *         code = 0xfffff; // 100.0% of full scale REF(4.096V) = 4.096V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #2
 *         code = 0xe6665; // 90.0% of full scale REF(4.096V) = 3.686V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #3
 *         code = 0xccccc; // 80.0% of full scale REF(4.096V) = 3.277V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #4
 *         code = 0xb3332; // 70.0% of full scale REF(4.096V) = 2.867V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #5
 *         code = 0x99999; // 60.0% of full scale REF(4.096V) = 2.458V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #6
 *         code = 0x7ffff; // 50.0% of full scale REF(4.096V) = 2.048V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #7
 *         code = 0x66666; // 40.0% of full scale REF(4.096V) = 1.638V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #8
 *         code = 0x4cccc; // 30.0% of full scale REF(4.096V) = 1.229V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #9
 *         code = 0x33333; // 20.0% of full scale REF(4.096V) = 0.819V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #10
 *         code = 0x19999; // 10.0% of full scale REF(4.096V) = 0.410V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #11
 *         code = 0x0000; // 0.0% of full scale REF(4.096V) = 0.000V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #12
 *         code = 0x0000; // 0.0% of full scale REF(4.096V) = 0.000V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #13
 *         code = 0x19999; // 10.0% of full scale REF(4.096V) = 0.410V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #14
 *         code = 0x33333; // 20.0% of full scale REF(4.096V) = 0.819V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #15
 *         code = 0x4cccc; // 30.0% of full scale REF(4.096V) = 1.229V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #16
 *         code = 0x66666; // 40.0% of full scale REF(4.096V) = 1.638V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #17
 *         code = 0x7ffff; // 50.0% of full scale REF(4.096V) = 2.048V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #18
 *         code = 0x99999; // 60.0% of full scale REF(4.096V) = 2.458V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #19
 *         code = 0xb3332; // 70.0% of full scale REF(4.096V) = 2.867V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #20
 *         code = 0xccccc; // 80.0% of full scale REF(4.096V) = 3.277V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #21
 *         code = 0xe6665; // 90.0% of full scale REF(4.096V) = 3.686V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #22
 *         code = 0xfffff; // 100.0% of full scale REF(4.096V) = 4.096V
 *         g_MAX5719_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *
 *         // wait(3.0);
 *     }
 * }
 * @endcode
 */
class MAX5719 {
public:
    /**
     * @brief IC's supported with this driver
     * @details MAX5719
     */
    typedef enum
    {
        MAX5719_IC = 0,
        //MAX5719_IC = 1
    } MAX5719_ic_t;

    /**********************************************************//**
    * @brief Constructor for MAX5719 Class.
    *
    * @details Requires an existing SPI object as well as a DigitalOut object.
    * The DigitalOut object is used for a chip enable signal
    *
    * On Entry:
    *     @param[in] spi - pointer to existing SPI object
    *     @param[in] cs_pin - pointer to a DigitalOut pin object
    *     @param[in] LDACb_pin - pointer to a DigitalOut pin object
    *     @param[in] ic_variant - which type of MAX5719 is used
    *
    * On Exit:
    *
    * @return None
    **************************************************************/
    MAX5719(SPI &spi, DigitalOut &cs_pin, // SPI interface
            // AnalogOut &RFB_pin, // Analog Input to MAX5719 device
            // AnalogOut &INV_pin, // Analog Input to MAX5719 device
            DigitalOut &LDACb_pin, // Digital Trigger Input to MAX5719 device
            // AnalogIn &OUT_pin, // Analog Output from MAX5719 device
            MAX5719_ic_t ic_variant);

    /************************************************************
     * @brief Default destructor for MAX5719 Class.
     *
     * @details Destroys SPI object if owner
     *
     * On Entry:
     *
     * On Exit:
     *
     * @return None
     **************************************************************/
    ~MAX5719();

    /// Function pointer void f(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
    Callback<void(size_t, uint8_t*, uint8_t*)> onSPIprint; //!< optional @ref onSPIprint SPI diagnostic function

    /// set SPI SCLK frequency
    void spi_frequency(int spi_sclk_Hz);

    /// get SPI SCLK frequency
    int get_spi_frequency() const { return m_SPI_SCLK_Hz; }

    /// get SPI mode
    int get_spi_dataMode() const { return m_SPI_dataMode; }

//----------------------------------------
public:

    /// reference voltage, in Volts
    double VRef;

    /// write-only DAC ouptut code
    int32_t DACCode;


//----------------------------------------
// Assert SPI Chip Select
// SPI chip-select for MAX5719
//
    void SPIoutputCS(int isLogicHigh);

//----------------------------------------
// SPI write 24 bits
// SPI interface to MAX5719 shift 24 bits mosiData into MAX5719 DIN
//
    void SPIwrite24bits(int8_t mosiData8_FF0000, int16_t mosiData16_00FFFF);

//----------------------------------------
// Assert MAX5719 LDAC pin : High = inactive, Low = load DAC.
//
    void LDACboutputValue(int isLogicHigh);

private:
    // SPI object
    SPI &m_spi;
    int m_SPI_SCLK_Hz;
    int m_SPI_dataMode;
    int m_SPI_cs_state;

    // Selector pin object
    DigitalOut &m_cs_pin;

// InputPin Name = RFB
// InputPin Description = Feedback Resistor. Connect to external op amp's output in bipolar mode.
// InputPin Function = Analog
//
// InputPin Name = INV
// InputPin Description = Junction of Internal Resistors. Connect to the inverting input of the external op amp in bipolar mode.
// InputPin Function = Analog
//
// InputPin Name = LDAC#
// InputPin Description = LDAC Input. A falling edge updates the internal DAC latch.
// InputPin Function = Trigger
    DigitalOut &m_LDACb_pin;
//
// OutputPin Name = OUT
// OutputPin Description = Analog Voltage Output. High impedance in shutdown. Output voltage is limited to VDD.
// OutputPin Function = Analog
    // AnalogIn &m_OUT_pin;
//

    // Identifies which IC variant is being used
    MAX5719_ic_t m_ic_variant;

public:

    //----------------------------------------
    /// Menu item '!'
    /// Initialize device
    ///
    ///     //
    ///     // Device Testing: DAC commands, verify using on-board ADC inputs
    ///     //
    /// @test group CODE_LOAD // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default)
    /// @test group CODE_LOAD tinyTester.print("VRef = 4.096   MAX5719 20-bit LSB = 0.000004V = 3.90625uV")
    /// @test group CODE_LOAD tinyTester.print("Wire MAX5719 OUT to platform AIN0 for analog loopback tests...")
    /// @test group CODE_LOAD VRef = 4.096
    /// @test group CODE_LOAD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    /// @test group CODE_LOAD tinyTester.settle_time_msec = 500
    /// @test Init()
    /// @test VRef expect 4.096 // Nominal Full-Scale Voltage Reference
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold = 0.050
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x000000 = 0.000V")
    /// @test group CODE_LOAD CODE_LOAD(0x000000) // 0.000V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.000000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x01f400 = 0.500V")
    /// @test group CODE_LOAD CODE_LOAD(0x01f400) // 0.500V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.500000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x03e800 = 1.000V")
    /// @test group CODE_LOAD CODE_LOAD(0x03e800) // 1.000V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.000000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.075
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x05dc00 = 1.500V")
    /// @test group CODE_LOAD CODE_LOAD(0x05dc00) // 1.500V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.500000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.100
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x07d000 = 2.000V")
    /// @test group CODE_LOAD CODE_LOAD(0x07d000) // 2.000V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.000000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.150
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x09c400 = 2.500V")
    /// @test group CODE_LOAD CODE_LOAD(0x09c400) // 2.500V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.500000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.200
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x0bb800 = 3.000V")
    /// @test group CODE_LOAD CODE_LOAD(0x0bb800) // 3.000V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(3.000000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.250
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x0dac00 = 3.500V")
    /// @test group CODE_LOAD CODE_LOAD(0x0dac00) // 3.500V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(3.500000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.500
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x0fa000 = 4.000V")
    /// @test group CODE_LOAD CODE_LOAD(0x0fa000) // 4.000V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(4.000000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.750
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x0fffff = 4.095V")
    /// @test group CODE_LOAD CODE_LOAD(0x0fffff) // 4.095V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(4.095000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    /// @test group CODE_LOAD tinyTester.err_threshold =  0.200
    ///     //
    /// @test group CODE_LOAD tinyTester.print("0x080000  // 2.048V")
    /// @test group CODE_LOAD CODE_LOAD(0x080000) // 2.048V
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.048000)
    /// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    ///     //
    /// @test group CODE_LOAD_2V5 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)
    /// @test group CODE_LOAD_2V5 tinyTester.err_threshold =  0.150
    /// @test group CODE_LOAD_2V5 tinyTester.print("0x09c400 = 2.500V")
    /// @test group CODE_LOAD_2V5 CODE_LOAD(0x09c400) // 2.500V
    /// @test group CODE_LOAD_2V5 tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD_2V5 tinyTester.AnalogIn0_Read_Expect_voltageV(2.500000)
    /// @test group CODE_LOAD_2V5 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    ///     //
    /// @test group CODE_LOAD_3V0 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)
    /// @test group CODE_LOAD_3V0 tinyTester.err_threshold =  0.200
    /// @test group CODE_LOAD_3V0 tinyTester.print("0x0bb800 = 3.000V")
    /// @test group CODE_LOAD_3V0 CODE_LOAD(0x0bb800) // 3.000V
    /// @test group CODE_LOAD_3V0 tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD_3V0 tinyTester.AnalogIn0_Read_Expect_voltageV(3.000000)
    /// @test group CODE_LOAD_3V0 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    ///     //
    /// @test group CODE_LOAD_4V1 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)
    /// @test group CODE_LOAD_4V1 tinyTester.err_threshold =  0.750
    /// @test group CODE_LOAD_4V1 tinyTester.print("0x0fffff = 4.095V")
    /// @test group CODE_LOAD_4V1 CODE_LOAD(0x0fffff) // 4.095V
    /// @test group CODE_LOAD_4V1 tinyTester.Wait_Output_Settling()
    /// @test group CODE_LOAD_4V1 tinyTester.AnalogIn0_Read_Expect_voltageV(4.095000)
    /// @test group CODE_LOAD_4V1 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
    ///     //
    ///
    ///
    void Init(void);

    //----------------------------------------
    /// Return the DAC register value corresponding to physical voltage.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre g_MAX5719_device.VRef = Voltage of REF input, in Volts
    /// @param[in] voltage = physical voltage in Volts
    /// @return raw 20-bit MAX5719 code (right justified).
    ///
    /// @test group DACCodeOfVoltage // Verify function DACCodeOfVoltage (enabled by default) (no run on button)
    /// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group DACCodeOfVoltage tinyTester.print("VRef = 4.096   MAX5719 20-bit LSB = 0.000004V = 3.90625uV")
    /// @test group DACCodeOfVoltage VRef = 4.096
    /// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = 0.000000V to 4.096000V precision 0.100000V step 0.500000V")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000000) expect 0x000000  // 0.000V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.500000) expect 0x01f400  // 0.500V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.000000) expect 0x03e800  // 1.000V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.500000) expect 0x05dc00  // 1.500V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.000000) expect 0x07d000  // 2.000V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.500000) expect 0x09c400  // 2.500V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.000000) expect 0x0bb800  // 3.000V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.500000) expect 0x0dac00  // 3.500V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.000000) expect 0x0fa000  // 4.000V
    /// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = -0.010000V to 0.100000V precision 0.010000V step 0.010000V")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.010000) expect 0x000000  // -0.010V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000000) expect 0x000000  // 0.000V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.010000) expect 0x000a00  // 0.010V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.020000) expect 0x001400  // 0.020V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.030000) expect 0x001e00  // 0.030V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.040000) expect 0x002800  // 0.040V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.050000) expect 0x003200  // 0.050V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.060000) expect 0x003c00  // 0.060V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.070000) expect 0x004600  // 0.070V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.080000) expect 0x005000  // 0.080V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.090000) expect 0x005a00  // 0.090V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.100000) expect 0x006400  // 0.100V
    /// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = 2.047900V to 2.048100V precision 0.000010V step 0.000010V")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047890) expect 0x07ffe4  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047900) expect 0x07ffe6  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047910) expect 0x07ffe9  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047920) expect 0x07ffec  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047930) expect 0x07ffee  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047940) expect 0x07fff1  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047950) expect 0x07fff3  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047960) expect 0x07fff6  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047970) expect 0x07fff8  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047980) expect 0x07fffb  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047990) expect 0x07fffd  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048000) expect 0x080000  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048010) expect 0x080003  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048020) expect 0x080005  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048030) expect 0x080008  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048040) expect 0x08000a  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048050) expect 0x08000d  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048060) expect 0x08000f  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048070) expect 0x080012  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048080) expect 0x080014  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048090) expect 0x080017  // 2.048V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048100) expect 0x08001a  // 2.048V
    /// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = 3.996000V to 4.106000V precision 0.010000V step 0.010000V")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.990000) expect 0x0f9600  // 3.990V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.000000) expect 0x0fa000  // 4.000V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.010000) expect 0x0faa00  // 4.010V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.020000) expect 0x0fb400  // 4.020V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.030000) expect 0x0fbe00  // 4.030V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.040000) expect 0x0fc800  // 4.040V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.050000) expect 0x0fd200  // 4.050V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.060000) expect 0x0fdc00  // 4.060V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.070000) expect 0x0fe600  // 4.070V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.080000) expect 0x0ff000  // 4.080V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.090000) expect 0x0ffa00  // 4.090V
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.100000) expect 0x0fffff  // 4.100V
    /// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 4.096000V LSBradius = 3LSB")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095988) expect 0x0ffffd  // 4.096V + -3.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095990) expect 0x0ffffd  // 4.096V + -2.5LSB  0x0ffffd not 0x0ffffe
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095992) expect 0x0ffffe  // 4.096V + -2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095994) expect 0x0ffffe  // 4.096V + -1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095996) expect 0x0fffff  // 4.096V + -1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095998) expect 0x0fffff  // 4.096V + -0.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096000) expect 0x0fffff  // 4.096V + 0.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096002) expect 0x0fffff  // 4.096V + 0.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096004) expect 0x0fffff  // 4.096V + 1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096006) expect 0x0fffff  // 4.096V + 1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096008) expect 0x0fffff  // 4.096V + 2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096010) expect 0x0fffff  // 4.096V + 2.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096012) expect 0x0fffff  // 4.096V + 3.0LSB
    /// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 3.072000V LSBradius = 3LSB")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071988) expect 0x0bfffd  // 3.072V + -3.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071990) expect 0x0bfffd  // 3.072V + -2.5LSB  0x0bfffd not 0x0bfffe
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071992) expect 0x0bfffe  // 3.072V + -2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071994) expect 0x0bfffe  // 3.072V + -1.5LSB  0x0bfffe not 0x0bffff
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071996) expect 0x0bffff  // 3.072V + -1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071998) expect 0x0bffff  // 3.072V + -0.5LSB  0x0bffff not 0x0c0000
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072000) expect 0x0c0000  // 3.072V + 0.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072002) expect 0x0c0001  // 3.072V + 0.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072004) expect 0x0c0001  // 3.072V + 1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072006) expect 0x0c0002  // 3.072V + 1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072008) expect 0x0c0002  // 3.072V + 2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072010) expect 0x0c0003  // 3.072V + 2.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072012) expect 0x0c0003  // 3.072V + 3.0LSB
    /// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 2.048000V LSBradius = 3LSB")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047988) expect 0x07fffd  // 2.048V + -3.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047990) expect 0x07fffd  // 2.048V + -2.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047992) expect 0x07fffe  // 2.048V + -2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047994) expect 0x07fffe  // 2.048V + -1.5LSB  0x07fffe not 0x07ffff
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047996) expect 0x07ffff  // 2.048V + -1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047998) expect 0x07ffff  // 2.048V + -0.5LSB  0x07ffff not 0x080000
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048000) expect 0x080000  // 2.048V + 0.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048002) expect 0x080001  // 2.048V + 0.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048004) expect 0x080001  // 2.048V + 1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048006) expect 0x080002  // 2.048V + 1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048008) expect 0x080002  // 2.048V + 2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048010) expect 0x080003  // 2.048V + 2.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048012) expect 0x080003  // 2.048V + 3.0LSB
    /// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 1.024000V LSBradius = 3LSB")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023988) expect 0x03fffd  // 1.024V + -3.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023990) expect 0x03fffd  // 1.024V + -2.5LSB  0x03fffd not 0x03fffe
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023992) expect 0x03fffe  // 1.024V + -2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023994) expect 0x03fffe  // 1.024V + -1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023996) expect 0x03ffff  // 1.024V + -1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023998) expect 0x03ffff  // 1.024V + -0.5LSB  0x03ffff not 0x040000
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024000) expect 0x040000  // 1.024V + 0.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024002) expect 0x040001  // 1.024V + 0.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024004) expect 0x040001  // 1.024V + 1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024006) expect 0x040002  // 1.024V + 1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024008) expect 0x040002  // 1.024V + 2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024010) expect 0x040003  // 1.024V + 2.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024012) expect 0x040003  // 1.024V + 3.0LSB
    /// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 0.000000V LSBradius = 3LSB")
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000012) expect 0x000000  // 0.000V + -3.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000010) expect 0x000000  // 0.000V + -2.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000008) expect 0x000000  // 0.000V + -2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000006) expect 0x000000  // 0.000V + -1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000004) expect 0x000000  // 0.000V + -1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000002) expect 0x000000  // 0.000V + -0.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000000) expect 0x000000  // 0.000V + 0.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000002) expect 0x000001  // 0.000V + 0.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000004) expect 0x000001  // 0.000V + 1.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000006) expect 0x000002  // 0.000V + 1.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000008) expect 0x000002  // 0.000V + 2.0LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000010) expect 0x000003  // 0.000V + 2.5LSB
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000012) expect 0x000003  // 0.000V + 3.0LSB
    ///
    /// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    ///
    uint32_t DACCodeOfVoltage(double voltageV);

    //----------------------------------------
    /// Menu item 'A'
    /// CODE
    ///
    /// Load input register, but DAC registers are not updated until LOAD.
    /// @return 1 on success; 0 on failure
    uint8_t CODE(uint32_t dacCodeLsbs);

    //----------------------------------------
    /// Menu item 'C'
    /// CODE_LOAD
    ///
    /// Load input register; DAC registers are updated.
    /// @return 1 on success; 0 on failure
    uint8_t CODE_LOAD(uint32_t dacCodeLsbs);

    //----------------------------------------
    /// Menu item 'B'
    /// LOAD
    ///
    /// Update DAC registers from input registers.
    /// @return 1 on success; 0 on failure
    uint8_t LOAD(void);

}; // end of class MAX5719

#endif // __MAX5719_H__

// End of file
