﻿// /*******************************************************************************
// * Copyright (C) 2021 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX5719.cpp
// *********************************************************************
// Device Driver file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example

#include "MAX5719.h"

// Device Name = MAX5719
// Device Description = 20-Bit, low glitch energy 0.05nV-sec, Voltage-Output DAC with SPI Interface
// Device DeviceBriefDescription = 20-bit 0.05nV-sec DAC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX5719AGSD+
// Device RegValue_Width = DataWidth16bit_HL
//
// DAC NumChannels = 1
// DAC ResolutionBits = 20
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 50
// SPI SCLKMinMHz = 0
//
// InputPin Name = RFB
// InputPin Description = Feedback Resistor. Connect to external op amp's output in bipolar mode.
// InputPin Function = Analog
//
// InputPin Name = INV
// InputPin Description = Junction of Internal Resistors. Connect to the inverting input of the external op amp in bipolar mode.
// InputPin Function = Analog
//
// InputPin Name = LDAC#
// InputPin Description = LDAC Input. A falling edge updates the internal DAC latch.
// InputPin Function = Trigger
//
// OutputPin Name = OUT
// OutputPin Description = Analog Voltage Output. High impedance in shutdown. Output voltage is limited to VDD.
// OutputPin Function = Analog
//
// SupplyPin Name = VDD
// SupplyPin Description = Positive Supply. Bypass to AGND with a 4.7uF capacitor in parallel with a 0.1uF capacitor.
// SupplyPin VinMax = 4.50
// SupplyPin VinMin = 5.50
// SupplyPin Function = Analog
//
// SupplyPin Name = REFF
// SupplyPin Description = Reference Input (force). Connect an external +4.096V reference.
// SupplyPin VinMax = VDD
// SupplyPin VinMin = 4
// SupplyPin Function = Analog
//
// SupplyPin Name = REFS
// SupplyPin Description = Reference Input (sense). Connect an external +4.096V reference.
// SupplyPin VinMax = VDD
// SupplyPin VinMin = 4
// SupplyPin Function = Analog
//
// SupplyPin Name = DGND
// SupplyPin Description = Digital Ground.
// SupplyPin VinMax = 0
// SupplyPin VinMin = 0
// SupplyPin Function = Analog
//
// SupplyPin Name = AGNDF
// SupplyPin Description = Analog Ground (force).
// SupplyPin VinMax = 0
// SupplyPin VinMin = 0
// SupplyPin Function = Analog
//
// SupplyPin Name = AGNDS
// SupplyPin Description = Analog Ground (sense).
// SupplyPin VinMax = 0
// SupplyPin VinMin = 0
// SupplyPin Function = Analog
//

MAX5719::MAX5719(SPI &spi, DigitalOut &cs_pin, // SPI interface
                 // AnalogOut &RFB_pin, // Analog Input to MAX5719 device
                 // AnalogOut &INV_pin, // Analog Input to MAX5719 device
                 DigitalOut &LDACb_pin, // Digital Trigger Input to MAX5719 device
                 // AnalogIn &OUT_pin, // Analog Output from MAX5719 device
                 MAX5719_ic_t ic_variant)
    : m_spi(spi), m_cs_pin(cs_pin), // SPI interface
    // m_RFB_pin(RFB_pin), // Analog Input to MAX5719 device
    // m_INV_pin(INV_pin), // Analog Input to MAX5719 device
    m_LDACb_pin(LDACb_pin), // Digital Trigger Input to MAX5719 device
    // m_OUT_pin(OUT_pin), // Analog Output from MAX5719 device
    m_ic_variant(ic_variant)
{
    // SPI CS = ActiveLow
    // SPI FrameStart = CS
    m_SPI_cs_state = 1;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }

    // SPI CPOL = 0
    // SPI CPHA = 0
    // SPI MOSI and MISO Data are both stable on Rising edge of SCLK
    // SPI SCLK Idle Low
    m_SPI_dataMode = 0; //SPI_MODE0; // CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
    m_spi.format(8,m_SPI_dataMode);         // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0

    // SPI SCLKMaxMHz = 50
    // SPI SCLKMinMHz = 0
    //#define SPI_SCLK_Hz 48000000 // 48MHz
    //#define SPI_SCLK_Hz 24000000 // 24MHz
    //#define SPI_SCLK_Hz 12000000 // 12MHz
    //#define SPI_SCLK_Hz 6000000 // 6MHz
    //#define SPI_SCLK_Hz 4000000 // 4MHz
    //#define SPI_SCLK_Hz 2000000 // 2MHz
    //#define SPI_SCLK_Hz 1000000 // 1MHz
    m_SPI_SCLK_Hz = 12000000; // platform limit 12MHz; MAX5719 limit is 50MHz
    m_spi.frequency(m_SPI_SCLK_Hz);

    //
    // RFB Analog Input to MAX5719 device
    //
    // INV Analog Input to MAX5719 device
    //
    // LDACb Trigger Input to MAX5719 device
    m_LDACb_pin = 1; // output logic high -- initial value in constructor
    //
    // OUT Analog Output from device
}

MAX5719::~MAX5719()
{
    // do nothing
}

/// set SPI SCLK frequency
void MAX5719::spi_frequency(int spi_sclk_Hz)
{
    m_SPI_SCLK_Hz = spi_sclk_Hz;
    m_spi.frequency(m_SPI_SCLK_Hz);
}

// Assert SPI Chip Select
// SPI chip-select for MAX5719
//
inline void MAX5719::SPIoutputCS(int isLogicHigh)
{
    m_SPI_cs_state = isLogicHigh;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }
}

// SPI write 24 bits
// SPI interface to MAX5719 shift 24 bits mosiData into MAX5719 DIN
//
void MAX5719::SPIwrite24bits(int8_t mosiData8_FF0000, int16_t mosiData16_00FFFF)
{
    size_t byteCount = 3;
    static char mosiData[3];
    static char misoData[3];
    mosiData[0] = mosiData8_FF0000;
    mosiData[1] = (char)((mosiData16_00FFFF >> 8) & 0xFF); // MSByte
    mosiData[2] = (char)((mosiData16_00FFFF >> 0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ SPI.transfer(mosiData8_FF0000);
    //~ SPI.transfer(mosiData16_00FF00);
    //~ SPI.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    // Optional Diagnostic function to print SPI transactions
    if (onSPIprint)
    {
        onSPIprint(byteCount, (uint8_t*)mosiData, (uint8_t*)misoData);
    }
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    //
    // int misoData16 = (misoData16_FF00 << 8) | misoData16_00FF;
    // return misoData16;
}

// Assert MAX5719 LDAC pin : High = inactive, Low = load DAC.
//
void MAX5719::LDACboutputValue(int isLogicHigh)
{
    // m_LDACb_pin.output(); // only applicable to DigitalInOut
    m_LDACb_pin = isLogicHigh;
}

//----------------------------------------
// Menu item '!'
// Initialize device
//
//     //
//     // Device Testing: DAC commands, verify using on-board ADC inputs
//     //
// @test group CODE_LOAD // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default)
// @test group CODE_LOAD tinyTester.print("VRef = 4.096   MAX5719 20-bit LSB = 0.000004V = 3.90625uV")
// @test group CODE_LOAD tinyTester.print("Wire MAX5719 OUT to platform AIN0 for analog loopback tests...")
// @test group CODE_LOAD VRef = 4.096
// @test group CODE_LOAD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
// @test group CODE_LOAD tinyTester.settle_time_msec = 500
// @test Init()
// @test VRef expect 4.096 // Nominal Full-Scale Voltage Reference
//     //
// @test group CODE_LOAD tinyTester.err_threshold = 0.050
//     //
// @test group CODE_LOAD tinyTester.print("0x000000 = 0.000V")
// @test group CODE_LOAD CODE_LOAD(0x000000) // 0.000V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.000000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.print("0x01f400 = 0.500V")
// @test group CODE_LOAD CODE_LOAD(0x01f400) // 0.500V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.500000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.print("0x03e800 = 1.000V")
// @test group CODE_LOAD CODE_LOAD(0x03e800) // 1.000V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.000000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.075
//     //
// @test group CODE_LOAD tinyTester.print("0x05dc00 = 1.500V")
// @test group CODE_LOAD CODE_LOAD(0x05dc00) // 1.500V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.500000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.100
//     //
// @test group CODE_LOAD tinyTester.print("0x07d000 = 2.000V")
// @test group CODE_LOAD CODE_LOAD(0x07d000) // 2.000V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.000000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.150
//     //
// @test group CODE_LOAD tinyTester.print("0x09c400 = 2.500V")
// @test group CODE_LOAD CODE_LOAD(0x09c400) // 2.500V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.500000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.200
//     //
// @test group CODE_LOAD tinyTester.print("0x0bb800 = 3.000V")
// @test group CODE_LOAD CODE_LOAD(0x0bb800) // 3.000V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(3.000000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.250
//     //
// @test group CODE_LOAD tinyTester.print("0x0dac00 = 3.500V")
// @test group CODE_LOAD CODE_LOAD(0x0dac00) // 3.500V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(3.500000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.500
//     //
// @test group CODE_LOAD tinyTester.print("0x0fa000 = 4.000V")
// @test group CODE_LOAD CODE_LOAD(0x0fa000) // 4.000V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(4.000000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.750
//     //
// @test group CODE_LOAD tinyTester.print("0x0fffff = 4.095V")
// @test group CODE_LOAD CODE_LOAD(0x0fffff) // 4.095V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(4.095000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
// @test group CODE_LOAD tinyTester.err_threshold =  0.200
//     //
// @test group CODE_LOAD tinyTester.print("0x080000  // 2.048V")
// @test group CODE_LOAD CODE_LOAD(0x080000) // 2.048V
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.048000)
// @test group CODE_LOAD tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
//     //
// @test group CODE_LOAD_2V5 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)
// @test group CODE_LOAD_2V5 tinyTester.err_threshold =  0.150
// @test group CODE_LOAD_2V5 tinyTester.print("0x09c400 = 2.500V")
// @test group CODE_LOAD_2V5 CODE_LOAD(0x09c400) // 2.500V
// @test group CODE_LOAD_2V5 tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD_2V5 tinyTester.AnalogIn0_Read_Expect_voltageV(2.500000)
// @test group CODE_LOAD_2V5 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
//     //
// @test group CODE_LOAD_3V0 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)
// @test group CODE_LOAD_3V0 tinyTester.err_threshold =  0.200
// @test group CODE_LOAD_3V0 tinyTester.print("0x0bb800 = 3.000V")
// @test group CODE_LOAD_3V0 CODE_LOAD(0x0bb800) // 3.000V
// @test group CODE_LOAD_3V0 tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD_3V0 tinyTester.AnalogIn0_Read_Expect_voltageV(3.000000)
// @test group CODE_LOAD_3V0 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
//     //
// @test group CODE_LOAD_4V1 // Verify function CODE_LOAD vs platform AIN0 analog input (enabled by default) (no run on button)
// @test group CODE_LOAD_4V1 tinyTester.err_threshold =  0.750
// @test group CODE_LOAD_4V1 tinyTester.print("0x0fffff = 4.095V")
// @test group CODE_LOAD_4V1 CODE_LOAD(0x0fffff) // 4.095V
// @test group CODE_LOAD_4V1 tinyTester.Wait_Output_Settling()
// @test group CODE_LOAD_4V1 tinyTester.AnalogIn0_Read_Expect_voltageV(4.095000)
// @test group CODE_LOAD_4V1 tinyTester.AnalogIn1_Read_Report_voltageV(); // remove unwanted loading on AIN0
//     //
//
//
void MAX5719::Init(void)
{
    
    //----------------------------------------
    // Nominal Full-Scale Voltage Reference
    VRef = 4.096;
}

//----------------------------------------
// Return the DAC register value corresponding to physical voltage.
// Does not perform any offset or gain correction.
//
// @pre VRef = Voltage of REF input, in Volts
// @param[in] voltage = physical voltage in Volts
// @return raw 20-bit MAX5719 code (right justified).
//
// @test group DACCodeOfVoltage // Verify function DACCodeOfVoltage (enabled by default) (no run on button)
// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group DACCodeOfVoltage tinyTester.print("VRef = 4.096   MAX5719 20-bit LSB = 0.000004V = 3.90625uV")
// @test group DACCodeOfVoltage VRef = 4.096
// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = 0.000000V to 4.096000V precision 0.100000V step 0.500000V")
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000000) expect 0x000000  // 0.000V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.500000) expect 0x01f400  // 0.500V
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.000000) expect 0x03e800  // 1.000V
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.500000) expect 0x05dc00  // 1.500V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.000000) expect 0x07d000  // 2.000V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.500000) expect 0x09c400  // 2.500V
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.000000) expect 0x0bb800  // 3.000V
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.500000) expect 0x0dac00  // 3.500V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.000000) expect 0x0fa000  // 4.000V
// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = -0.010000V to 0.100000V precision 0.010000V step 0.010000V")
// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.010000) expect 0x000000  // -0.010V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000000) expect 0x000000  // 0.000V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.010000) expect 0x000a00  // 0.010V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.020000) expect 0x001400  // 0.020V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.030000) expect 0x001e00  // 0.030V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.040000) expect 0x002800  // 0.040V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.050000) expect 0x003200  // 0.050V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.060000) expect 0x003c00  // 0.060V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.070000) expect 0x004600  // 0.070V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.080000) expect 0x005000  // 0.080V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.090000) expect 0x005a00  // 0.090V
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.100000) expect 0x006400  // 0.100V
// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = 2.047900V to 2.048100V precision 0.000010V step 0.000010V")
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047890) expect 0x07ffe4  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047900) expect 0x07ffe6  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047910) expect 0x07ffe9  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047920) expect 0x07ffec  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047930) expect 0x07ffee  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047940) expect 0x07fff1  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047950) expect 0x07fff3  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047960) expect 0x07fff6  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047970) expect 0x07fff8  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047980) expect 0x07fffb  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047990) expect 0x07fffd  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048000) expect 0x080000  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048010) expect 0x080003  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048020) expect 0x080005  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048030) expect 0x080008  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048040) expect 0x08000a  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048050) expect 0x08000d  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048060) expect 0x08000f  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048070) expect 0x080012  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048080) expect 0x080014  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048090) expect 0x080017  // 2.048V
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048100) expect 0x08001a  // 2.048V
// @test group DACCodeOfVoltage tinyTester.print("test_voltage_sweep V = 3.996000V to 4.106000V precision 0.010000V step 0.010000V")
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.990000) expect 0x0f9600  // 3.990V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.000000) expect 0x0fa000  // 4.000V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.010000) expect 0x0faa00  // 4.010V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.020000) expect 0x0fb400  // 4.020V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.030000) expect 0x0fbe00  // 4.030V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.040000) expect 0x0fc800  // 4.040V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.050000) expect 0x0fd200  // 4.050V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.060000) expect 0x0fdc00  // 4.060V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.070000) expect 0x0fe600  // 4.070V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.080000) expect 0x0ff000  // 4.080V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.090000) expect 0x0ffa00  // 4.090V
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.100000) expect 0x0fffff  // 4.100V
// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 4.096000V LSBradius = 3LSB")
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095988) expect 0x0ffffd  // 4.096V + -3.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095990) expect 0x0ffffd  // 4.096V + -2.5LSB  0x0ffffd not 0x0ffffe
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095992) expect 0x0ffffe  // 4.096V + -2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095994) expect 0x0ffffe  // 4.096V + -1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095996) expect 0x0fffff  // 4.096V + -1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.095998) expect 0x0fffff  // 4.096V + -0.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096000) expect 0x0fffff  // 4.096V + 0.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096002) expect 0x0fffff  // 4.096V + 0.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096004) expect 0x0fffff  // 4.096V + 1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096006) expect 0x0fffff  // 4.096V + 1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096008) expect 0x0fffff  // 4.096V + 2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096010) expect 0x0fffff  // 4.096V + 2.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(4.096012) expect 0x0fffff  // 4.096V + 3.0LSB
// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 3.072000V LSBradius = 3LSB")
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071988) expect 0x0bfffd  // 3.072V + -3.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071990) expect 0x0bfffd  // 3.072V + -2.5LSB  0x0bfffd not 0x0bfffe
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071992) expect 0x0bfffe  // 3.072V + -2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071994) expect 0x0bfffe  // 3.072V + -1.5LSB  0x0bfffe not 0x0bffff
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071996) expect 0x0bffff  // 3.072V + -1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.071998) expect 0x0bffff  // 3.072V + -0.5LSB  0x0bffff not 0x0c0000
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072000) expect 0x0c0000  // 3.072V + 0.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072002) expect 0x0c0001  // 3.072V + 0.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072004) expect 0x0c0001  // 3.072V + 1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072006) expect 0x0c0002  // 3.072V + 1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072008) expect 0x0c0002  // 3.072V + 2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072010) expect 0x0c0003  // 3.072V + 2.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(3.072012) expect 0x0c0003  // 3.072V + 3.0LSB
// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 2.048000V LSBradius = 3LSB")
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047988) expect 0x07fffd  // 2.048V + -3.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047990) expect 0x07fffd  // 2.048V + -2.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047992) expect 0x07fffe  // 2.048V + -2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047994) expect 0x07fffe  // 2.048V + -1.5LSB  0x07fffe not 0x07ffff
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047996) expect 0x07ffff  // 2.048V + -1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.047998) expect 0x07ffff  // 2.048V + -0.5LSB  0x07ffff not 0x080000
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048000) expect 0x080000  // 2.048V + 0.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048002) expect 0x080001  // 2.048V + 0.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048004) expect 0x080001  // 2.048V + 1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048006) expect 0x080002  // 2.048V + 1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048008) expect 0x080002  // 2.048V + 2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048010) expect 0x080003  // 2.048V + 2.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.048012) expect 0x080003  // 2.048V + 3.0LSB
// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 1.024000V LSBradius = 3LSB")
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023988) expect 0x03fffd  // 1.024V + -3.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023990) expect 0x03fffd  // 1.024V + -2.5LSB  0x03fffd not 0x03fffe
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023992) expect 0x03fffe  // 1.024V + -2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023994) expect 0x03fffe  // 1.024V + -1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023996) expect 0x03ffff  // 1.024V + -1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.023998) expect 0x03ffff  // 1.024V + -0.5LSB  0x03ffff not 0x040000
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024000) expect 0x040000  // 1.024V + 0.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024002) expect 0x040001  // 1.024V + 0.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024004) expect 0x040001  // 1.024V + 1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024006) expect 0x040002  // 1.024V + 1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024008) expect 0x040002  // 1.024V + 2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024010) expect 0x040003  // 1.024V + 2.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.024012) expect 0x040003  // 1.024V + 3.0LSB
// @test group DACCodeOfVoltage tinyTester.print("test_lsb_sweep V = 0.000000V LSBradius = 3LSB")
// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000012) expect 0x000000  // 0.000V + -3.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000010) expect 0x000000  // 0.000V + -2.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000008) expect 0x000000  // 0.000V + -2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000006) expect 0x000000  // 0.000V + -1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000004) expect 0x000000  // 0.000V + -1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(-0.000002) expect 0x000000  // 0.000V + -0.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000000) expect 0x000000  // 0.000V + 0.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000002) expect 0x000001  // 0.000V + 0.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000004) expect 0x000001  // 0.000V + 1.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000006) expect 0x000002  // 0.000V + 1.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000008) expect 0x000002  // 0.000V + 2.0LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000010) expect 0x000003  // 0.000V + 2.5LSB
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000012) expect 0x000003  // 0.000V + 3.0LSB
//
// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
//
uint32_t MAX5719::DACCodeOfVoltage(double voltageV)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    const double MaxScaleVoltage = VRef; // voltage of maximum code 0xfffff
    const double MinScaleVoltage = 0.0; // voltage of minimum code 0x000
    const uint32_t FULL_SCALE_CODE_20BIT = 0xfffff;
    const uint32_t MaxCode = FULL_SCALE_CODE_20BIT;
    const uint32_t MinCode = 0x000;
    double codeFraction = (voltageV - MinScaleVoltage) / (MaxScaleVoltage - MinScaleVoltage);
    double dacRegValueIdeal = ((codeFraction * (double)(MaxCode - MinCode + 1)) + MinCode + 0.5);
    uint32_t dacRegValue = (uint32_t)dacRegValueIdeal;
    if (dacRegValueIdeal > MaxCode)
    {
        dacRegValue = MaxCode;
    } else if (dacRegValueIdeal < MinCode)
    {
        dacRegValue = MinCode;
    }
    return dacRegValue;
}

//----------------------------------------
// Menu item 'A'
// CODE
//
// Load input register, but DAC registers are not updated until LOAD.
// @return 1 on success; 0 on failure
uint8_t MAX5719::CODE(uint32_t dacCodeLsbs)
{
    
    //----------------------------------------
    // SPI write 20-bit dacCodeLsbs in mosiData24
    SPIoutputCS(0);
    SPIwrite24bits(((dacCodeLsbs << 4) >> 16), ((dacCodeLsbs << 4) & 0xFFFF));  // 20-bit dacCodeLsbs in mosiData24
    SPIoutputCS(1);
    
    //----------------------------------------
    // write-only DAC ouptut code
    DACCode = dacCodeLsbs;
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'C'
// CODE_LOAD
//
// Load input register; DAC registers are updated.
// @return 1 on success; 0 on failure
uint8_t MAX5719::CODE_LOAD(uint32_t dacCodeLsbs)
{
    
    //----------------------------------------
    // SPI write 20-bit dacCodeLsbs in mosiData24
    SPIoutputCS(0);
    SPIwrite24bits(((dacCodeLsbs << 4) >> 16), ((dacCodeLsbs << 4) & 0xFFFF));  // 20-bit dacCodeLsbs in mosiData24
    SPIoutputCS(1);
    
    //----------------------------------------
    // write-only DAC ouptut code
    DACCode = dacCodeLsbs;
    
    //----------------------------------------
    // call low-level GPIO function
    LDACboutputValue(0); // LDAC# Active
    
    //----------------------------------------
    // call low-level GPIO function
    LDACboutputValue(1); // LDAC# Inactive
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'B'
// LOAD
//
// Update DAC registers from input registers.
// @return 1 on success; 0 on failure
uint8_t MAX5719::LOAD(void)
{
    
    //----------------------------------------
    // call low-level GPIO function
    LDACboutputValue(0); // LDAC# Active
    
    //----------------------------------------
    // call low-level GPIO function
    LDACboutputValue(1); // LDAC# Inactive
    
    //----------------------------------------
    // success
    return 1;
}


// End of file
