﻿// /*******************************************************************************
// * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */

#include "mbed.h"
#include "MAX5715.h"
#include "CmdLine.h"

//--------------------------------------------------
// tolerate AT commands, which may be sent during probe, such as:
//  AT
//  AT+CGMI      -- request manufacturer identification AT+CMGI=?
//  AT+CGMM      -- request manufacturer model
//  AT%IPSYS?
//  ATE0         -- echo disable
//  ATV1         -- verbose result codes OK | ERROR | NO CARRIER
//  AT+CMEE=1
//  ATX4
//  AT&C1
//  ATE0
//  AT+CMEE=1
//  AT+GCAP
//  ATI
//  AT+CPIN?
//  AT+CGMM
#ifndef IGNORE_AT_COMMANDS
#define IGNORE_AT_COMMANDS 1
#endif

extern MAX5715 g_MAX5715_device; // defined in main.cpp

bool MAX5715_menu_onEOLcommandParser(CmdLine & cmdLine)
{
    switch (cmdLine[0])
    {
        case '0':
        {
            // recommended for hex command codes 00..0F
            // TODO: cmdLine.serial().printf("\r\n 0 ch=? code=? -- CODEn");
            // Menu 0 ch=? code=?) CODEn
            // MAX5715_CODEn(uint8_t channel, uint16_t dacCodeLsbs);
            // VERIFY: parse strCommandArgs for additional arguments including key=value pairs
            // TODO: parse command arguments ~ parse_strCommandArgs(strCommandArgs);
            uint16_t ch = g_MAX5715_device.channelNumber_0_3;
            if (cmdLine.parse_uint16_dec("ch", ch))
            {
            }
            uint16_t code = g_MAX5715_device.CODE[ch];
            if (cmdLine.parse_uint16_dec("code", code))
            {
            }
            cmdLine.serial().printf("CODEn ch=%d code=%d", ch, code);
            g_MAX5715_device.CODEn(ch, code);
            return true; // command was handled by MAX5715
        }
        break;
        case '1':
        {
            // recommended for hex command codes 10..1F
            // TODO: cmdLine.serial().printf("\r\n 1 ch=? -- LOADn");
            // TODO: parse command arguments ~ parse_strCommandArgs(strCommandArgs);
            uint16_t ch = g_MAX5715_device.channelNumber_0_3;
            if (cmdLine.parse_uint16_dec("ch", ch))
            {
            }
            cmdLine.serial().printf("LOADn ch=%d", ch);
            g_MAX5715_device.LOADn(ch);
            return true; // command was handled by MAX5715
        }
        break;
        case '2':
        {
            // recommended for hex command codes 20..2F
            // TODO: cmdLine.serial().printf("\r\n 2 ch=? code=? -- CODEnLOADall");
            // TODO: parse command arguments ~ parse_strCommandArgs(strCommandArgs);
            uint16_t ch = g_MAX5715_device.channelNumber_0_3;
            if (cmdLine.parse_uint16_dec("ch", ch))
            {
            }
            uint16_t code = g_MAX5715_device.CODE[ch];
            if (cmdLine.parse_uint16_dec("code", code))
            {
            }
            cmdLine.serial().printf("CODEnLOADall ch=%d code=%d", ch, code);
            g_MAX5715_device.CODEnLOADall(ch, code);
            return true; // command was handled by MAX5715
        }
        break;
        case '3':
        {
            // recommended for hex command codes 30..3F
            // TODO: cmdLine.serial().printf("\r\n 3 ch=? code=? -- CODEnLOADn");
            // TODO: parse command arguments ~ parse_strCommandArgs(strCommandArgs);
            uint16_t ch = g_MAX5715_device.channelNumber_0_3;
            uint16_t code;
            if (cmdLine.parse_uint16_dec("ch", ch))
            {
            }
            if (cmdLine.parse_uint16_dec("code", code))
            {
            }
            cmdLine.serial().printf("CODEnLOADn ch=%d code=%d", ch, code);
            g_MAX5715_device.CODEnLOADn(ch, code);
            return true; // command was handled by MAX5715
        }
        break;
        case '4':
        {
            // recommended for hex command codes 40..4F
            switch (cmdLine[1])
            {
                case '0':
                {
                    // cmdLine.serial().printf("\r\n 40 ch=? -- POWERn_Normal");
                    cmdLine.serial().printf(
                        "channel_dcba=%d, POWERn_Normal)",
                        g_MAX5715_device.channels_bitmask_DCBA);
                    g_MAX5715_device.POWER(g_MAX5715_device.
                                           channels_bitmask_DCBA,
                                           MAX5715::POWERn_Normal);
                    return true; // command was handled by MAX5715
                }
                break;
                case '1':
                {
                    // cmdLine.serial().printf("\r\n 41 ch=? -- POWERn_PD1k");
                    cmdLine.serial().printf(
                        "channel_dcba=%d, POWERn_PD1k)",
                        g_MAX5715_device.channels_bitmask_DCBA);
                    g_MAX5715_device.POWER(g_MAX5715_device.
                                           channels_bitmask_DCBA,
                                           MAX5715::POWERn_PD1k);
                    return true; // command was handled by MAX5715
                }
                break;
                case '2':
                {
                    // cmdLine.serial().printf("\r\n 42 ch=? -- POWERn_PD100k");
                    cmdLine.serial().printf(
                        "channel_dcba=%d, POWERn_PD100k)",
                        g_MAX5715_device.channels_bitmask_DCBA);
                    g_MAX5715_device.POWER(g_MAX5715_device.
                                           channels_bitmask_DCBA,
                                           MAX5715::POWERn_PD100k);
                    return true; // command was handled by MAX5715
                }
                break;
                case '3':
                {
                    // cmdLine.serial().printf("\r\n 43 ch=? -- POWERn_PDHiZ");
                    cmdLine.serial().printf(
                        "channel_dcba=%d, POWERn_PDHiZ)",
                        g_MAX5715_device.channels_bitmask_DCBA);
                    g_MAX5715_device.POWER(g_MAX5715_device.
                                           channels_bitmask_DCBA,
                                           MAX5715::POWERn_PDHiZ);
                    return true; // command was handled by MAX5715
                }
                break;
            }
            break;
        }
        break;
        case '5':
        {
            // recommended for hex command codes 50..5F
            switch (cmdLine[1])
            {
                case '0':
                {
                    // cmdLine.serial().printf("\r\n 50 -- SW_CLEAR");
                    cmdLine.serial().printf("SW_CLEAR");
                    g_MAX5715_device.SW_CLEAR();
                    return true; // command was handled by MAX5715
                }
                break;
                case '1':
                {
                    // cmdLine.serial().printf("\r\n 51 -- SW_RESET");
                    cmdLine.serial().printf("SW_RESET");
                    g_MAX5715_device.SW_RESET();
                    return true; // command was handled by MAX5715
                }
                break;
            }
        }
        break;
        case '6':
        {
            // recommended for hex command codes 60..6F
            switch (cmdLine[1])
            {
                case '0':
                {
                    // cmdLine.serial().printf("\r\n 60 ch=? -- CONFIGn_LATCHED");
                    cmdLine.serial().printf(
                        "MAX5715_CONFIGn_LATCHED(channel_dcba=%d)",
                        g_MAX5715_device.
                        channels_bitmask_DCBA);
                    g_MAX5715_device.CONFIGn_LATCHED(g_MAX5715_device.
                                                     channels_bitmask_DCBA);
                    return true; // command was handled by MAX5715
                }
                break;
                case '1':
                {
                    // cmdLine.serial().printf("\r\n 61 ch=? -- CONFIGn_TRANSPARENT");
                    cmdLine.serial().printf(
                        "MAX5715_CONFIGn_TRANSPARENT(channel_dcba=%d)",
                        g_MAX5715_device.
                        channels_bitmask_DCBA);
                    g_MAX5715_device.CONFIGn_TRANSPARENT(
                        g_MAX5715_device.channels_bitmask_DCBA);
                    return true; // command was handled by MAX5715
                }
                break;
                case '8':
                {
                    // cmdLine.serial().printf("\r\n 68 -- CONFIGall_LATCHED");
                    cmdLine.serial().printf(
                        "MAX5715_CONFIGall_LATCHED()");
                    g_MAX5715_device.CONFIGall_LATCHED();
                    return true; // command was handled by MAX5715
                }
                break;
                case '9':
                {
                    // cmdLine.serial().printf("\r\n 69 -- CONFIGall_TRANSPARENT");
                    cmdLine.serial().printf(
                        "MAX5715_CONFIGall_TRANSPARENT()");
                    g_MAX5715_device.CONFIGall_TRANSPARENT();
                    return true; // command was handled by MAX5715
                }
                break;
            }
        }
        break;
        case '7':
        {
            // recommended for hex command codes 70..7F
            switch (cmdLine[1])
            {
                case '0':
                {
                    // cmdLine.serial().printf("\r\n 70 -- REF_EXT");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_EXT)");
                    g_MAX5715_device.REF(MAX5715::REF_EXT);
                    return true; // command was handled by MAX5715
                }
                break;
                case '1':
                {
                    // cmdLine.serial().printf("\r\n 71 -- REF_2V500");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_2V500)");
                    g_MAX5715_device.REF(MAX5715::REF_2V500);
                    return true; // command was handled by MAX5715
                }
                break;
                case '2':
                {
                    // cmdLine.serial().printf("\r\n 72 -- REF_2V048");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_2V048)");
                    g_MAX5715_device.REF(MAX5715::REF_2V048);
                    return true; // command was handled by MAX5715
                }
                break;
                case '3':
                {
                    // cmdLine.serial().printf("\r\n 73 -- REF_4V096");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_4V096)");
                    g_MAX5715_device.REF(MAX5715::REF_4V096);
                    return true; // command was handled by MAX5715
                }
                break;
                case '4':
                {
                    // cmdLine.serial().printf("\r\n 74 -- REF_AlwaysOn_EXT");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_AlwaysOn_EXT)");
                    g_MAX5715_device.REF(MAX5715::REF_AlwaysOn_EXT);
                    return true; // command was handled by MAX5715
                }
                break;
                case '5':
                {
                    // cmdLine.serial().printf("\r\n 75 -- REF_AlwaysOn_2V500");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_AlwaysOn_2V500)");
                    g_MAX5715_device.REF(MAX5715::REF_AlwaysOn_2V500);
                    return true; // command was handled by MAX5715
                }
                break;
                case '6':
                {
                    // cmdLine.serial().printf("\r\n 76 -- REF_AlwaysOn_2V048");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_AlwaysOn_2V048)");
                    g_MAX5715_device.REF(MAX5715::REF_AlwaysOn_2V048);
                    return true; // command was handled by MAX5715
                }
                break;
                case '7':
                {
                    // cmdLine.serial().printf("\r\n 77 -- REF_AlwaysOn_4V096");
                    cmdLine.serial().printf(
                        "MAX5715_REF(REF_AlwaysOn_4V096)");
                    g_MAX5715_device.REF(MAX5715::REF_AlwaysOn_4V096);
                    return true; // command was handled by MAX5715
                }
                break;
            }
        }
        break;
        case '8':
        {
            // recommended for hex command codes 80..8F
            switch (cmdLine[1])
            {
                case '0':
                {
                    // TODO: cmdLine.serial().printf("\r\n 80 code=? -- CODEall");
                    // TODO: parse command arguments ~ parse_strCommandArgs(strCommandArgs);
                    g_MAX5715_device.channels_bitmask_DCBA = 0xFF;             // store g_MAX5715_device.CODE[allChannels]
                    uint16_t code = g_MAX5715_device.CODE[0];
                    if (cmdLine.parse_uint16_dec("code", code))
                    {
                    }
                    cmdLine.serial().printf("CODEall code=%d", code);
                    g_MAX5715_device.CODEall(code);
                    return true; // command was handled by MAX5715
                }
                break;
                case '1':
                {
                    // TODO: cmdLine.serial().printf("\r\n 81 -- LOADall");
                    cmdLine.serial().printf("LOADall");
                    g_MAX5715_device.LOADall();
                    return true; // command was handled by MAX5715
                }
                break;
                case '2':
                {
                    // TODO: cmdLine.serial().printf("\r\n 82 code=? -- CODEallLOADall");
                    uint16_t code = g_MAX5715_device.CODE[0];
                    if (cmdLine.parse_uint16_dec("code", code))
                    {
                    }
                    cmdLine.serial().printf("CODEallLOADall code=%d", code);
                    g_MAX5715_device.CODEallLOADall(code);
                    return true; // command was handled by MAX5715
                }
                break;
            }
        }
        break;
        case '9':
        {
            // recommended for hex command codes 90..9F
        }
        break;
        case 'a': case 'A':
        {
            // recommended for hex command codes A0..AF
            switch (cmdLine[1])
            {
                case 't': case 'T':
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
                    cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
                    // AT command: skip the prompt to avoid confusing modem detector
                    return false; // command not handled
#endif // IGNORE_AT_COMMANDS
            }
        }
        break;
        case 'b': case 'B':
        {
            // recommended for hex command codes B0..BF
        }
        break;
        case 'c': case 'C':
        {
            // recommended for hex command codes C0..CF
            // // MAX5717 menu function to drive MAX5717_CLRb_Pin CLR#
            // cmdLine.serial().printf("\r\n C -- CLR# pulse CH high CL low");
            switch (cmdLine[1])
            {
                default:
                    // g_MAX5715_device.CLRboutputPulseLow();
                    g_MAX5715_device.CLRboutputValue(1);
                    g_MAX5715_device.CLRboutputValue(0);
                    g_MAX5715_device.CLRboutputValue(1);
                    break;
                case 'H': case 'h': case '1':
                    g_MAX5715_device.CLRboutputValue(1);         // GPIOoutputCLRb(int isLogicHigh);
                    break;
                case 'L': case 'l': case '0':
                    g_MAX5715_device.CLRboutputValue(0);         // GPIOoutputCLRb(int isLogicHigh);
                    break;
            }
            return true; // command was handled by MAX5715
        }
        break;
        case 'd': case 'D':
        {
            // recommended for hex command codes D0..DF
        }
        break;
        case 'e': case 'E':
        {
            // recommended for hex command codes E0..EF
        }
        break;
        case 'f': case 'F':
        {
            // recommended for hex command codes F0..FF
        }
        break;
        case 'l': case 'L':
        {
            // // MAX5717 menu function to drive MAX5717_LDACb_Pin LDAC#
            // cmdLine.serial().printf("\r\n L -- LDAC# pulse LH high LL low");
            switch (cmdLine[1])
            {
                default:
                    // g_MAX5715_device.LDACboutputPulseLow();
                    g_MAX5715_device.LDACboutputValue(1);
                    g_MAX5715_device.LDACboutputValue(0);
                    g_MAX5715_device.LDACboutputValue(1);
                    break;
                case 'H': case 'h': case '1':
                    g_MAX5715_device.LDACboutputValue(1);         // GPIOoutputLDACb(int isLogicHigh);
                    break;
                case 'L': case 'l': case '0':
                    g_MAX5715_device.LDACboutputValue(0);         // GPIOoutputLDACb(int isLogicHigh);
                    break;
            }
            return true; // command was handled by MAX5715
        }
        break;
        case 'x': case 'X':
        {
        }
        break;
        case 'y': case 'Y':
        {
        }
        break;
        case 'z': case 'Z':
        {
        }
        break;
        case '~':     // TODO: IGNORE_AT_COMMANDS -- ignore ~~~ modem command
        {
            // TODO: '~' is not recommended for menu commands, interferes with ssh
            switch (cmdLine[1])
            {
                default:
                {
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
                    cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n",
                                                          cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
                }
            }
        }
        break;
        case '+':     // TODO: IGNORE_AT_COMMANDS -- ignore +++ modem command
        {
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
            cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
        }
        break;
        case '@':
        {
            // //
            // // Menu @ -- print device configuration
            // TODO: cmdLine.serial().printf("\r\n @ -- print MAX5715 configuration");
            // //
            // print shadow register configuration
            //
            // shadow of write-only register CODE dddd_dddd_dddd_0000
            //~ int16_t CMD_1000_CODE;
            int index = 0;
            for (index = 0; index < 4; index++)
            {
                cmdLine.serial().printf("CODE %c=0x%4.4x MAX5715_VoltageOfCode(%d)=%5.3fV\r\n",
                                        (char)('A' + index),
                                        (g_MAX5715_device.Shadow_0010_nnnn_CODE[index] & 0xFFFF),
                                        g_MAX5715_device.CODE[index],
                                        g_MAX5715_device.VoltageOfCode(g_MAX5715_device.CODE[index])
                                        );
            }
            //
            cmdLine.serial().printf("\r\n");
            //
            //
            // Menu @) print MAX5715 configuration AND g_MAX5715_device globals
            //
#if 1 // SUPPORT_CHANNELS
            cmdLine.serial().printf("channelNumber_0_3=%d channels_bitmask_DCBA=%d\r\n",
                                    (g_MAX5715_device.channelNumber_0_3 & 0xFFFF),
                                    (g_MAX5715_device.channels_bitmask_DCBA & 0xFFFF));
#endif // SUPPORT_CHANNELS
            //
            cmdLine.serial().printf("VRef=%5.3fV\r\n", g_MAX5715_device.VRef);
            // dtostrf width and precision: 3.3V / 1024 LSB = 0.00322265625 volts per LSB
            return true; // command was handled by MAX5715
        }
        break;
    } // end switch (cmdLine[0])
    return false; // command not handled by MAX5715
} // end bool MAX5715_menu_onEOLcommandParser(CmdLine & cmdLine)

