// /*******************************************************************************
// * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX5715.h
// *********************************************************************
// Header file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example
// Device Name = MAX5715
// Device Description = Ultra-Small, 12-Bit, 4-Channel, Buffered Output Voltage DAC with Internal Reference and SPI Interface
// Device DeviceBriefDescription = 12-bit 4-ch SPI VOUT DAC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX5715AAUD+
// Device RegValue_Width = DataWidth16bit_HL
//
// DAC NumChannels = 4
// DAC ResolutionBits = 12
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 1
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Falling edge of SCLK
// SPI SCLK Idle High
// SPI SCLKMaxMHz = 50
// SPI SCLKMinMHz = 0
//


// Prevent multiple declaration
#ifndef __MAX5715_H__
#define __MAX5715_H__

// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate

/**
 * @brief MAX5715 Ultra-Small, 12-Bit, 4-Channel, Buffered Output Voltage DAC with Internal Reference and SPI Interface
 *
 *
 *
 * Datasheet: https://www.maximintegrated.com/MAX5715
 *
 *
 *
 * @code
 * // example code includes
 * // standard include for target platform -- Platform_Include_Boilerplate
 * #include "mbed.h"
 * // Platforms:
 * //   - MAX32625MBED
 * //      - supports mbed-os-5.11, requires USBDevice library
 * //      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32600MBED
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
 * //   - NUCLEO_F446RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - NUCLEO_F401RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32630FTHR
 * //      - #include "max32630fthr.h"
 * //      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32620FTHR
 * //      - #include "MAX32620FTHR.h"
 * //      - remove max32630fthr library (if present)
 * //      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
 * //      - not tested yet
 * //   - MAX32625PICO
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - not tested yet
 * //
 * // end Platform_Include_Boilerplate
 * #include "MAX5715.h"
 *
 * // example code board support
 * //MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 * //DigitalOut rLED(LED1);
 * //DigitalOut gLED(LED2);
 * //DigitalOut bLED(LED3);
 * //
 * // Arduino "shield" connector port definitions (MAX32625MBED shown)
 * #if defined(TARGET_MAX32625MBED)
 * #define A0 AIN_0
 * #define A1 AIN_1
 * #define A2 AIN_2
 * #define A3 AIN_3
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P0_4
 * #define D5 P0_5
 * #define D6 P0_6
 * #define D7 P0_7
 * #define D8 P1_4
 * #define D9 P1_5
 * #define D10 P1_3
 * #define D11 P1_1
 * #define D12 P1_2
 * #define D13 P1_0
 * #endif
 *
 * // example code declare SPI interface
 * #if defined(TARGET_MAX32625MBED)
 * SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
 * #elif defined(TARGET_MAX32600MBED)
 * SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
 * #else
 * SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
 * #endif
 *
 * // example code declare GPIO interface pins
 * DigitalOut LDACb_pin(D9); // Digital Trigger Input to MAX5715 device
 * DigitalOut CLRb_pin(D8); // Digital Trigger Input to MAX5715 device
 * // AnalogOut REF_pin(Px_x_PortName_To_Be_Determined); // Reference Input to MAX5715 device
 * // AnalogIn OUTA_pin(A0); // Analog Output from MAX5715 device
 * // AnalogIn OUTB_pin(A1); // Analog Output from MAX5715 device
 * // AnalogIn OUTC_pin(A2); // Analog Output from MAX5715 device
 * // AnalogIn OUTD_pin(A3); // Analog Output from MAX5715 device
 * // DigitalIn RDYb_pin(Px_x_PortName_To_Be_Determined); // Digital MAX5715 Output from MAX5715 device
 * // example code declare device instance
 * MAX5715 g_MAX5715_device(spi, spi_cs, LDACb_pin, CLRb_pin, MAX5715::MAX5715_IC);
 *
 * // example code main function
 * int main()
 * {
 *     while (1)
 *     {
 *         g_MAX5715_device.Init();
 *
 *         g_MAX5715_device.REF(MAX5715::REF_AlwaysOn_2V500);
 *
 *         uint16_t ch;
 *         uint16_t code;
 *         //
 *         ch = 0;
 *         code = 0x0ccc; // 80.0% of full scale REF(2.50V) = 2.00V
 *         g_MAX5715_device.CODEnLOADn(ch, code);
 *         //
 *         ch = 1;
 *         code = 0x07ff; // 50.0% of full scale REF(2.50V) = 1.25V
 *         g_MAX5715_device.CODEnLOADn(ch, code);
 *         //
 *         ch = 2;
 *         code = 0x0666; // 40.0% of full scale REF(2.50V) = 1.00V
 *         g_MAX5715_device.CODEnLOADn(ch, code);
 *         //
 *         ch = 3;
 *         code = 0x0fff; // 100.0% of full scale REF(2.50V) = 2.50V
 *         g_MAX5715_device.CODEnLOADn(ch, code);
 *
 *         // wait(3.0);
 *     }
 * }
 * @endcode
 */
class MAX5715 {
public:
    //----------------------------------------
    /// Command Codes (first byte)
    ///
    /// Naming convention is CMD_bitstream_FUNCTION_NAME
    /// - nnnn = channel selection
    /// - dcba = channel bitmask
    /// - dddd_dddd_dddd = data field
    /// - xxxx = don't care
    typedef enum MAX5715_CMD_enum_t {
        CMD_0000_nnnn_dddd_dddd_dddd_0000_CODEn = 0x00, //!< 8'b00000000
        CMD_0001_nnnn_0000_0000_0000_0000_LOADn = 0x10, //!< 8'b00010000
        CMD_0010_nnnn_dddd_dddd_dddd_0000_CODEnLOADall = 0x20, //!< 8'b00100000
        CMD_0011_nnnn_dddd_dddd_dddd_0000_CODEnLOADn = 0x30, //!< 8'b00110000
        CMD_0100_0000_0000_dcba_0000_0000_POWERn_Normal = 0x40, //!< 8'b01000000
        CMD_0100_0001_0000_dcba_0000_0000_POWERn_PD1k = 0x41, //!< 8'b01000001
        CMD_0100_0010_0000_dcba_0000_0000_POWERn_PD100k = 0x42, //!< 8'b01000010
        CMD_0100_0011_0000_dcba_0000_0000_POWERn_PDHiZ = 0x43, //!< 8'b01000011
        CMD_0101_0000_0000_0000_0000_0000_SW_CLEAR = 0x50, //!< 8'b01010000
        CMD_0101_0001_0000_0000_0000_0000_SW_RESET = 0x51, //!< 8'b01010001
        CMD_0110_0000_0000_dcba_0000_0000_CONFIGn_LATCHED = 0x60, //!< 8'b01100000
        CMD_0110_0001_0000_dcba_0000_0000_CONFIGn_TRANSPARENT = 0x61, //!< 8'b01100001
        CMD_0110_1000_0000_0000_0000_0000_CONFIGall_LATCHED = 0x68, //!< 8'b01101000
        CMD_0110_1001_0000_0000_0000_0000_CONFIGall_TRANSPARENT = 0x69, //!< 8'b01101001
        CMD_0111_0000_0000_0000_0000_0000_REF_EXT = 0x70, //!< 8'b01110000
        CMD_0111_0001_0000_0000_0000_0000_REF_2V500 = 0x71, //!< 8'b01110001
        CMD_0111_0010_0000_0000_0000_0000_REF_2V048 = 0x72, //!< 8'b01110010
        CMD_0111_0011_0000_0000_0000_0000_REF_4V096 = 0x73, //!< 8'b01110011
        CMD_0111_0100_0000_0000_0000_0000_REF_AlwaysOn_EXT = 0x74, //!< 8'b01110100
        CMD_0111_0101_0000_0000_0000_0000_REF_AlwaysOn_2V500 = 0x75, //!< 8'b01110101
        CMD_0111_0110_0000_0000_0000_0000_REF_AlwaysOn_2V048 = 0x76, //!< 8'b01110110
        CMD_0111_0111_0000_0000_0000_0000_REF_AlwaysOn_4V096 = 0x77, //!< 8'b01110111
        CMD_1000_0000_dddd_dddd_dddd_0000_CODEall = 0x80, //!< 8'b10000000
        CMD_1000_0001_0000_0000_0000_0000_LOADall = 0x81, //!< 8'b10000001
        CMD_1000_0010_dddd_dddd_dddd_0000_CODEallLOADall = 0x82, //!< 8'b10000010
        CMD_1000_0011_dddd_dddd_dddd_0000_CODEallLOADall = 0x83, //!< 8'b10000011
        CMD_1001_xxxx_NOP = 0x90, //!< 8'b10010000
        CMD_1010_xxxx_NOP = 0xa0, //!< 8'b10100000
        CMD_1011_xxxx_NOP = 0xb0, //!< 8'b10110000
        CMD_1100_xxxx_NOP = 0xc0, //!< 8'b11000000
        CMD_1101_xxxx_NOP = 0xd0, //!< 8'b11010000
        CMD_1110_xxxx_NOP = 0xe0, //!< 8'b11100000
        CMD_1111_xxxx_NOP = 0xf0, //!< 8'b11110000
    } MAX5715_CMD_enum_t;

    //----------------------------------------
    /// Argument to POWER function
    typedef enum MAX5715_POWER_enum_t {
        POWERn_Normal = 0x00, //!< 8'b00000000
        POWERn_PD1k = 0x01, //!< 8'b00000001
        POWERn_PD100k = 0x02, //!< 8'b00000010
        POWERn_PDHiZ = 0x03, //!< 8'b00000011
    } MAX5715_POWER_enum_t;

    //----------------------------------------
    /// Argument to REF function ( external? voltage? always on? )
    typedef enum MAX5715_REF_enum_t {
        REF_EXT = 0x00, //!< 8'b00000000
        REF_2V500 = 0x01, //!< 8'b00000001
        REF_2V048 = 0x02, //!< 8'b00000010
        REF_4V096 = 0x03, //!< 8'b00000011
        REF_AlwaysOn_EXT = 0x04, //!< 8'b00000100
        REF_AlwaysOn_2V500 = 0x05, //!< 8'b00000101
        REF_AlwaysOn_2V048 = 0x06, //!< 8'b00000110
        REF_AlwaysOn_4V096 = 0x07, //!< 8'b00000111
    } MAX5715_REF_enum_t;

    /**
     * @brief IC's supported with this driver
     * @details MAX5715
     */
    typedef enum
    {
        MAX5715_IC = 0,
        //MAX5715_IC = 1
    } MAX5715_ic_t;

    /**********************************************************//**
    * @brief Constructor for MAX5715 Class.
    *
    * @details Requires an existing SPI object as well as a DigitalOut object.
    * The DigitalOut object is used for a chip enable signal
    *
    * On Entry:
    *     @param[in] spi - pointer to existing SPI object
    *     @param[in] cs_pin - pointer to a DigitalOut pin object
    *     @param[in] LDACb_pin - pointer to a DigitalOut pin object
    *     @param[in] CLRb_pin - pointer to a DigitalOut pin object
    *     @param[in] ic_variant - which type of MAX5715 is used
    *
    * On Exit:
    *
    * @return None
    **************************************************************/
    MAX5715(SPI &spi, DigitalOut &cs_pin, // SPI interface
            DigitalOut &LDACb_pin, // Digital Trigger Input to MAX5715 device
            DigitalOut &CLRb_pin, // Digital Trigger Input to MAX5715 device
            // AnalogOut &REF_pin, // Reference Input to MAX5715 device
            // AnalogIn &OUTA_pin, // Analog Output from MAX5715 device
            // AnalogIn &OUTB_pin, // Analog Output from MAX5715 device
            // AnalogIn &OUTC_pin, // Analog Output from MAX5715 device
            // AnalogIn &OUTD_pin, // Analog Output from MAX5715 device
            // DigitalIn &RDYb_pin, // Digital DaisyChain Output from MAX5715 device
            MAX5715_ic_t ic_variant);

    /************************************************************
     * @brief Default destructor for MAX5715 Class.
     *
     * @details Destroys SPI object if owner
     *
     * On Entry:
     *
     * On Exit:
     *
     * @return None
     **************************************************************/
    ~MAX5715();

    /// Function pointer void f(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
    Callback<void(size_t, uint8_t*, uint8_t*)> onSPIprint; //!< optional @ref onSPIprint SPI diagnostic function

    /// set SPI SCLK frequency
    void spi_frequency(int spi_sclk_Hz);

//----------------------------------------
public:

    /// reference voltage, in Volts
    double VRef;

    /// DAC Selection: 0=OUTA, 1=OUTB, 2=OUTC, 3=OUTD, 4..15=ALL OUTA,OUTB,OUTC,OUTD; shadow of channel_0_3
    uint8_t channelNumber_0_3;

    /// channel bitmask channel_dcba: 1=OUTA, 2=OUTB, 4=OUTC, 8=OUTD
    uint8_t channels_bitmask_DCBA;

    /// shadow of write-only register CODE[channel_0_3] CMD_0010_nnnn
    int16_t Shadow_0010_nnnn_CODE[4];

    /// shadow of write-only register POWER[channel_0_3] CMD_0100_00pp
    int16_t Shadow_0100_00pp_POWER[4];

    /// shadow of write-only register CONFIG[channel_0_3] CMD_0110_a00t
    int16_t Shadow_0110_a00t_CONFIG[4];

    /// shadow of write-only register REF CMD_0111_0rrr
    int16_t Shadow_0111_0rrr_REF;

    /// shadow of dacCodeLsbs; CODE field of write-only register CODE[channel_0_3] CMD_0010_nnnn
    int16_t CODE[4];


//----------------------------------------
// Assert SPI Chip Select
// SPI chip-select for MAX5715
//
    void SPIoutputCS(int isLogicHigh);

//----------------------------------------
// SPI write 24 bits
// SPI interface to MAX5715 shift 24 bits mosiData into MAX5715 DIN
//
    void SPIwrite24bits(int8_t mosiData8_FF0000, int16_t mosiData16_00FFFF);

//----------------------------------------
// Assert MAX5715 LDAC pin : High = inactive, Low = load DAC.
//
    void LDACboutputValue(int isLogicHigh);

//----------------------------------------
// Assert MAX5715 CLR pin : High = inactive, Low = clear DAC.
//
    void CLRboutputValue(int isLogicHigh);

private:
    // SPI object
    SPI &m_spi;
    int m_SPI_SCLK_Hz;
    int m_SPI_dataMode;
    int m_SPI_cs_state;

    // Selector pin object
    DigitalOut &m_cs_pin;

// InputPin Name = LDAC#
// InputPin Description = Dedicated Active-Low Asynchronous Load DAC.
// InputPin Function = Trigger
    DigitalOut &m_LDACb_pin;
//
// InputPin Name = CLR#
// InputPin Description = Active-Low Clear Input.
// InputPin Function = Trigger
    DigitalOut &m_CLRb_pin;
//
// InputPin Name = REF
// InputPin Description = Reference Voltage Input/Output.
//     Software selectable to be external reference or internal 2.048V, 2.500V, or 4.096V reference.
//     Default is external reference mode.
// InputPin Function = Reference
    // AnalogOut &m_REF_pin;
//
// OutputPin Name = OUTA
// OutputPin Description = Buffered Channel A DAC Output
// OutputPin Function = Analog
    // AnalogIn &m_OUTA_pin;
//
// OutputPin Name = OUTB
// OutputPin Description = Buffered Channel B DAC Output
// OutputPin Function = Analog
    // AnalogIn &m_OUTB_pin;
//
// OutputPin Name = OUTC
// OutputPin Description = Buffered Channel C DAC Output
// OutputPin Function = Analog
    // AnalogIn &m_OUTC_pin;
//
// OutputPin Name = OUTD
// OutputPin Description = Buffered Channel D DAC Output
// OutputPin Function = Analog
    // AnalogIn &m_OUTD_pin;
//
// OutputPin Name = RDY#
// OutputPin Description = SPI RDY Output. In daisy-chained applications connect RDY to the CSB of the next device in the chain.
// OutputPin Function = DaisyChain
    // DigitalIn &m_RDYb_pin;
//

    // Identifies which IC variant is being used
    MAX5715_ic_t m_ic_variant;

public:

    //----------------------------------------
    /// Menu item '!'
    /// Initialize device
    /// @return 1 on success; 0 on failure
    uint8_t Init(void);

    //----------------------------------------
    /// Return the DAC register value corresponding to physical voltage.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre g_MAX5715_device.VRef = Voltage of REF input, in Volts
    /// @param[in] voltage = physical voltage in Volts
    /// @return raw 12-bit MAX5715 code (right justified).
    uint16_t DACCodeOfVoltage(double voltageV);

    //----------------------------------------
    /// Return the physical voltage corresponding to DAC register.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre g_MAX5715_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u12: raw 12-bit MAX5715 code (right justified).
    /// @return physical voltage corresponding to MAX5715 code.
    double VoltageOfCode(uint16_t value_u12);

    //----------------------------------------
    /// CMD_1000_0000_dddd_dddd_dddd_0000_CODEall
    ///
    /// Writes data to all CODE registers
    /// @post updates g_MAX5815_device.Shadow_0010_nnnn_CODE[0..3]
    /// @post updates g_MAX5815_device.CODE[0..3]
    void CODEall(uint16_t dacCodeLsbs);

    //----------------------------------------
    /// CMD_0000_nnnn_dddd_dddd_dddd_0000_CODEn
    ///
    /// Writes data to the selected CODE register(s)
    ///
    /// @param[in] channel_0_3 = DAC Selection: 0=OUTA, 1=OUTB, 2=OUTC, 3=OUTD, 4..15=ALL OUTA,OUTB,OUTC,OUTD
    /// @post updates g_MAX5815_device.Shadow_0010_nnnn_CODE[0..3]
    /// @post updates g_MAX5815_device.CODE[0..3]
    void CODEn(uint8_t channel_0_3, uint16_t dacCodeLsbs);

    //----------------------------------------
    /// CMD_1000_0010_dddd_dddd_dddd_0000_CODEallLOADall
    ///
    /// Simultaneously writes data to all CODE registers while updating all DAC registers
    /// @post updates g_MAX5815_device.Shadow_0010_nnnn_CODE[0..3]
    /// @post updates g_MAX5815_device.CODE[0..3]
    void CODEallLOADall(uint16_t dacCodeLsbs);

    //----------------------------------------
    /// CMD_0010_nnnn_dddd_dddd_dddd_0000_CODEnLOADall
    ///
    /// Simultaneously writes data to the selected CODE register(s) while updating all DAC registers.
    ///
    /// @param[in] channel_0_3 = DAC Selection: 0=OUTA, 1=OUTB, 2=OUTC, 3=OUTD, 4..15=ALL OUTA,OUTB,OUTC,OUTD
    /// @post updates g_MAX5815_device.Shadow_0010_nnnn_CODE[0..3]
    /// @post updates g_MAX5815_device.CODE[0..3]
    void CODEnLOADall(uint8_t channel_0_3, uint16_t dacCodeLsbs);

    //----------------------------------------
    /// CMD_0011_nnnn_dddd_dddd_dddd_0000_CODEnLOADn
    ///
    /// Simultaneously writes data to the selected CODE register(s) while updating selected DAC register(s)
    ///
    /// @param[in] channel_0_3 = DAC Selection: 0=OUTA, 1=OUTB, 2=OUTC, 3=OUTD, 4..15=ALL OUTA,OUTB,OUTC,OUTD
    /// @post updates g_MAX5815_device.Shadow_0010_nnnn_CODE[0..3]
    /// @post updates g_MAX5815_device.CODE[0..3]
    void CODEnLOADn(uint8_t channel_0_3, uint16_t dacCodeLsbs);

    //----------------------------------------
    /// CMD_0110_0000_0000_dcba_0000_0000_CONFIGn_LATCHED
    ///
    /// Sets the DAC Latch Mode of the selected DACs.
    /// Only DACS with a 1 in the selection bit are updated by the command.
    /// LD_EN = 0: DAC latch is operational (LOAD and LDAC controlled)
    ///
    /// @param[in] channels_bitmask_DCBA = channel select bitmap
    ///     bit 1000 = channel D
    ///     bit 0100 = channel C
    ///     bit 0010 = channel B
    ///     bit 0001 = channel A
    void CONFIGn_LATCHED(uint8_t channels_bitmask_DCBA);

    //----------------------------------------
    /// CMD_0110_0001_0000_dcba_0000_0000_CONFIGn_TRANSPARENT
    ///
    /// Sets the DAC Latch Mode of the selected DACs.
    /// Only DACS with a 1 in the selection bit are updated by the command.
    /// LD_EN = 1: DAC latch is transparent
    ///
    /// @param[in] channels_bitmask_DCBA = channel select bitmap
    ///     bit 1000 = channel D
    ///     bit 0100 = channel C
    ///     bit 0010 = channel B
    ///     bit 0001 = channel A
    void CONFIGn_TRANSPARENT(uint8_t channels_bitmask_DCBA);

    //----------------------------------------
    /// CMD_0110_1000_0000_0000_0000_0000_CONFIGall_LATCHED
    ///
    /// Sets the DAC Latch Mode of all DACs.
    /// LD_EN = 0: DAC latch is operational (LOAD and LDAC controlled)
    void CONFIGall_LATCHED(void);

    //----------------------------------------
    /// CMD_0110_1001_0000_0000_0000_0000_CONFIGall_TRANSPARENT
    ///
    /// Sets the DAC Latch Mode of all DACs.
    /// LD_EN = 1: DAC latch is transparent
    void CONFIGall_TRANSPARENT(void);

    //----------------------------------------
    /// CMD_1000_0001_0000_0000_0000_0000_LOADall
    ///
    /// Updates all DAC latches with current CODE register data
    void LOADall(void);

    //----------------------------------------
    /// CMD_0001_nnnn_0000_0000_0000_0000_LOADn
    ///
    /// Transfers data from the selected CODE register(s) to the selected DAC register(s).
    ///
    /// @param[in] channel_0_3 = DAC Selection: 0=OUTA, 1=OUTB, 2=OUTC, 3=OUTD, 4..15=ALL OUTA,OUTB,OUTC,OUTD
    void LOADn(uint8_t channel_0_3);

    //----------------------------------------
    /// CMD_0100_0000_0000_dcba_0000_0000_POWERn_Normal
    /// CMD_0100_0001_0000_dcba_0000_0000_POWERn_PD1k
    /// CMD_0100_0010_0000_dcba_0000_0000_POWERn_PD100k
    /// CMD_0100_0011_0000_dcba_0000_0000_POWERn_PDHiZ
    ///
    /// Sets the power mode of the selected DACs
    /// (DACs selected with a 1 in the corresponding DACn bit are updated,
    /// DACs with a 0 in the corresponding DACn bit are not impacted)
    ///
    /// @param[in] channels_bitmask_DCBA = channel select bitmap
    ///     bit 1000 = channel D
    ///     bit 0100 = channel C
    ///     bit 0010 = channel B
    ///     bit 0001 = channel A
    /// @param[in] powerValue = power configuration for selected channel
    void POWER(uint8_t channels_bitmask_DCBA, MAX5715_POWER_enum_t powerValue);

    //----------------------------------------
    /// CMD_0111_0000_0000_0000_0000_0000_REF_EXT
    /// CMD_0111_0001_0000_0000_0000_0000_REF_2V500
    /// CMD_0111_0010_0000_0000_0000_0000_REF_2V048
    /// CMD_0111_0011_0000_0000_0000_0000_REF_4V096
    /// CMD_0111_0100_0000_0000_0000_0000_REF_AlwaysOn_EXT
    /// CMD_0111_0101_0000_0000_0000_0000_REF_AlwaysOn_2V500
    /// CMD_0111_0110_0000_0000_0000_0000_REF_AlwaysOn_2V048
    /// CMD_0111_0111_0000_0000_0000_0000_REF_AlwaysOn_4V096
    ///
    /// Sets the reference operating mode.
    /// REF Power (B18): 0 = Internal reference is only powered if at least one DAC is powered
    /// 1 = Internal reference is always powered
    void REF(MAX5715_REF_enum_t ref);

    //----------------------------------------
    /// CMD_0101_0000_0000_0000_0000_0000_SW_CLEAR
    ///
    /// Software Clear
    /// All CODE and DAC registers cleared to their default values.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t SW_CLEAR(void);

    //----------------------------------------
    /// CMD_0101_0001_0000_0000_0000_0000_SW_RESET
    ///
    /// Software Reset
    /// All CODE, DAC, and control registers returned to their default values,
    /// simulating a power cycle reset.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t SW_RESET(void);

}; // end of class MAX5715

#endif // __MAX5715_H__

// End of file
