/*******************************************************************************
* Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

#include "MAX541.h"

MAX541::MAX541(SPI &spi, DigitalOut &cs_pin)
    : m_spi(spi), m_cs_pin(cs_pin) // SPI interface
{
    VRef = 3.3f;
    m_cs_pin = 1;

    m_SPI_dataMode = 0; // SPI_MODE0: CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
    m_spi.format(8,m_SPI_dataMode);         // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0
    m_SPI_SCLK_Hz = 4000000; // 4MHz
    m_spi.frequency(m_SPI_SCLK_Hz);
}

MAX541::~MAX541()
{
}

void MAX541::Set_Voltage(double voltageV)
{
    if (voltageV >= VRef) {
        Set_Code(max541codeFS);
    } else if (voltageV <= 0.0f) {
        Set_Code(0);
    } else {
        Set_Code(voltageV / VRef * max541codeFS);
    }
}

double MAX541::Get_Voltage() const
{
    return (VRef * max541_code) / max541codeFS;
}

void MAX541::Set_Code(int16_t max541_mosiData16)
{
    max541_code = (uint16_t)max541_mosiData16;
    size_t max541_byteCount = 2;
    static char max541_mosiData[2];
    static char max541_misoData[2];
    max541_mosiData[0] = (char)((max541_mosiData16 >> 8) & 0xFF); // MSByte
    max541_mosiData[1] = (char)((max541_mosiData16 >> 0) & 0xFF); // LSByte
    m_cs_pin = 0;
    m_spi.write(max541_mosiData, max541_byteCount, max541_misoData, max541_byteCount);
    m_cs_pin = 1;
}

uint16_t MAX541::Get_Code(void) const
{
    return max541_code;
}
