/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "MAX5216.h"
 
MAX5216::MAX5216(SPI &spi, DigitalOut &pin, MAX521X_ic_t ic_variant) : m_spi(spi), m_pin(pin), m_ic_variant(ic_variant)
{
    m_pin = 1;
}
 
void MAX5216::write_command(setting_t setting, uint32_t value, pwrDwnMode_t mode)
{
    
    char val[3] = {0, 0, 0};
    int i;
    m_pin = 0;
    if (setting == PwrDwn_Reg) {
        val[0] = char(value<<2);
        val[0] |= char(setting);
        for (i = 0; i < MAX521X_NUM_BYTES_SPI[(uint8_t)(m_ic_variant)]; i++) {
            m_spi.write(val[i]);
        }
    } else if (setting == WrtThru_Reg){
        
        if(value > MAX521X_IC_BIT_MASK[(uint8_t)(m_ic_variant)]) {
            printf("value in writeCommand is too big: %X\r\n", value);
            return;
        }
        if (m_ic_variant == MAX5214_IC) {  // MAX5214 is 14 bits
            value &= MAX521X_IC_BIT_MASK[(uint8_t)(m_ic_variant)];
        } else {                           // MAX5216 is 16 bits
            value &= MAX521X_IC_BIT_MASK[(uint8_t)(m_ic_variant)];
            value = value << 6;  // least significant 6 bits are not used
            val[2] = value & 0xFF;
            value = value >> 8;
        }
        val[1] = value & 0xFF;
        value = value >> 8;
        val[0] = value;
        val[0] |= setting;
        //  printf("mask %X, Value %X, val 0, 1, 2 %02X %02X %02X \r\n", MAX521X_IC_BIT_MASK[(uint8_t)(m_ic_variant)],value, val[0], val[1], val[2]);
        for (i = 0; i < MAX521X_NUM_BYTES_SPI[(uint8_t)(m_ic_variant)]; i++) {
            m_spi.write(val[i]);
        }
    }
    m_pin = 1;
}
 
MAX5216::~MAX5216(void) 
{
  //empty block
}
 
