/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "MAX5216.h"
#include "USBSerial.h"
 
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3); 
 
DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
 
DigitalOut selectPin(P3_0); // Pin 3_0 is used to drive chip enable low
SPI spi(P5_1, P5_2, P5_0); // mosi, miso, sclk
 
// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
/**
* @brief Sample main program for MAX5214, MAX5216
* @version 1.0000.1
*
* @details Sample main program for MAX5214, MAX5216
* The prints are sent to the terminal window (9600, 8n1).
* The program sets the GPIOs to 3.3V and the program
* issues various voltages to the DAC. Then the program
* issues a Power Down Command.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus (MAX32630FTHR) after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/
int main()
{
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    gLED = LED_ON;
    printf("MAX5216 16-bit DAC example source code.\r\n");
    MAX5216 dac(spi, selectPin, MAX5216::MAX5216_IC);
    
    spi.format(8,0);
    spi.frequency(24000000);  // Use 24 MHz SPI bus
    
    // Command values to the DAC
    dac.write_command(MAX5216::WrtThru_Reg, 0xFFFF);
    wait(1.0);
    gLED = LED_OFF;
    dac.write_command(MAX5216::WrtThru_Reg, 0x7FFF);
    wait(1.0);
    gLED = LED_ON;
    dac.write_command(MAX5216::WrtThru_Reg, 0x3FFF); 
    wait(1.0);
    gLED = LED_OFF;
    dac.write_command(MAX5216::WrtThru_Reg, 0x1FFF);
    wait(1.0);
    rLED = LED_ON;
    gLED = LED_ON;
 
    // Issue Power Down Commands
//    dac.write_command(MAX5216::PwrDwn_Reg, MAX5216::PwrDwnNormalOp);
    dac.write_command(MAX5216::PwrDwn_Reg, MAX5216::PwrDwnHiZ);
//    dac.write_command(MAX5216::PwrDwn_Reg, MAX5216::PwrDwn100K);
//    dac.write_command(MAX5216::PwrDwn_Reg, MAX5216::PwrDwn1K);
    wait(2.0);
    rLED = LED_OFF;
 
    while (true) {  // Blink the green LED 
        gLED = !gLED;
        wait(0.5);
    }
}
 
 