﻿// /*******************************************************************************
// * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */

#include "mbed.h"
#include "MAX5171.h"
#include "CmdLine.h"

//--------------------------------------------------
// tolerate AT commands, which may be sent during probe, such as:
//  AT
//  AT+CGMI      -- request manufacturer identification AT+CMGI=?
//  AT+CGMM      -- request manufacturer model
//  AT%IPSYS?
//  ATE0         -- echo disable
//  ATV1         -- verbose result codes OK | ERROR | NO CARRIER
//  AT+CMEE=1
//  ATX4
//  AT&C1
//  ATE0
//  AT+CMEE=1
//  AT+GCAP
//  ATI
//  AT+CPIN?
//  AT+CGMM
#ifndef IGNORE_AT_COMMANDS
#define IGNORE_AT_COMMANDS 1
#endif

extern MAX5171 g_MAX5171_device; // defined in main.cpp

bool MAX5171_menu_onEOLcommandParser(CmdLine & cmdLine)
{
    switch (cmdLine[0])
    {
        case '0':
        {
            // recommended for hex command codes 10..1F
            //~ cmdLine.serial().printf("\r\n 0 code=? -- CODE");
            uint16_t code;
            if (cmdLine.parse_uint16_dec("code", code))
            {
            }
            cmdLine.serial().printf("CODE code=%d", code);
            g_MAX5171_device.CODE(code);
            return true; // command was handled by MAX5171
        }
        break;
        case '4':
        {
            // recommended for hex command codes 10..1F
            //~ cmdLine.serial().printf("\r\n 4 code=? -- CODE_LOAD");
            uint16_t code;
            if (cmdLine.parse_uint16_dec("code", code))
            {
            }
            cmdLine.serial().printf("CODE_LOAD code=%d", code);
            g_MAX5171_device.CODE_LOAD(code);
            return true; // command was handled by MAX5171
        }
        break;
        case '8':
        {
            // recommended for hex command codes 10..1F
            //~ cmdLine.serial().printf("\r\n 8 -- LOAD");
            cmdLine.serial().printf("LOAD");
            g_MAX5171_device.LOAD();
            return true; // command was handled by MAX5171
        }
        break;
        case 'c': case 'C':
        {
            // recommended for hex command codes 10..1F
            //~ cmdLine.serial().printf("\r\n c -- NOP");
            cmdLine.serial().printf("NOP");
            g_MAX5171_device.NOP();
            return true; // command was handled by MAX5171
        }
        break;
        case 'd': case 'D':
        {
            // recommended for hex command codes 10..1F
            //~ cmdLine.serial().printf("\r\n d -- SHUTDOWN");
            cmdLine.serial().printf("SHUTDOWN");
            g_MAX5171_device.SHUTDOWN();
            return true; // command was handled by MAX5171
        }
        break;
        case 'e': case 'E':
        {
            switch (cmdLine[1])
            {
                case '0':
                {
                    // recommended for hex command codes 10..1F
                    //~ cmdLine.serial().printf("\r\n e0 -- UPO_LOW");
                    cmdLine.serial().printf("UPO_LOW");
                    g_MAX5171_device.UPO_LOW();
                    return true; // command was handled by MAX5171
                }
                break;
                case '8':
                {
                    // recommended for hex command codes 10..1F
                    //~ cmdLine.serial().printf("\r\n e8 -- UPO_HIGH");
                    cmdLine.serial().printf("UPO_HIGH");
                    g_MAX5171_device.UPO_HIGH();
                    return true; // command was handled by MAX5171
                }
                break;
            }
        }
        break;
        case 'f': case 'F':
        {
            switch (cmdLine[1])
            {
                case '0':
                {
                    // recommended for hex command codes 10..1F
                    //~ cmdLine.serial().printf("\r\n f0 -- MODE1_DOUT_SCLK_RISING_EDGE");
                    cmdLine.serial().printf("MODE1_DOUT_SCLK_RISING_EDGE");
                    g_MAX5171_device.MODE1_DOUT_SCLK_RISING_EDGE();
                    return true; // command was handled by MAX5171
                }
                break;
                case '8':
                {
                    // recommended for hex command codes 10..1F
                    //~ cmdLine.serial().printf("\r\n f8 -- MODE0_DOUT_SCLK_FALLING_EDGE");
                    cmdLine.serial().printf("MODE0_DOUT_SCLK_FALLING_EDGE");
                    g_MAX5171_device.MODE0_DOUT_SCLK_FALLING_EDGE();
                    return true; // command was handled by MAX5171
                }
                break;
            }
        }
        break;
        case 'a': case 'A':
        {
            // recommended for hex command codes A0..AF
            switch (cmdLine[1])
            {
                case 't': case 'T':
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
                    cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
                    // AT command: skip the prompt to avoid confusing modem detector
                    return false; // command not handled
#endif // IGNORE_AT_COMMANDS
            }
        }
        break;
        case 'x': case 'X':
        {
        }
        break;
        case 'y': case 'Y':
        {
        }
        break;
        case 'z': case 'Z':
        {
        }
        break;
        case '~':     // TODO: IGNORE_AT_COMMANDS -- ignore ~~~ modem command
        {
            // TODO: '~' is not recommended for menu commands, interferes with ssh
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
            cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
        }
        break;
        case '+':     // TODO: IGNORE_AT_COMMANDS -- ignore +++ modem command
        {
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
            cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
        }
        break;
    } // end switch (cmdLine[0])
    return false; // command not handled
} // end bool MAX5171_menu_onEOLcommandParser(CmdLine & cmdLine)

