// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate
#include "MAX5171.h"
#include "CmdLine.h"
#include "MaximTinyTester.h"

#include "MAX5171.h"
extern MAX5171 g_MAX5171_device; // defined in main.cpp



void MAX5171_menu_help(CmdLine & cmdLine)
{
    cmdLine.serial().printf("\r\n ! -- Init");
    cmdLine.serial().printf("\r\n 0 code=? -- CODE");
    cmdLine.serial().printf("\r\n 4 code=? -- CODE_LOAD");
    cmdLine.serial().printf("\r\n 8 -- LOAD");
    cmdLine.serial().printf("\r\n c -- NOP");
    cmdLine.serial().printf("\r\n d -- SHUTDOWN");
    cmdLine.serial().printf("\r\n e0 -- UPO_LOW");
    cmdLine.serial().printf("\r\n e8 -- UPO_HIGH");
    cmdLine.serial().printf("\r\n f0 -- MODE1_DOUT_SCLK_RISING_EDGE");
    cmdLine.serial().printf("\r\n f8 -- MODE0_DOUT_SCLK_FALLING_EDGE");
    //
    cmdLine.serial().printf("\r\n @ -- print MAX5171 configuration");

    //
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands

    //
}

bool MAX5171_menu_onEOLcommandParser(CmdLine & cmdLine)
{


                    // parse argument int16_t DACCode
        int16_t DACCode = g_MAX5171_device.DACCode; // default to global property value
        if (cmdLine.parse_int16_dec("DACCode", DACCode))
        {
            g_MAX5171_device.DACCode = DACCode; // update global property value
        }
                    // "code" is an alias for argument "DACCode"
        if (cmdLine.parse_int16_dec("code", DACCode))
        {
            g_MAX5171_device.DACCode = DACCode; // update global property value
        }

                    // parse argument double VRef
        double VRef = g_MAX5171_device.VRef; // default to global property value
        if (cmdLine.parse_double("VRef", VRef))
        {
            g_MAX5171_device.VRef = VRef; // update global property value
        }

                    // parse argument uint16_t dacCodeLsbs
        uint16_t dacCodeLsbs = g_MAX5171_device.DACCode; // default to global property value
        if (cmdLine.parse_uint16_dec("dacCodeLsbs", dacCodeLsbs))
        {
            g_MAX5171_device.DACCode = dacCodeLsbs; // update global property value
        }
                    // "code" is an alias for argument "dacCodeLsbs"
        if (cmdLine.parse_uint16_dec("code", dacCodeLsbs))
        {
            g_MAX5171_device.DACCode = dacCodeLsbs; // update global property value
        }

    switch (cmdLine[0])
    {
        case '@':
        {
                    cmdLine.serial().printf("VRef = ");
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX5171_device.VRef);
                    cmdLine.serial().printf("DACCode = ");
                    cmdLine.serial().printf("%d = 0x%4.4x\r\n", g_MAX5171_device.DACCode, g_MAX5171_device.DACCode);
                    return true; // command handled by MAX5171
            break;
        }
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands
        // case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
        case '!':
        {
                    // test menu command '!' handler:
                    // helpString='! -- Init'
                    // CMD_='None'
                    // CommandName='Init'
                    // CommandParamIn='void'
                    // CommandReturnType='void'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return=''
                    // @Test='@test group DACCodeOfVoltage // Verify function DACCodeOfVoltage (enabled by default)'
                    // @Test='@test group DACCodeOfVoltage tinyTester.blink_time_msec = 20 // quickly speed through the software verification'
                    // @Test='@test group DACCodeOfVoltage tinyTester.print("VRef = 2.500  MAX5171 14-bit LSB = 0.00015V")'
                    // @Test='@test group DACCodeOfVoltage VRef = 2.500'
                    // @Test='@test group DACCodeOfVoltage tinyTester.err_threshold = 0.00015259720441921504 // 14-bit LSB (2.500/16383)'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(2.499847412109375) expect 0x3FFF'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(2.49969482421875) expect 0x3FFE'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(2.499542236328125) expect 0x3FFD'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(2.4993896484375) expect 0x3FFC'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(1.250152587890625) expect 0x2001'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(1.25) expect 0x2000'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(1.249847412109375) expect 0x1FFF'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(1.24969482421875) expect 0x1FFE'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(0.000457763671875) expect 0x0003'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(0.00030517578125) expect 0x0002'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(0.000152587890625) expect 0x0001'
                    // @Test='@test group DACCodeOfVoltage DACCodeOfVoltage(0.00000) expect 0x0000'
                    // @Test='@test group DACCodeOfVoltage tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
                    // @Test='@test group VoltageOfCode // Verify function VoltageOfCode (enabled by default)'
                    // @Test='@test group VoltageOfCode tinyTester.blink_time_msec = 20 // quickly speed through the software verification'
                    // @Test='@test group VoltageOfCode tinyTester.print("VRef = 2.500  MAX5171 14-bit LSB = 0.00015V")'
                    // @Test='@test group VoltageOfCode VRef = 2.500'
                    // @Test='@test group VoltageOfCode tinyTester.err_threshold = 0.00015259720441921504 // 14-bit LSB (2.500/16383)'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x3FFF) expect 2.499847412109375'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x3FFE) expect 2.49969482421875'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x3FFD) expect 2.499542236328125'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x3FFC) expect 2.4993896484375'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x2001) expect 1.250152587890625'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x2000) expect 1.25'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x1FFF) expect 1.249847412109375'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x1FFE) expect 1.24969482421875'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x0003) expect 0.000457763671875'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x0002) expect 0.00030517578125'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x0001) expect 0.000152587890625'
                    // @Test='@test group VoltageOfCode VoltageOfCode(0x0000) expect 0.00000'
                    // @Test='@test group VoltageOfCode tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
                    // @Test='@test group CODE_LOAD // Verify function CODE_LOAD (enabled by default)'
                    // @Test='@test group CODE_LOAD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
                    // @Test='@test group CODE_LOAD tinyTester.settle_time_msec = 500'
                    // @Test='@test Init()'
                    // @Test='@test VRef expect 2.500 // Nominal Full-Scale Voltage Reference'
                    // @Test='@test group CODE_LOAD tinyTester.err_threshold = 0.050'
                    // @Test='@test group CODE_LOAD tinyTester.print("100.0% of full scale REF(2.50V) = 2.50V Jumper FB=1-2")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x3FFF) // 100.0% of full scale REF(2.50V) = 2.50V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.500)'
                    // @Test='@test group CODE_LOAD tinyTester.print("0.0% of full scale REF(2.50V) = 0.000V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x0000) // 0.0% of full scale REF(2.50V) = 0.000V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.0000)'
                    // @Test='@test group CODE_LOAD tinyTester.print("50.0% of full scale REF(2.50V) = 1.25V")'
                    // @Test='@test group CODE_LOAD CODE_LOAD(0x1FFF) // 50.0% of full scale REF(2.50V) = 1.25V'
                    // @Test='@test group CODE_LOAD tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.2500)'
                    // @Test='@test group UPO // Verify User Programmable Output functions UPO_HIGH and UPO_LOW (enabled by default)'
                    // @Test='@test group UPO tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
                    // @Test='@test group UPO tinyTester.settle_time_msec = 500 // default 250'
                    // @Test='@test group UPO UPO_HIGH()'
                    // @Test='@test group UPO tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command")'
                    // @Test='@test group UPO UPO_LOW()'
                    // @Test='@test group UPO tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 0, "UPO_pin is low after MAX5171 UPO_LOW command")'
                    // @Test='@test group UPO UPO_HIGH()'
                    // @Test='@test group UPO tinyTester.Wait_Output_Settling()'
                    // @Test='@test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command")'
                    cmdLine.serial().printf("Init");
                    // call function Init
                    g_MAX5171_device.Init();
                    return true; // command handled by MAX5171
        } // end case '!'
        break;
        case '0':
        {
                    // test menu command '0' handler:
                    // helpString='0 code=? -- CODE'
                    // CMD_='CMD_00dd_dddd_dddd_dddd_CODE'
                    // CommandName='CODE'
                    // CommandParamIn='uint16_t dacCodeLsbs'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argument dacCodeLsbs alias code already parsed
                    // print arguments
                    cmdLine.serial().printf("CODE");
                    cmdLine.serial().printf(" dacCodeLsbs=%d", dacCodeLsbs);
                    cmdLine.serial().printf("\r\n");
                    // call function CODE(dacCodeLsbs)
                    uint8_t result = g_MAX5171_device.CODE(dacCodeLsbs);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
        } // end case '0'
        break;
        case '4':
        {
                    // test menu command '4' handler:
                    // helpString='4 code=? -- CODE_LOAD'
                    // CMD_='CMD_01dd_dddd_dddd_dddd_CODE_LOAD'
                    // CommandName='CODE_LOAD'
                    // CommandParamIn='uint16_t dacCodeLsbs'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argument dacCodeLsbs alias code already parsed
                    // print arguments
                    cmdLine.serial().printf("CODE_LOAD");
                    cmdLine.serial().printf(" dacCodeLsbs=%d", dacCodeLsbs);
                    cmdLine.serial().printf("\r\n");
                    // call function CODE_LOAD(dacCodeLsbs)
                    uint8_t result = g_MAX5171_device.CODE_LOAD(dacCodeLsbs);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
        } // end case '4'
        break;
        case '8':
        {
                    // test menu command '8' handler:
                    // helpString='8 -- LOAD'
                    // CMD_='CMD_10xx_xxxx_xxxx_xxxx_LOAD'
                    // CommandName='LOAD'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("LOAD");
                    // call function LOAD
                    uint8_t result = g_MAX5171_device.LOAD();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
        } // end case '8'
        break;
        case 'c':
        {
                    // test menu command 'c' handler:
                    // helpString='c -- NOP'
                    // CMD_='CMD_1100_xxxx_xxxx_xxxx_NOP'
                    // CommandName='NOP'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("NOP");
                    // call function NOP
                    uint8_t result = g_MAX5171_device.NOP();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
        } // end case 'c'
        break;
        case 'd':
        {
                    // test menu command 'd' handler:
                    // helpString='d -- SHUTDOWN'
                    // CMD_='CMD_1101_xxxx_xxxx_xxxx_SHUTDOWN'
                    // CommandName='SHUTDOWN'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("SHUTDOWN");
                    // call function SHUTDOWN
                    uint8_t result = g_MAX5171_device.SHUTDOWN();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
        } // end case 'd'
        break;
        case 'e': // (multiple characters) (testMenuFirstCharHandler="e"):
        {
            switch (cmdLine[1])
            {
                case '0': // (nested inside case 'e')
                {
                    // test menu command 'e0' handler:
                    // helpString='e0 -- UPO_LOW'
                    // CMD_='CMD_1110_0xxx_xxxx_xxxx_UPO_LOW'
                    // CommandName='UPO_LOW'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("UPO_LOW");
                    // call function UPO_LOW
                    uint8_t result = g_MAX5171_device.UPO_LOW();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
                } // end nested case 'e0'
                break;
                case '8': // (nested inside case 'e')
                {
                    // test menu command 'e8' handler:
                    // helpString='e8 -- UPO_HIGH'
                    // CMD_='CMD_1110_1xxx_xxxx_xxxx_UPO_HIGH'
                    // CommandName='UPO_HIGH'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("UPO_HIGH");
                    // call function UPO_HIGH
                    uint8_t result = g_MAX5171_device.UPO_HIGH();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
                } // end nested case 'e8'
                break;
            } // end nested switch (cmdLine[1]) inside case 'e'
            break;
        } // end case 'e'
        case 'f': // (multiple characters) (testMenuFirstCharHandler="f"):
        {
            switch (cmdLine[1])
            {
                case '0': // (nested inside case 'f')
                {
                    // test menu command 'f0' handler:
                    // helpString='f0 -- MODE1_DOUT_SCLK_RISING_EDGE'
                    // CMD_='CMD_1111_0xxx_xxxx_xxxx_MODE1_DOUT_SCLK_RISING_EDGE'
                    // CommandName='MODE1_DOUT_SCLK_RISING_EDGE'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("MODE1_DOUT_SCLK_RISING_EDGE");
                    // call function MODE1_DOUT_SCLK_RISING_EDGE
                    uint8_t result = g_MAX5171_device.MODE1_DOUT_SCLK_RISING_EDGE();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
                } // end nested case 'f0'
                break;
                case '8': // (nested inside case 'f')
                {
                    // test menu command 'f8' handler:
                    // helpString='f8 -- MODE0_DOUT_SCLK_FALLING_EDGE'
                    // CMD_='CMD_1111_1xxx_xxxx_xxxx_MODE0_DOUT_SCLK_FALLING_EDGE'
                    // CommandName='MODE0_DOUT_SCLK_FALLING_EDGE'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("MODE0_DOUT_SCLK_FALLING_EDGE");
                    // call function MODE0_DOUT_SCLK_FALLING_EDGE
                    uint8_t result = g_MAX5171_device.MODE0_DOUT_SCLK_FALLING_EDGE();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX5171
                } // end nested case 'f8'
                break;
            } // end nested switch (cmdLine[1]) inside case 'f'
            break;
        } // end case 'f'
    } // end switch (cmdLine[0])
    return false; // command not handled by MAX5171
} // end bool MAX5171_menu_onEOLcommandParser(CmdLine & cmdLine)

