// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate
#include "MAX5171.h"

// example code board support
//MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
//DigitalOut rLED(LED1);
//DigitalOut gLED(LED2);
//DigitalOut bLED(LED3);
//
// Arduino "shield" connector port definitions (MAX32625MBED shown)
#if defined(TARGET_MAX32625MBED)
#define A0 AIN_0
#define A1 AIN_1
#define A2 AIN_2
#define A3 AIN_3
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P0_4
#define D5 P0_5
#define D6 P0_6
#define D7 P0_7
#define D8 P1_4
#define D9 P1_5
#define D10 P1_3
#define D11 P1_1
#define D12 P1_2
#define D13 P1_0
#endif

// example code declare SPI interface (GPIO controlled CS)
#if defined(TARGET_MAX32625MBED)
SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
#elif defined(TARGET_MAX32600MBED)
SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// TODO1: avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
// void spi_init(spi_t *obj, PinName mosi, PinName miso, PinName sclk, PinName ssel)
//
// TODO1: NUCLEO_F446RE SPI not working; CS and MOSI data looks OK but no SCLK clock pulses.
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk spi1 TARGET_NUCLEO_F446RE: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI_CS); // TARGET_NUCLEO_F446RE: PB_6 Arduino 10-pin header D10
//
#else
SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
#endif

// example code declare GPIO interface pins
// AnalogOut FB_pin(Px_x_PortName_To_Be_Determined); // Analog Input to MAX5171 device
DigitalOut RS_pin(D9); // Digital Configuration Input to MAX5171 device
DigitalOut PDLb_pin(D8); // Digital Configuration Input to MAX5171 device
DigitalOut CLRb_pin(D7); // Digital Configuration Input to MAX5171 device
DigitalOut SHDN_pin(D6); // Digital Configuration Input to MAX5171 device
// AnalogIn OUT_pin(A0); // Analog Output from MAX5171 device
DigitalIn UPO_pin(D5); // Digital General-Purpose Output from MAX5171 device
// example code declare device instance
MAX5171 g_MAX5171_device(spi, spi_cs, RS_pin, PDLb_pin, CLRb_pin, SHDN_pin, UPO_pin, MAX5171::MAX5171_IC);

// example code main function
int main()
{
    g_MAX5171_device.Init();

    while (1)
    {
        uint16_t code;
        //
        // example #1
        code = 0x3fff; // 100.0% of full scale REF(2.50V) = 2.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 5.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #2
        code = 0x3998; // 90.0% of full scale REF(2.50V) = 2.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #3
        code = 0x3332; // 80.0% of full scale REF(2.50V) = 2.00V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #4
        code = 0x2ccc; // 70.0% of full scale REF(2.50V) = 1.75V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #5
        code = 0x2665; // 60.0% of full scale REF(2.50V) = 1.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #6
        code = 0x1fff; // 50.0% of full scale REF(2.50V) = 1.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #7
        code = 0x1999; // 40.0% of full scale REF(2.50V) = 1.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #8
        code = 0x1332; // 30.0% of full scale REF(2.50V) = 0.75V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #9
        code = 0x0ccc; // 20.0% of full scale REF(2.50V) = 0.50V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #10
        code = 0x0666; // 10.0% of full scale REF(2.50V) = 0.25V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #11
        code = 0x0000; // 0.0% of full scale REF(2.50V) = 0.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #12
        code = 0x0000; // 0.0% of full scale REF(2.50V) = 0.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #13
        code = 0x0666; // 10.0% of full scale REF(2.50V) = 0.25V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #14
        code = 0x0ccc; // 20.0% of full scale REF(2.50V) = 0.50V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #15
        code = 0x1332; // 30.0% of full scale REF(2.50V) = 0.75V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #16
        code = 0x1999; // 40.0% of full scale REF(2.50V) = 1.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #17
        code = 0x1fff; // 50.0% of full scale REF(2.50V) = 1.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #18
        code = 0x2665; // 60.0% of full scale REF(2.50V) = 1.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #19
        code = 0x2ccc; // 70.0% of full scale REF(2.50V) = 1.75V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #20
        code = 0x3332; // 80.0% of full scale REF(2.50V) = 2.00V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #21
        code = 0x3998; // 90.0% of full scale REF(2.50V) = 2.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.50V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)
        //
        // example #22
        code = 0x3fff; // 100.0% of full scale REF(2.50V) = 2.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 5.00V)
        g_MAX5171_device.CODE_LOAD(code);
        wait_ms(3000); // wait_ms(unsigned long interval_msec)

        // wait(3.0);
    }
}
