// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX5171.h
// *********************************************************************
// Header file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example
// Device Name = MAX5171
// Device Description = Low-Power, Serial, 14-Bit, 1-Channel DACs with Force/Sense Voltage Output and SPI Interface
// Device DeviceBriefDescription = 14-bit Force/Sense DAC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX5171AEEE+
// Device RegValue_Width = DataWidth16bit_HL
//
// DAC NumChannels = 1
// DAC ResolutionBits = 14
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 10
// SPI SCLKMinMHz = 0
//


// Prevent multiple declaration
#ifndef __MAX5171_H__
#define __MAX5171_H__

// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate

/**
 * @brief MAX5171 Low-Power, Serial, 14-Bit, 1-Channel DACs with Force/Sense Voltage Output and SPI Interface
 *
 *
 *
 * Datasheet: https://www.maximintegrated.com/MAX5171
 *
 *
 *
 * @code
 * // example code includes
 * // standard include for target platform -- Platform_Include_Boilerplate
 * #include "mbed.h"
 * // Platforms:
 * //   - MAX32625MBED
 * //      - supports mbed-os-5.11, requires USBDevice library
 * //      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32600MBED
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
 * //   - NUCLEO_F446RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - NUCLEO_F401RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32630FTHR
 * //      - #include "max32630fthr.h"
 * //      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32620FTHR
 * //      - #include "MAX32620FTHR.h"
 * //      - remove max32630fthr library (if present)
 * //      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
 * //      - not tested yet
 * //   - MAX32625PICO
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - not tested yet
 * //
 * // end Platform_Include_Boilerplate
 * #include "MAX5171.h"
 *
 * // example code board support
 * //MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 * //DigitalOut rLED(LED1);
 * //DigitalOut gLED(LED2);
 * //DigitalOut bLED(LED3);
 * //
 * // Arduino "shield" connector port definitions (MAX32625MBED shown)
 * #if defined(TARGET_MAX32625MBED)
 * #define A0 AIN_0
 * #define A1 AIN_1
 * #define A2 AIN_2
 * #define A3 AIN_3
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P0_4
 * #define D5 P0_5
 * #define D6 P0_6
 * #define D7 P0_7
 * #define D8 P1_4
 * #define D9 P1_5
 * #define D10 P1_3
 * #define D11 P1_1
 * #define D12 P1_2
 * #define D13 P1_0
 * #endif
 *
 * // example code declare SPI interface (GPIO controlled CS)
 * #if defined(TARGET_MAX32625MBED)
 * SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
 * #elif defined(TARGET_MAX32600MBED)
 * SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
 * #elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
 * // TODO1: avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
 * // void spi_init(spi_t *obj, PinName mosi, PinName miso, PinName sclk, PinName ssel)
 * //
 * // TODO1: NUCLEO_F446RE SPI not working; CS and MOSI data looks OK but no SCLK clock pulses.
 * SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk spi1 TARGET_NUCLEO_F446RE: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI_CS); // TARGET_NUCLEO_F446RE: PB_6 Arduino 10-pin header D10
 * //
 * #else
 * SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
 * #endif
 *
 * // example code declare GPIO interface pins
 * // AnalogOut FB_pin(Px_x_PortName_To_Be_Determined); // Analog Input to MAX5171 device
 * DigitalOut RS_pin(D9); // Digital Configuration Input to MAX5171 device
 * DigitalOut PDLb_pin(D8); // Digital Configuration Input to MAX5171 device
 * DigitalOut CLRb_pin(D7); // Digital Configuration Input to MAX5171 device
 * DigitalOut SHDN_pin(D6); // Digital Configuration Input to MAX5171 device
 * // AnalogIn OUT_pin(A0); // Analog Output from MAX5171 device
 * DigitalIn UPO_pin(D5); // Digital General-Purpose Output from MAX5171 device
 * // example code declare device instance
 * MAX5171 g_MAX5171_device(spi, spi_cs, RS_pin, PDLb_pin, CLRb_pin, SHDN_pin, UPO_pin, MAX5171::MAX5171_IC);
 *
 * // example code main function
 * int main()
 * {
 *     g_MAX5171_device.Init();
 *
 *     while (1)
 *     {
 *         uint16_t code;
 *         //
 *         // example #1
 *         code = 0x3fff; // 100.0% of full scale REF(2.50V) = 2.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 5.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #2
 *         code = 0x3998; // 90.0% of full scale REF(2.50V) = 2.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #3
 *         code = 0x3332; // 80.0% of full scale REF(2.50V) = 2.00V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #4
 *         code = 0x2ccc; // 70.0% of full scale REF(2.50V) = 1.75V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #5
 *         code = 0x2665; // 60.0% of full scale REF(2.50V) = 1.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #6
 *         code = 0x1fff; // 50.0% of full scale REF(2.50V) = 1.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #7
 *         code = 0x1999; // 40.0% of full scale REF(2.50V) = 1.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #8
 *         code = 0x1332; // 30.0% of full scale REF(2.50V) = 0.75V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #9
 *         code = 0x0ccc; // 20.0% of full scale REF(2.50V) = 0.50V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #10
 *         code = 0x0666; // 10.0% of full scale REF(2.50V) = 0.25V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #11
 *         code = 0x0000; // 0.0% of full scale REF(2.50V) = 0.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #12
 *         code = 0x0000; // 0.0% of full scale REF(2.50V) = 0.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #13
 *         code = 0x0666; // 10.0% of full scale REF(2.50V) = 0.25V (FB=1-2:FORCE_BIP/SENSE_BIP: -2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 0.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #14
 *         code = 0x0ccc; // 20.0% of full scale REF(2.50V) = 0.50V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #15
 *         code = 0x1332; // 30.0% of full scale REF(2.50V) = 0.75V (FB=1-2:FORCE_BIP/SENSE_BIP: -1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 1.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #16
 *         code = 0x1999; // 40.0% of full scale REF(2.50V) = 1.00V (FB=1-2:FORCE_BIP/SENSE_BIP: -0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #17
 *         code = 0x1fff; // 50.0% of full scale REF(2.50V) = 1.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 2.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #18
 *         code = 0x2665; // 60.0% of full scale REF(2.50V) = 1.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 0.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #19
 *         code = 0x2ccc; // 70.0% of full scale REF(2.50V) = 1.75V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 3.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #20
 *         code = 0x3332; // 80.0% of full scale REF(2.50V) = 2.00V (FB=1-2:FORCE_BIP/SENSE_BIP: 1.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #21
 *         code = 0x3998; // 90.0% of full scale REF(2.50V) = 2.25V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.00V) (FB=2-3:FORCE_UNI/SENSE_UNI: 4.50V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *         //
 *         // example #22
 *         code = 0x3fff; // 100.0% of full scale REF(2.50V) = 2.50V (FB=1-2:FORCE_BIP/SENSE_BIP: 2.50V) (FB=2-3:FORCE_UNI/SENSE_UNI: 5.00V)
 *         g_MAX5171_device.CODE_LOAD(code);
 *         wait_ms(3000); // wait_ms(unsigned long interval_msec)
 *
 *         // wait(3.0);
 *     }
 * }
 * @endcode
 */
class MAX5171 {
public:
    //----------------------------------------
    /// Command Codes (first byte)
    ///
    /// Naming convention is CMD_bitstream_FUNCTION_NAME
    /// - dd_dddd_dddd_dddd = data field
    /// - xxxx = don't care
    typedef enum MAX5171_CMD_enum_t {
        CMD_00dd_dddd_dddd_dddd_CODE = 0x0000, //!< 0b0000000000000000
        CMD_01dd_dddd_dddd_dddd_CODE_LOAD = 0x4000, //!< 0b0100000000000000
        CMD_10xx_xxxx_xxxx_xxxx_LOAD = 0x8000, //!< 0b1000000000000000
        CMD_1100_xxxx_xxxx_xxxx_NOP = 0xc000, //!< 0b1100000000000000
        CMD_1101_xxxx_xxxx_xxxx_SHUTDOWN = 0xd000, //!< 0b1101000000000000
        CMD_1110_0xxx_xxxx_xxxx_UPO_LOW = 0xe000, //!< 0b1110000000000000
        CMD_1110_1xxx_xxxx_xxxx_UPO_HIGH = 0xe800, //!< 0b1110100000000000
        CMD_1111_0xxx_xxxx_xxxx_MODE1_DOUT_SCLK_RISING_EDGE = 0xf000, //!< 0b1111000000000000
        CMD_1111_1xxx_xxxx_xxxx_MODE0_DOUT_SCLK_FALLING_EDGE = 0xf800, //!< 0b1111100000000000
    } MAX5171_CMD_enum_t;

    /**
     * @brief IC's supported with this driver
     * @details MAX5171
     */
    typedef enum
    {
        MAX5171_IC = 0,
        //MAX5171_IC = 1
    } MAX5171_ic_t;

    /**********************************************************//**
    * @brief Constructor for MAX5171 Class.
    *
    * @details Requires an existing SPI object as well as a DigitalOut object.
    * The DigitalOut object is used for a chip enable signal
    *
    * On Entry:
    *     @param[in] spi - pointer to existing SPI object
    *     @param[in] cs_pin - pointer to a DigitalOut pin object
    *     @param[in] RS_pin - pointer to a DigitalOut pin object
    *     @param[in] PDLb_pin - pointer to a DigitalOut pin object
    *     @param[in] CLRb_pin - pointer to a DigitalOut pin object
    *     @param[in] SHDN_pin - pointer to a DigitalOut pin object
    *     @param[in] UPO_pin - pointer to a DigitalIn pin object
    *     @param[in] ic_variant - which type of MAX5171 is used
    *
    * On Exit:
    *
    * @return None
    **************************************************************/
    MAX5171(SPI &spi, DigitalOut &cs_pin, // SPI interface
            // AnalogOut &FB_pin, // Analog Input to MAX5171 device
            DigitalOut &RS_pin, // Digital Configuration Input to MAX5171 device
            DigitalOut &PDLb_pin, // Digital Configuration Input to MAX5171 device
            DigitalOut &CLRb_pin, // Digital Configuration Input to MAX5171 device
            DigitalOut &SHDN_pin, // Digital Configuration Input to MAX5171 device
            // AnalogIn &OUT_pin, // Analog Output from MAX5171 device
            DigitalIn &UPO_pin, // Digital General-Purpose Output from MAX5171 device
            MAX5171_ic_t ic_variant);

    /************************************************************
     * @brief Default destructor for MAX5171 Class.
     *
     * @details Destroys SPI object if owner
     *
     * On Entry:
     *
     * On Exit:
     *
     * @return None
     **************************************************************/
    ~MAX5171();

    /// Function pointer void f(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
    Callback<void(size_t, uint8_t*, uint8_t*)> onSPIprint; //!< optional @ref onSPIprint SPI diagnostic function

    /// set SPI SCLK frequency
    void spi_frequency(int spi_sclk_Hz);

    /// get SPI SCLK frequency
    int get_spi_frequency() const { return m_SPI_SCLK_Hz; }

    /// get SPI mode
    int get_spi_dataMode() const { return m_SPI_dataMode; }

//----------------------------------------
public:

    /// reference voltage, in Volts
    double VRef;

    /// shadow of dacCodeLsbs; write-only dacCodeLsbs field CMD_00dd_dddd_dddd_dddd_CODE or CMD_01dd_dddd_dddd_dddd_CODE_LOAD
    int16_t DACCode;


//----------------------------------------
// Assert SPI Chip Select
// SPI chip-select for MAX5171
//
    void SPIoutputCS(int isLogicHigh);

//----------------------------------------
// SPI write 16 bits
// SPI interface to MAX5171 shift 16 bits mosiData into MAX5171 DIN
//
    void SPIwrite16bits(int16_t mosiData16);

private:
    // SPI object
    SPI &m_spi;
    int m_SPI_SCLK_Hz;
    int m_SPI_dataMode;
    int m_SPI_cs_state;

    // Selector pin object
    DigitalOut &m_cs_pin;

// InputPin Name = FB
// InputPin Description = Feedback Input
// InputPin Function = Analog
//
// InputPin Name = RS
// InputPin Description = Reset Mode Select (digital input). Connect to VDD to select midscale reset output value. Connect to DGND
// to select 0 reset output value.
// InputPin Function = Configuration
    DigitalOut &m_RS_pin;
//
// InputPin Name = PDL#
// InputPin Description = Power-Down Lockout (digital input). Connect to VDD to allow shutdown. Connect to DGND to disable shutdown.
// InputPin Function = Configuration
    DigitalOut &m_PDLb_pin;
//
// InputPin Name = CLR#
// InputPin Description = Clear DAC (digital input). Clears the DAC to its predetermined output state as set by RS.
// InputPin Function = Configuration
    DigitalOut &m_CLRb_pin;
//
// InputPin Name = SHDN
// InputPin Description = Shutdown (digital input). Pulling SHDN high when PDL = VDD places the chip in shutdown mode with a
// maximum shutdown current 0f 10uA.
// InputPin Function = Configuration
    DigitalOut &m_SHDN_pin;
//
// OutputPin Name = OUT
// OutputPin Description = Analog Voltage Output. High impedance in shutdown. Output voltage is limited to VDD.
// OutputPin Function = Analog
    // AnalogIn &m_OUT_pin;
//
// OutputPin Name = UPO
// OutputPin Description = User-Programmable Output. State is set by serial input.
// OutputPin Function = General-Purpose
    DigitalIn &m_UPO_pin;
//

    // Identifies which IC variant is being used
    MAX5171_ic_t m_ic_variant;

public:

    //----------------------------------------
    /// Menu item '!'
    /// Initialize device
    ///
    /// TODO1: #170 MAX5171 Self Test for Test Fixture Firmware
    /// @future test group ____ // Verify function ____ (enabled by default)
    /// @future test
    ///     tinyTester.settle_time_msec = 250;
    ///
    /// @test group DACCodeOfVoltage // Verify function DACCodeOfVoltage (enabled by default)
    /// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group DACCodeOfVoltage tinyTester.print("VRef = 2.500  MAX5171 14-bit LSB = 0.00015V")
    /// @test group DACCodeOfVoltage VRef = 2.500
    /// @test group DACCodeOfVoltage tinyTester.err_threshold = 0.00015259720441921504 // 14-bit LSB (2.500/16383)
    ///     //
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.499847412109375) expect 0x3FFF
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.49969482421875) expect 0x3FFE
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.499542236328125) expect 0x3FFD
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(2.4993896484375) expect 0x3FFC
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.250152587890625) expect 0x2001
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.25) expect 0x2000
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.249847412109375) expect 0x1FFF
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(1.24969482421875) expect 0x1FFE
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000457763671875) expect 0x0003
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.00030517578125) expect 0x0002
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000152587890625) expect 0x0001
    /// @test group DACCodeOfVoltage DACCodeOfVoltage(0.00000) expect 0x0000
    /// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///     //
    /// @test group VoltageOfCode // Verify function VoltageOfCode (enabled by default)
    /// @test group VoltageOfCode tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group VoltageOfCode tinyTester.print("VRef = 2.500  MAX5171 14-bit LSB = 0.00015V")
    /// @test group VoltageOfCode VRef = 2.500
    /// @test group VoltageOfCode tinyTester.err_threshold = 0.00015259720441921504 // 14-bit LSB (2.500/16383)
    /// @test group VoltageOfCode VoltageOfCode(0x3FFF) expect 2.499847412109375
    /// @test group VoltageOfCode VoltageOfCode(0x3FFE) expect 2.49969482421875
    /// @test group VoltageOfCode VoltageOfCode(0x3FFD) expect 2.499542236328125
    /// @test group VoltageOfCode VoltageOfCode(0x3FFC) expect 2.4993896484375
    /// @test group VoltageOfCode VoltageOfCode(0x2001) expect 1.250152587890625
    /// @test group VoltageOfCode VoltageOfCode(0x2000) expect 1.25
    /// @test group VoltageOfCode VoltageOfCode(0x1FFF) expect 1.249847412109375
    /// @test group VoltageOfCode VoltageOfCode(0x1FFE) expect 1.24969482421875
    /// @test group VoltageOfCode VoltageOfCode(0x0003) expect 0.000457763671875
    /// @test group VoltageOfCode VoltageOfCode(0x0002) expect 0.00030517578125
    /// @test group VoltageOfCode VoltageOfCode(0x0001) expect 0.000152587890625
    /// @test group VoltageOfCode VoltageOfCode(0x0000) expect 0.00000
    /// @test group VoltageOfCode tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///     //
    ///     // Device Testing: DAC commands, verify using on-board ADC inputs
    ///     //
    /// @test group CODE_LOAD // Verify function CODE_LOAD (enabled by default)
    /// @test group CODE_LOAD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    /// @test group CODE_LOAD tinyTester.settle_time_msec = 500
    ///     tinyTester.blink_time_msec = 75;
    ///     cmdLine.serial().printf("
    ///       MAX5171.Init()");
    ///     g_MAX5171_device.Init();
    /// @test Init()
    /// @test VRef expect 2.500 // Nominal Full-Scale Voltage Reference
    ///     //
    ///     tinyTester.err_threshold = 0.030; // 30mV
    /// @test group CODE_LOAD tinyTester.err_threshold = 0.050
    ///     uint16_t code = 0x3FFF;
    ///     //~ double voltageV = 0.5;
    ///     //
    ///     cmdLine.serial().printf("
    ///       MAX5171.CODE_LOAD code=%d", code);
    ///     g_MAX5171_device.CODE_LOAD(code);
    /// @test group CODE_LOAD tinyTester.print("100.0% of full scale REF(2.50V) = 2.50V Jumper FB=1-2")
    /// @test group CODE_LOAD CODE_LOAD(0x3FFF) // 100.0% of full scale REF(2.50V) = 2.50V
    ///     // tinyTester.Wait_Output_Settling replaces wait_ms
    ///     tinyTester.Wait_Output_Settling();
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    ///     // tinyTester.AnalogIn0_Read_Expect_voltageV replaces SelfTest_AnalogInput_Expect_ch_V
    ///     tinyTester.AnalogIn0_Read_Expect_voltageV(2.500);
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.500)
    ///     //
    ///     code = 0x0000;
    ///     cmdLine.serial().printf("
    ///       MAX5171.CODE_LOAD code=%d", code);
    ///     g_MAX5171_device.CODE_LOAD(code);
    /// @test group CODE_LOAD tinyTester.print("0.0% of full scale REF(2.50V) = 0.000V")
    /// @test group CODE_LOAD CODE_LOAD(0x0000) // 0.0% of full scale REF(2.50V) = 0.000V
    ///     // tinyTester.Wait_Output_Settling replaces wait_ms
    ///     tinyTester.Wait_Output_Settling();
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    ///     // tinyTester.AnalogIn0_Read_Expect_voltageV replaces SelfTest_AnalogInput_Expect_ch_V
    ///     tinyTester.AnalogIn0_Read_Expect_voltageV(0.0000);
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.0000)
    ///     //
    ///     code = 0x1FFF;
    ///     cmdLine.serial().printf("
    ///       MAX5171.CODE_LOAD code=%d", code);
    ///     g_MAX5171_device.CODE_LOAD(code);
    /// @test group CODE_LOAD tinyTester.print("50.0% of full scale REF(2.50V) = 1.25V")
    /// @test group CODE_LOAD CODE_LOAD(0x1FFF) // 50.0% of full scale REF(2.50V) = 1.25V
    ///     // tinyTester.Wait_Output_Settling replaces wait_ms
    ///     tinyTester.Wait_Output_Settling();
    /// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
    ///     // tinyTester.AnalogIn0_Read_Expect_voltageV replaces SelfTest_AnalogInput_Expect_ch_V
    ///     tinyTester.AnalogIn0_Read_Expect_voltageV(1.2500);
    /// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.2500)
    ///     //
    ///     // test UPO User Programmable Output, verify using digital input D2
    ///     //
    /// @test group UPO // Verify User Programmable Output functions UPO_HIGH and UPO_LOW (enabled by default)
    /// @test group UPO tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    /// @test group UPO tinyTester.settle_time_msec = 500 // default 250
    ///     cmdLine.serial().printf("
    ///       MAX5171.UPO_HIGH");
    ///     g_MAX5171_device.UPO_HIGH();
    /// @test group UPO UPO_HIGH()
    ///     tinyTester.Wait_Output_Settling();
    /// @test group UPO tinyTester.Wait_Output_Settling()
    ///     // tinyTester.DigitalIn_Read_Expect_WarnOnly replaces SelfTest_Expect_Input_UPO_pin
    ///     tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command");
    /// @test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command")
    ///     //
    ///     cmdLine.serial().printf("
    ///       MAX5171.UPO_LOW");
    ///     g_MAX5171_device.UPO_LOW();
    /// @test group UPO UPO_LOW()
    ///     tinyTester.Wait_Output_Settling();
    /// @test group UPO tinyTester.Wait_Output_Settling()
    ///     // tinyTester.DigitalIn_Read_Expect_WarnOnly replaces SelfTest_Expect_Input_UPO_pin
    ///     tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 0, "UPO_pin is low after MAX5171 UPO_LOW command");
    /// @test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 0, "UPO_pin is low after MAX5171 UPO_LOW command")
    ///     //
    ///     cmdLine.serial().printf("
    ///       MAX5171.UPO_HIGH");
    ///     g_MAX5171_device.UPO_HIGH();
    /// @test group UPO UPO_HIGH()
    ///     tinyTester.Wait_Output_Settling();
    /// @test group UPO tinyTester.Wait_Output_Settling()
    ///     // tinyTester.DigitalIn_Read_Expect_WarnOnly replaces SelfTest_Expect_Input_UPO_pin
    ///     tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command");
    /// @test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command")
    ///     //
    ///
    ///
    void Init(void);

    //----------------------------------------
    /// Return the DAC register value corresponding to physical voltage.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre g_MAX5171_device.VRef = Voltage of REF input, in Volts
    /// @param[in] voltage = physical voltage in Volts
    /// @return raw 14-bit MAX5171 code (right justified).
    uint16_t DACCodeOfVoltage(double voltageV);

    //----------------------------------------
    /// Return the physical voltage corresponding to DAC register.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre g_MAX5171_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u14: raw 14-bit MAX5171 code (right justified).
    /// @return physical voltage corresponding to MAX5171 code.
    double VoltageOfCode(uint16_t value_u14);

    //----------------------------------------
    /// CMD_00dd_dddd_dddd_dddd_CODE
    ///
    /// Load input register; DAC registers are unchanged.
    /// @return 1 on success; 0 on failure
    uint8_t CODE(uint16_t dacCodeLsbs);

    //----------------------------------------
    /// CMD_01dd_dddd_dddd_dddd_CODE_LOAD
    ///
    /// Load input register; DAC registers are updated (start up DAC with new data).
    /// @return 1 on success; 0 on failure
    uint8_t CODE_LOAD(uint16_t dacCodeLsbs);

    //----------------------------------------
    /// CMD_10xx_xxxx_xxxx_xxxx_LOAD
    ///
    /// Update DAC register from input register (start up DAC with data previously
    /// stored in the input registers).
    /// @return 1 on success; 0 on failure
    uint8_t LOAD(void);

    //----------------------------------------
    /// CMD_1100_xxxx_xxxx_xxxx_NOP
    ///
    /// No operation (NOP).
    /// @return 1 on success; 0 on failure
    uint8_t NOP(void);

    //----------------------------------------
    /// CMD_1101_xxxx_xxxx_xxxx_SHUTDOWN
    ///
    /// Shut down DAC (provided PDL# = 1).
    /// @return 1 on success; 0 on failure
    uint8_t SHUTDOWN(void);

    //----------------------------------------
    /// CMD_1110_0xxx_xxxx_xxxx_UPO_LOW
    ///
    /// UPO goes low (default).
    /// @return 1 on success; 0 on failure
    uint8_t UPO_LOW(void);

    //----------------------------------------
    /// CMD_1110_1xxx_xxxx_xxxx_UPO_HIGH
    ///
    /// UPO goes high.
    /// @return 1 on success; 0 on failure
    uint8_t UPO_HIGH(void);

    //----------------------------------------
    /// CMD_1111_0xxx_xxxx_xxxx_MODE1_DOUT_SCLK_RISING_EDGE
    ///
    /// Mode 1, DOUT clocked out on SCLK's rising edge.
    /// @return 1 on success; 0 on failure
    uint8_t MODE1_DOUT_SCLK_RISING_EDGE(void);

    //----------------------------------------
    /// CMD_1111_1xxx_xxxx_xxxx_MODE0_DOUT_SCLK_FALLING_EDGE
    ///
    /// Mode 0, DOUT clocked out on SCLK's falling edge (default).
    /// @return 1 on success; 0 on failure
    uint8_t MODE0_DOUT_SCLK_FALLING_EDGE(void);

}; // end of class MAX5171

#endif // __MAX5171_H__

// End of file
