// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX5171.cpp
// *********************************************************************
// Device Driver file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example

#include "MAX5171.h"

// Device Name = MAX5171
// Device Description = Low-Power, Serial, 14-Bit, 1-Channel DACs with Force/Sense Voltage Output and SPI Interface
// Device DeviceBriefDescription = 14-bit Force/Sense DAC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX5171AEEE+
// Device RegValue_Width = DataWidth16bit_HL
//
// DAC NumChannels = 1
// DAC ResolutionBits = 14
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 10
// SPI SCLKMinMHz = 0
//
// InputPin Name = FB
// InputPin Description = Feedback Input
// InputPin Function = Analog
//
// InputPin Name = RS
// InputPin Description = Reset Mode Select (digital input). Connect to VDD to select midscale reset output value. Connect to DGND
// to select 0 reset output value.
// InputPin Function = Configuration
//
// InputPin Name = PDL#
// InputPin Description = Power-Down Lockout (digital input). Connect to VDD to allow shutdown. Connect to DGND to disable shutdown.
// InputPin Function = Configuration
//
// InputPin Name = CLR#
// InputPin Description = Clear DAC (digital input). Clears the DAC to its predetermined output state as set by RS.
// InputPin Function = Configuration
//
// InputPin Name = SHDN
// InputPin Description = Shutdown (digital input). Pulling SHDN high when PDL = VDD places the chip in shutdown mode with a
// maximum shutdown current 0f 10uA.
// InputPin Function = Configuration
//
// OutputPin Name = OUT
// OutputPin Description = Analog Voltage Output. High impedance in shutdown. Output voltage is limited to VDD.
// OutputPin Function = Analog
//
// OutputPin Name = UPO
// OutputPin Description = User-Programmable Output. State is set by serial input.
// OutputPin Function = General-Purpose
//
// SupplyPin Name = VDD
// SupplyPin Description = Positive Supply. Bypass to AGND with a 4.7uF capacitor in parallel with a 0.1uF capacitor.
// SupplyPin VinMax = 4.50
// SupplyPin VinMin = 5.50
// SupplyPin Function = Analog
//
// SupplyPin Name = REF
// SupplyPin Description = Reference Input. Maximum VREF is VDD - 1.4V. Connect an external +2.5V reference.
// SupplyPin VinMax = VDD-1.4
// SupplyPin VinMin = 0
// SupplyPin Function = Analog
//
// SupplyPin Name = DGND
// SupplyPin Description = Digital Ground.
// SupplyPin VinMax = 0
// SupplyPin VinMin = 0
// SupplyPin Function = Analog
//
// SupplyPin Name = AGND
// SupplyPin Description = Analog Ground.
// SupplyPin VinMax = 0
// SupplyPin VinMin = 0
// SupplyPin Function = Analog
//

MAX5171::MAX5171(SPI &spi, DigitalOut &cs_pin, // SPI interface
                 // AnalogOut &FB_pin, // Analog Input to MAX5171 device
                 DigitalOut &RS_pin, // Digital Configuration Input to MAX5171 device
                 DigitalOut &PDLb_pin, // Digital Configuration Input to MAX5171 device
                 DigitalOut &CLRb_pin, // Digital Configuration Input to MAX5171 device
                 DigitalOut &SHDN_pin, // Digital Configuration Input to MAX5171 device
                 // AnalogIn &OUT_pin, // Analog Output from MAX5171 device
                 DigitalIn &UPO_pin, // Digital General-Purpose Output from MAX5171 device
                 MAX5171_ic_t ic_variant)
    : m_spi(spi), m_cs_pin(cs_pin), // SPI interface
    // m_FB_pin(FB_pin), // Analog Input to MAX5171 device
    m_RS_pin(RS_pin), // Digital Configuration Input to MAX5171 device
    m_PDLb_pin(PDLb_pin), // Digital Configuration Input to MAX5171 device
    m_CLRb_pin(CLRb_pin), // Digital Configuration Input to MAX5171 device
    m_SHDN_pin(SHDN_pin), // Digital Configuration Input to MAX5171 device
    // m_OUT_pin(OUT_pin), // Analog Output from MAX5171 device
    m_UPO_pin(UPO_pin), // Digital General-Purpose Output from MAX5171 device
    m_ic_variant(ic_variant)
{
    // SPI CS = ActiveLow
    // SPI FrameStart = CS
    m_SPI_cs_state = 1;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }

    // SPI CPOL = 0
    // SPI CPHA = 0
    // SPI MOSI and MISO Data are both stable on Rising edge of SCLK
    // SPI SCLK Idle Low
    m_SPI_dataMode = 0; //SPI_MODE0; // CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
    m_spi.format(8,m_SPI_dataMode);         // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0

    // SPI SCLKMaxMHz = 10
    // SPI SCLKMinMHz = 0
    //#define SPI_SCLK_Hz 48000000 // 48MHz
    //#define SPI_SCLK_Hz 24000000 // 24MHz
    //#define SPI_SCLK_Hz 12000000 // 12MHz
    //#define SPI_SCLK_Hz 6000000 // 6MHz
    //#define SPI_SCLK_Hz 4000000 // 4MHz
    //#define SPI_SCLK_Hz 2000000 // 2MHz
    //#define SPI_SCLK_Hz 1000000 // 1MHz
    m_SPI_SCLK_Hz = 10000000; // 10MHz; MAX5171 limit is 10MHz
    m_spi.frequency(m_SPI_SCLK_Hz);

    //
    // FB Analog Input to MAX5171 device
    //
    // RS Configuration Input to MAX5171 device
    m_RS_pin = 1; // output logic high -- initial value in constructor
    //
    // PDLb Configuration Input to MAX5171 device
    m_PDLb_pin = 1; // output logic high -- initial value in constructor
    //
    // CLRb Configuration Input to MAX5171 device
    m_CLRb_pin = 1; // output logic high -- initial value in constructor
    //
    // SHDN Configuration Input to MAX5171 device
    m_SHDN_pin = 1; // output logic high -- initial value in constructor
    //
    // OUT Analog Output from device
    //
    // UPO General-Purpose Output from device
}

MAX5171::~MAX5171()
{
    // do nothing
}

/// set SPI SCLK frequency
void MAX5171::spi_frequency(int spi_sclk_Hz)
{
    m_SPI_SCLK_Hz = spi_sclk_Hz;
    m_spi.frequency(m_SPI_SCLK_Hz);
}

// Assert SPI Chip Select
// SPI chip-select for MAX5171
//
inline void MAX5171::SPIoutputCS(int isLogicHigh)
{
    m_SPI_cs_state = isLogicHigh;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }
}

// SPI write 16 bits
// SPI interface to MAX5171 shift 16 bits mosiData into MAX5171 DIN
//
void MAX5171::SPIwrite16bits(int16_t mosiData16)
{
    size_t byteCount = 2;
    static char mosiData[2];
    static char misoData[2];
    mosiData[0] = (char)((mosiData16 >> 8) & 0xFF); // MSByte
    mosiData[1] = (char)((mosiData16 >> 0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ m_spi.transfer(mosiData8_FF0000);
    //~ m_spi.transfer(mosiData16_00FF00);
    //~ m_spi.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    // Optional Diagnostic function to print SPI transactions
    if (onSPIprint)
    {
        onSPIprint(byteCount, (uint8_t*)mosiData, (uint8_t*)misoData);
    }
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if 0 // HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if 0 // HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    // TODO: print_verbose_SPI_diagnostic(mosiData16_FF00, mosiData16_00FF, misoData16_FF00, misoData16_00FF);
    //
    // int misoData16 = (misoData16_FF00 << 8) | misoData16_00FF;
    // return misoData16;
}

//----------------------------------------
// Menu item '!'
// Initialize device
//
// TODO1: #170 MAX5171 Self Test for Test Fixture Firmware
// @future test group ____ // Verify function ____ (enabled by default)
// @future test
//     tinyTester.settle_time_msec = 250;
//
// @test group DACCodeOfVoltage // Verify function DACCodeOfVoltage (enabled by default)
// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group DACCodeOfVoltage tinyTester.print("VRef = 2.500  MAX5171 14-bit LSB = 0.00015V")
// @test group DACCodeOfVoltage VRef = 2.500
// @test group DACCodeOfVoltage tinyTester.err_threshold = 0.00015259720441921504 // 14-bit LSB (2.500/16383)
//     //
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.499847412109375) expect 0x3FFF
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.49969482421875) expect 0x3FFE
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.499542236328125) expect 0x3FFD
// @test group DACCodeOfVoltage DACCodeOfVoltage(2.4993896484375) expect 0x3FFC
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.250152587890625) expect 0x2001
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.25) expect 0x2000
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.249847412109375) expect 0x1FFF
// @test group DACCodeOfVoltage DACCodeOfVoltage(1.24969482421875) expect 0x1FFE
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000457763671875) expect 0x0003
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.00030517578125) expect 0x0002
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.000152587890625) expect 0x0001
// @test group DACCodeOfVoltage DACCodeOfVoltage(0.00000) expect 0x0000
// @test group DACCodeOfVoltage tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//     //
// @test group VoltageOfCode // Verify function VoltageOfCode (enabled by default)
// @test group VoltageOfCode tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group VoltageOfCode tinyTester.print("VRef = 2.500  MAX5171 14-bit LSB = 0.00015V")
// @test group VoltageOfCode VRef = 2.500
// @test group VoltageOfCode tinyTester.err_threshold = 0.00015259720441921504 // 14-bit LSB (2.500/16383)
// @test group VoltageOfCode VoltageOfCode(0x3FFF) expect 2.499847412109375
// @test group VoltageOfCode VoltageOfCode(0x3FFE) expect 2.49969482421875
// @test group VoltageOfCode VoltageOfCode(0x3FFD) expect 2.499542236328125
// @test group VoltageOfCode VoltageOfCode(0x3FFC) expect 2.4993896484375
// @test group VoltageOfCode VoltageOfCode(0x2001) expect 1.250152587890625
// @test group VoltageOfCode VoltageOfCode(0x2000) expect 1.25
// @test group VoltageOfCode VoltageOfCode(0x1FFF) expect 1.249847412109375
// @test group VoltageOfCode VoltageOfCode(0x1FFE) expect 1.24969482421875
// @test group VoltageOfCode VoltageOfCode(0x0003) expect 0.000457763671875
// @test group VoltageOfCode VoltageOfCode(0x0002) expect 0.00030517578125
// @test group VoltageOfCode VoltageOfCode(0x0001) expect 0.000152587890625
// @test group VoltageOfCode VoltageOfCode(0x0000) expect 0.00000
// @test group VoltageOfCode tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//     //
//     // Device Testing: DAC commands, verify using on-board ADC inputs
//     //
// @test group CODE_LOAD // Verify function CODE_LOAD (enabled by default)
// @test group CODE_LOAD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
// @test group CODE_LOAD tinyTester.settle_time_msec = 500
//     tinyTester.blink_time_msec = 75;
//     cmdLine.serial().printf("
//       MAX5171.Init()");
//     Init();
// @test Init()
// @test VRef expect 2.500 // Nominal Full-Scale Voltage Reference
//     //
//     tinyTester.err_threshold = 0.030; // 30mV
// @test group CODE_LOAD tinyTester.err_threshold = 0.050
//     uint16_t code = 0x3FFF;
//     //~ double voltageV = 0.5;
//     //
//     cmdLine.serial().printf("
//       MAX5171.CODE_LOAD code=%d", code);
//     CODE_LOAD(code);
// @test group CODE_LOAD tinyTester.print("100.0% of full scale REF(2.50V) = 2.50V Jumper FB=1-2")
// @test group CODE_LOAD CODE_LOAD(0x3FFF) // 100.0% of full scale REF(2.50V) = 2.50V
//     // tinyTester.Wait_Output_Settling replaces wait_ms
//     tinyTester.Wait_Output_Settling();
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
//     // tinyTester.AnalogIn0_Read_Expect_voltageV replaces SelfTest_AnalogInput_Expect_ch_V
//     tinyTester.AnalogIn0_Read_Expect_voltageV(2.500);
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(2.500)
//     //
//     code = 0x0000;
//     cmdLine.serial().printf("
//       MAX5171.CODE_LOAD code=%d", code);
//     CODE_LOAD(code);
// @test group CODE_LOAD tinyTester.print("0.0% of full scale REF(2.50V) = 0.000V")
// @test group CODE_LOAD CODE_LOAD(0x0000) // 0.0% of full scale REF(2.50V) = 0.000V
//     // tinyTester.Wait_Output_Settling replaces wait_ms
//     tinyTester.Wait_Output_Settling();
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
//     // tinyTester.AnalogIn0_Read_Expect_voltageV replaces SelfTest_AnalogInput_Expect_ch_V
//     tinyTester.AnalogIn0_Read_Expect_voltageV(0.0000);
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(0.0000)
//     //
//     code = 0x1FFF;
//     cmdLine.serial().printf("
//       MAX5171.CODE_LOAD code=%d", code);
//     CODE_LOAD(code);
// @test group CODE_LOAD tinyTester.print("50.0% of full scale REF(2.50V) = 1.25V")
// @test group CODE_LOAD CODE_LOAD(0x1FFF) // 50.0% of full scale REF(2.50V) = 1.25V
//     // tinyTester.Wait_Output_Settling replaces wait_ms
//     tinyTester.Wait_Output_Settling();
// @test group CODE_LOAD tinyTester.Wait_Output_Settling()
//     // tinyTester.AnalogIn0_Read_Expect_voltageV replaces SelfTest_AnalogInput_Expect_ch_V
//     tinyTester.AnalogIn0_Read_Expect_voltageV(1.2500);
// @test group CODE_LOAD tinyTester.AnalogIn0_Read_Expect_voltageV(1.2500)
//     //
//     // test UPO User Programmable Output, verify using digital input D2
//     //
// @test group UPO // Verify User Programmable Output functions UPO_HIGH and UPO_LOW (enabled by default)
// @test group UPO tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
// @test group UPO tinyTester.settle_time_msec = 500 // default 250
//     cmdLine.serial().printf("
//       MAX5171.UPO_HIGH");
//     UPO_HIGH();
// @test group UPO UPO_HIGH()
//     tinyTester.Wait_Output_Settling();
// @test group UPO tinyTester.Wait_Output_Settling()
//     // tinyTester.DigitalIn_Read_Expect_WarnOnly replaces SelfTest_Expect_Input_UPO_pin
//     tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command");
// @test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command")
//     //
//     cmdLine.serial().printf("
//       MAX5171.UPO_LOW");
//     UPO_LOW();
// @test group UPO UPO_LOW()
//     tinyTester.Wait_Output_Settling();
// @test group UPO tinyTester.Wait_Output_Settling()
//     // tinyTester.DigitalIn_Read_Expect_WarnOnly replaces SelfTest_Expect_Input_UPO_pin
//     tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 0, "UPO_pin is low after MAX5171 UPO_LOW command");
// @test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 0, "UPO_pin is low after MAX5171 UPO_LOW command")
//     //
//     cmdLine.serial().printf("
//       MAX5171.UPO_HIGH");
//     UPO_HIGH();
// @test group UPO UPO_HIGH()
//     tinyTester.Wait_Output_Settling();
// @test group UPO tinyTester.Wait_Output_Settling()
//     // tinyTester.DigitalIn_Read_Expect_WarnOnly replaces SelfTest_Expect_Input_UPO_pin
//     tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command");
// @test group CODE_LOAD tinyTester.DigitalIn_Read_Expect_WarnOnly(UPO_pin, "UPO", 1, "UPO_pin is high after MAX5171 UPO_HIGH command")
//     //
//
//
void MAX5171::Init(void)
{
    
    //----------------------------------------
    // Nominal Full-Scale Voltage Reference
    VRef = 2.500;
}

//----------------------------------------
// Return the DAC register value corresponding to physical voltage.
// Does not perform any offset or gain correction.
//
// @pre VRef = Voltage of REF input, in Volts
// @param[in] voltage = physical voltage in Volts
// @return raw 14-bit MAX5171 code (right justified).
uint16_t MAX5171::DACCodeOfVoltage(double voltageV)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    const double MaxScaleVoltage = VRef; // voltage of maximum code 0x3fff
    const double MinScaleVoltage = 0.0; // voltage of minimum code 0x000
    const uint16_t FULL_SCALE_CODE_14BIT = 0x3fff;
    const uint16_t MaxCode = FULL_SCALE_CODE_14BIT;
    const uint16_t MinCode = 0x000;
    double codeFraction = (voltageV - MinScaleVoltage) / (MaxScaleVoltage - MinScaleVoltage);
    double dacRegValueIdeal = ((codeFraction * (double)(MaxCode - MinCode + 1)) + MinCode + 0.5);
    uint16_t dacRegValue = (uint16_t)dacRegValueIdeal;
    if (dacRegValueIdeal > MaxCode)
    {
        dacRegValue = MaxCode;
    } else if (dacRegValueIdeal < MinCode)
    {
        dacRegValue = MinCode;
    }
    return dacRegValue;
}

//----------------------------------------
// Return the physical voltage corresponding to DAC register.
// Does not perform any offset or gain correction.
//
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u14: raw 14-bit MAX5171 code (right justified).
// @return physical voltage corresponding to MAX5171 code.
double MAX5171::VoltageOfCode(uint16_t value_u14)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    double MaxScaleVoltage = VRef; // voltage of maximum code 0x3fff
    double MinScaleVoltage = 0.0; // voltage of minimum code 0x000
    const uint16_t FULL_SCALE_CODE_14BIT = 0x3fff;
    const uint16_t MaxCode = FULL_SCALE_CODE_14BIT;
    const uint16_t MinCode = 0x000;
    double codeFraction = ((double)value_u14 - MinCode) / (MaxCode - MinCode + 1);
    return MinScaleVoltage + ((MaxScaleVoltage - MinScaleVoltage) * codeFraction);
}

//----------------------------------------
// CMD_00dd_dddd_dddd_dddd_CODE
//
// Load input register; DAC registers are unchanged.
// @return 1 on success; 0 on failure
uint8_t MAX5171::CODE(uint16_t dacCodeLsbs)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_00dd_dddd_dddd_dddd_CODE
        | ((0x3FFF & dacCodeLsbs) << 0); // left-align dddd_dddd_dddd
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // shadow of write-only register CMD_00dd_dddd_dddd_dddd_CODE
    DACCode = dacCodeLsbs;
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_01dd_dddd_dddd_dddd_CODE_LOAD
//
// Load input register; DAC registers are updated (start up DAC with new data).
// @return 1 on success; 0 on failure
uint8_t MAX5171::CODE_LOAD(uint16_t dacCodeLsbs)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_01dd_dddd_dddd_dddd_CODE_LOAD
        | ((0x3FFF & dacCodeLsbs) << 0); // left-align dddd_dddd_dddd
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // shadow of write-only register CMD_00dd_dddd_dddd_dddd_CODE
    DACCode = dacCodeLsbs;
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_10xx_xxxx_xxxx_xxxx_LOAD
//
// Update DAC register from input register (start up DAC with data previously
// stored in the input registers).
// @return 1 on success; 0 on failure
uint8_t MAX5171::LOAD(void)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_10xx_xxxx_xxxx_xxxx_LOAD;
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_1100_xxxx_xxxx_xxxx_NOP
//
// No operation (NOP).
// @return 1 on success; 0 on failure
uint8_t MAX5171::NOP(void)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_1100_xxxx_xxxx_xxxx_NOP;
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_1101_xxxx_xxxx_xxxx_SHUTDOWN
//
// Shut down DAC (provided PDL# = 1).
// @return 1 on success; 0 on failure
uint8_t MAX5171::SHUTDOWN(void)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_1101_xxxx_xxxx_xxxx_SHUTDOWN;
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_1110_0xxx_xxxx_xxxx_UPO_LOW
//
// UPO goes low (default).
// @return 1 on success; 0 on failure
uint8_t MAX5171::UPO_LOW(void)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_1110_0xxx_xxxx_xxxx_UPO_LOW;
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_1110_1xxx_xxxx_xxxx_UPO_HIGH
//
// UPO goes high.
// @return 1 on success; 0 on failure
uint8_t MAX5171::UPO_HIGH(void)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_1110_1xxx_xxxx_xxxx_UPO_HIGH;
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_1111_0xxx_xxxx_xxxx_MODE1_DOUT_SCLK_RISING_EDGE
//
// Mode 1, DOUT clocked out on SCLK's rising edge.
// @return 1 on success; 0 on failure
uint8_t MAX5171::MODE1_DOUT_SCLK_RISING_EDGE(void)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_1111_0xxx_xxxx_xxxx_MODE1_DOUT_SCLK_RISING_EDGE;
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CMD_1111_1xxx_xxxx_xxxx_MODE0_DOUT_SCLK_FALLING_EDGE
//
// Mode 0, DOUT clocked out on SCLK's falling edge (default).
// @return 1 on success; 0 on failure
uint8_t MAX5171::MODE0_DOUT_SCLK_FALLING_EDGE(void)
{
    
    //----------------------------------------
    // Define command code
    uint16_t mosiData16 = CMD_1111_1xxx_xxxx_xxxx_MODE0_DOUT_SCLK_FALLING_EDGE;
    
    //----------------------------------------
    // SPI write 16-bit mosiData16
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}


// End of file
